/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.multitap;

import java.io.Serializable;
import nintaco.input.gamepad.LagDeviceMapper;
import nintaco.input.multitap.NESFourScoreMapper;

public class Famicom4PlayersAdapterMapper
extends LagDeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int shift0;
    private final int shift1;
    private final int portIndex;
    private int shiftRegister0;
    private int shiftRegister1;
    private boolean strobe;

    public Famicom4PlayersAdapterMapper(int portIndex) {
        this.portIndex = portIndex;
        this.shift0 = portIndex << 3;
        this.shift1 = (portIndex + 2 << 3) - 1;
    }

    @Override
    public int getInputDevice() {
        return -4;
    }

    @Override
    public void writePort(int value) {
        boolean bl = this.strobe = (value & 1) == 1;
        if (this.strobe) {
            this.updateButtons();
            this.shiftRegister0 = 0xFFFFFF00 | this.buttons >> this.shift0 & 0xFF;
            this.shiftRegister1 = 0xFFFFFE00 | this.buttons >> this.shift1 & 0x1FE;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            int value = this.shiftRegister1 & 2 | this.shiftRegister0 & 1;
            if (!this.strobe) {
                this.shiftRegister0 >>= 1;
                this.shiftRegister1 >>= 1;
            }
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.portIndex == portIndex ? this.shiftRegister1 & 2 | this.shiftRegister0 & 1 : 0;
    }

    @Override
    public void render(int[] screen) {
        NESFourScoreMapper.render(screen, this.buttons);
    }
}

