/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.powerglove;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;

public class PowerGloveMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int[] buffer = new int[]{160, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255};
    private final int portIndex;
    private final int shift;
    private int latch;
    private int stream = -1;
    private int output;
    private int counter;
    private int depth = 32;
    private int roll = 32;
    private int mouseX;
    private int mouseY;
    private int gesture;
    private boolean select;
    private boolean start;
    private boolean moveIn;
    private boolean moveOut;
    private boolean rollLeft;
    private boolean rollRight;

    public PowerGloveMapper(int portIndex) {
        this.portIndex = portIndex;
        this.shift = portIndex == 0 ? 0 : 8;
    }

    @Override
    public int getInputDevice() {
        return 25;
    }

    @Override
    public void update(int buttons) {
        int bits;
        int y = buttons >> 24 & 0xFF;
        if (y < 240) {
            this.mouseX = (MathUtil.clamp(buttons >> 16 & 0xFF, 24, 235) - 24) * 112 / 211 - 54;
            this.mouseY = 34 - (MathUtil.clamp(y, 21, 158) - 21) * 73 / 137;
        }
        this.gesture = BitUtil.getBitBool(bits = buttons >> this.shift, 0) ? 15 : (BitUtil.getBitBool(bits, 1) ? 255 : 0);
        this.select = BitUtil.getBitBool(bits, 2);
        this.start = BitUtil.getBitBool(bits, 3);
        this.moveIn = BitUtil.getBitBool(bits, 4);
        this.moveOut = BitUtil.getBitBool(bits, 5);
        this.rollLeft = BitUtil.getBitBool(bits, 6);
        this.rollRight = BitUtil.getBitBool(bits, 7);
    }

    @Override
    public void writePort(int value) {
        this.latch = this.latch << 1 & 0xFE | value & 1;
        if (this.latch == 6 && this.counter == 0) {
            this.stream = -1;
        } else if (this.latch == 255) {
            this.stream = -1;
            this.counter = 1;
        } else if (this.counter != 0 && this.counter++ == 11) {
            this.stream = 0;
            this.counter = 0;
        }
    }

    private void updateBuffer() {
        this.buffer[1] = this.mouseX;
        this.buffer[2] = this.mouseY;
        if (this.moveOut) {
            if (this.depth < 127) {
                ++this.depth;
            }
        } else if (this.moveIn && this.depth > 0) {
            --this.depth;
        }
        this.buffer[3] = (this.depth >> 2) - 16 & 0xFF;
        if (this.rollLeft) {
            if (this.roll < 63) {
                ++this.roll;
            }
        } else if (this.rollRight) {
            if (this.roll > 0) {
                --this.roll;
            }
        } else if (this.roll < 32) {
            ++this.roll;
        } else if (this.roll > 32) {
            --this.roll;
        }
        this.buffer[4] = (this.roll >> 1) - 16 & 0xFF;
        this.buffer[5] = this.gesture;
        this.buffer[6] = this.start ? 130 : (this.select ? 131 : 255);
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            int data = 0;
            if (this.stream != -1) {
                if (((data = this.stream++) & 7) == 0) {
                    this.updateBuffer();
                    this.output = this.buffer[data >> 3] ^ 0xFF;
                } else if (data == 95) {
                    this.stream = 0;
                }
                data = this.output >> 7;
                this.output = this.output << 1 & 0xFF;
            }
            return data;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (this.portIndex == portIndex) {
            return this.stream != -1 ? this.output >> 7 : 0;
        }
        return 0;
    }
}

