/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.topriderbike;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class TopRiderBikeMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int MAX_STEER = 20;
    private static final int MAX_BRAKING = 20;
    private static final int MAX_ACCELERATION = 20;
    private static final int DEADZONE_MAX = 16;
    private static final int DEADZONE_MID = 10;
    private static final int DEADZONE_MIN = 4;
    private int buttons;
    private int bits;
    private int state0;
    private int state1;
    private int shiftRegister0;
    private int shiftRegister1;
    private int acceleration;
    private int braking;
    private int steer;
    private boolean strobe;

    @Override
    public int getInputDevice() {
        return 32;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
        boolean steerRight = BitUtil.getBitBool(buttons, 23);
        boolean steerLeft = BitUtil.getBitBool(buttons, 22);
        boolean wheelie = BitUtil.getBitBool(buttons, 21);
        boolean shiftGear = BitUtil.getBitBool(buttons, 20);
        boolean start = BitUtil.getBitBool(buttons, 19);
        boolean select = BitUtil.getBitBool(buttons, 18);
        boolean brake = BitUtil.getBitBool(buttons, 17);
        boolean accelerate = BitUtil.getBitBool(buttons, 16);
        if (steerLeft == steerRight) {
            if (this.steer > 0) {
                --this.steer;
            } else if (this.steer < 0) {
                ++this.steer;
            }
        } else if (steerLeft) {
            if (this.steer > -20) {
                --this.steer;
            }
        } else if (steerRight && this.steer < 20) {
            ++this.steer;
        }
        if (brake) {
            if (this.braking < 20) {
                ++this.braking;
            }
        } else if (this.braking > 0) {
            --this.braking;
        }
        if (accelerate) {
            if (this.acceleration < 20) {
                ++this.acceleration;
            }
        } else if (this.acceleration > 0) {
            --this.acceleration;
        }
        this.bits &= 0xC0;
        if (shiftGear) {
            if ((this.bits & 0x40) == 0) {
                this.bits = this.bits ^ 0x80 | 0x40;
            }
        } else {
            this.bits &= 0xBF;
        }
        if (wheelie) {
            this.bits |= 1;
        }
        if (select) {
            this.bits |= 0x20;
        }
        if (start) {
            this.bits |= 0x10;
        }
        int data = 0;
        if (this.steer > 0) {
            if (this.steer > 16) {
                data = 160;
            } else if (this.steer > 10) {
                data = 32;
            } else if (this.steer > 4) {
                data = 128;
            }
        } else if (this.steer < -16) {
            data = 80;
        } else if (this.steer < -10) {
            data = 64;
        } else if (this.steer < -4) {
            data = 256;
        }
        this.state0 = (this.bits & 1) << 11 | (this.bits & 0x80) << 3 | data;
        data = 0;
        if (this.acceleration > 8 || this.braking < 8) {
            if (this.acceleration > 16) {
                data = 8;
            } else if (this.acceleration > 10) {
                data = 128;
            } else if (this.acceleration > 4) {
                data = 256;
            }
        } else {
            this.state0 |= 0x200;
            if (this.braking > 16) {
                data = 16;
            } else if (this.braking > 10) {
                data = 32;
            } else if (this.braking > 4) {
                data = 64;
            }
        }
        this.state1 = (this.bits & 0x30) << 5 | data;
    }

    @Override
    public void writePort(int value) {
        boolean priorStrobe = this.strobe;
        this.strobe = BitUtil.getBitBool(value, 0);
        if (priorStrobe && !this.strobe) {
            this.shiftRegister0 = this.state0;
            this.shiftRegister1 = this.state1;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            int value = this.shiftRegister0 & 0x10 | this.shiftRegister1 & 8;
            this.shiftRegister0 >>= 1;
            this.shiftRegister1 >>= 1;
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 1 ? this.shiftRegister0 & 0x10 | this.shiftRegister1 & 8 : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 164;
        int y = 208;
        InputIcons.TopRider.render(screen, 164, 208);
        if (BitUtil.getBitBool(this.buttons, 23)) {
            InputIcons.ExcitingBoxingRight.render(screen, 193, 211);
        }
        if (BitUtil.getBitBool(this.buttons, 22)) {
            InputIcons.ExcitingBoxingLeft.render(screen, 186, 211);
        }
        if (BitUtil.getBitBool(this.buttons, 21)) {
            InputIcons.TopRiderHandle.render(screen, 165, 216);
        }
        if (BitUtil.getBitBool(this.buttons, 20)) {
            InputIcons.TopRiderShift.render(screen, 177, 219);
        }
        if (BitUtil.getBitBool(this.buttons, 19)) {
            InputIcons.GamepadStart.render(screen, 192, 220);
        }
        if (BitUtil.getBitBool(this.buttons, 18)) {
            InputIcons.GamepadStart.render(screen, 186, 220);
        }
        if (BitUtil.getBitBool(this.buttons, 17)) {
            InputIcons.TopRiderBrake.render(screen, 205, 209);
        }
        if (BitUtil.getBitBool(this.buttons, 16)) {
            InputIcons.TopRiderHandle.render(screen, 207, 216);
        }
    }
}

