/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.uforce;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.util.MathUtil;

public class UForceDescriptor
extends DeviceDescriptor {
    public static final int Top = 0;
    public static final int TopFieldUpperLeft = 1;
    public static final int TopFieldUpperRight = 2;
    public static final int TopFieldLowerLeft = 3;
    public static final int TopFieldLowerRight = 4;
    public static final int BottomFieldUpperLeft = 5;
    public static final int BottomFieldLowerLeft = 6;
    public static final int BottomFieldLowerRight = 7;
    public static final int Bottom = 8;
    public static final int Start = 9;
    public static final int Select = 10;
    public static final int RewindTime = 11;
    public static final int HighSpeed = 12;
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.ADD, Component.Identifier.Key.DIVIDE, Component.Identifier.Key.MULTIPLY, Component.Identifier.Key.NUMPAD8, Component.Identifier.Key.NUMPAD9, Component.Identifier.Key.NUMPAD5, Component.Identifier.Key.NUMPAD2, Component.Identifier.Key.NUMPAD3, Component.Identifier.Key.NUMPAD0, Component.Identifier.Key.RETURN, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.BACK, Component.Identifier.Key.GRAVE};

    public UForceDescriptor() {
        super(35);
    }

    @Override
    public String getDeviceName() {
        return "U-Force";
    }

    @Override
    public int getButtonCount() {
        return 13;
    }

    @Override
    public int getRewindTimeButton() {
        return 11;
    }

    @Override
    public int getHighSpeedButton() {
        return 12;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Top";
            }
            case 1: {
                return "Top-Field Upper-Left";
            }
            case 2: {
                return "Top-Field Upper-Right";
            }
            case 3: {
                return "Top-Field Lower-Left";
            }
            case 4: {
                return "Top-Field Lower-Right";
            }
            case 5: {
                return "Bottom-Field Upper-Left";
            }
            case 6: {
                return "Bottom-Field Lower-Left";
            }
            case 7: {
                return "Bottom-Field Lower-Right";
            }
            case 8: {
                return "Bottom";
            }
            case 9: {
                return "Start";
            }
            case 10: {
                return "Select";
            }
            case 11: {
                return "Rewind Time";
            }
            case 12: {
                return "High Speed";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[11] != 0, portIndex);
        this.updateHighSpeed(pressedValues[12] != 0, portIndex);
        bits = 0;
        if (pressedValues[10] != 0) {
            bits |= 0x400;
        }
        if (pressedValues[9] != 0) {
            bits |= 0x200;
        }
        if (pressedValues[8] != 0) {
            bits |= 0x100;
        }
        if (pressedValues[7] != 0) {
            bits |= 0x80;
        }
        if (pressedValues[6] != 0) {
            bits |= 0x40;
        }
        if (pressedValues[5] != 0) {
            bits |= 0x20;
        }
        if (pressedValues[4] != 0) {
            bits |= 0x10;
        }
        if (pressedValues[3] != 0) {
            bits |= 8;
        }
        if (pressedValues[2] != 0) {
            bits |= 4;
        }
        if (pressedValues[1] != 0) {
            bits |= 2;
        }
        if (pressedValues[0] != 0) {
            bits |= 1;
        }
        int dx = MathUtil.clamp((int)InputUtil.getMouseDeltaX() >> 1, -128, 127);
        int dy = MathUtil.clamp((int)InputUtil.getMouseDeltaY() >> 1, -128, 127);
        return (dy & 0xFF) << 24 | (dx & 0xFF) << 16 | bits;
    }
}

