/*
 * Decompiled with CFR 0.152.
 */
package nintaco.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class LogFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HH:mm:ss.SSS");

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append(formatter.format(Instant.ofEpochMilli(record.getMillis()).atZone(ZoneId.systemDefault()).toLocalDateTime())).append(" ").append(record.getLevel().getLocalizedName()).append(": ").append(this.formatMessage(record)).append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                record.getThrown().printStackTrace(printWriter);
                printWriter.close();
                sb.append(stringWriter.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

