/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Random;
import nintaco.CPU;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.apu.APU;
import nintaco.files.CartFile;
import nintaco.files.FdsFile;
import nintaco.files.NesFile;
import nintaco.files.NsfFile;
import nintaco.files.UnifFile;
import nintaco.input.DeviceMapper;
import nintaco.input.Ports;
import nintaco.input.familybasic.datarecorder.DataRecorderMapper;
import nintaco.input.familybasic.keyboard.KeyboardMapper;
import nintaco.mappers.ae.Mapper228;
import nintaco.mappers.american.DeathRace;
import nintaco.mappers.ave.Maxi15;
import nintaco.mappers.ave.NINA001;
import nintaco.mappers.ave.NINA003006;
import nintaco.mappers.ave.NINA06;
import nintaco.mappers.bandai.Bandai74161_7432;
import nintaco.mappers.bandai.KaraokeStudio;
import nintaco.mappers.bandai.Mapper016;
import nintaco.mappers.bandai.Mapper153;
import nintaco.mappers.bandai.Mapper157;
import nintaco.mappers.bandai.Mapper159;
import nintaco.mappers.bandai.OekaKidsTablet;
import nintaco.mappers.bitcorp.CrimeBusters;
import nintaco.mappers.bitcorp.Mapper357;
import nintaco.mappers.bitcorp.Mapper360;
import nintaco.mappers.capcom.UN1ROM;
import nintaco.mappers.carson.Carson;
import nintaco.mappers.carson.Mapper291;
import nintaco.mappers.ce.Mapper240;
import nintaco.mappers.ce.Mapper244;
import nintaco.mappers.ce.Mapper246;
import nintaco.mappers.codemasters.BF909x;
import nintaco.mappers.codemasters.GoldenFive;
import nintaco.mappers.codemasters.Mapper232;
import nintaco.mappers.colordreams.ColorDreams;
import nintaco.mappers.colordreams.RumbleStation;
import nintaco.mappers.daouinfosys.DaouInfosys;
import nintaco.mappers.daouinfosys.Mapper515;
import nintaco.mappers.daouinfosys.Mapper517;
import nintaco.mappers.frontfareast.Mapper006;
import nintaco.mappers.frontfareast.Mapper008;
import nintaco.mappers.frontfareast.Mapper017;
import nintaco.mappers.fukutakeshoten.StudyBox;
import nintaco.mappers.henggedianzi.Henggedianzi177;
import nintaco.mappers.henggedianzi.Henggedianzi179;
import nintaco.mappers.homebrew.COOLGIRL;
import nintaco.mappers.homebrew.Glider;
import nintaco.mappers.homebrew.MagicFloor;
import nintaco.mappers.homebrew.MagicKidGooGoo;
import nintaco.mappers.homebrew.Puritans;
import nintaco.mappers.homebrew.Streemerz;
import nintaco.mappers.homebrew.UNROM512;
import nintaco.mappers.irem.BxROM;
import nintaco.mappers.irem.G101;
import nintaco.mappers.irem.H3001;
import nintaco.mappers.irem.Mapper077;
import nintaco.mappers.irem.Mapper078;
import nintaco.mappers.irem.TAMS1;
import nintaco.mappers.jaleco.JF10;
import nintaco.mappers.jaleco.JF11;
import nintaco.mappers.jaleco.JF17;
import nintaco.mappers.jaleco.Mapper087;
import nintaco.mappers.jaleco.Mapper092;
import nintaco.mappers.jaleco.Moero;
import nintaco.mappers.jaleco.SS88006;
import nintaco.mappers.jy.JY;
import nintaco.mappers.jy.Mapper091;
import nintaco.mappers.jy.Mapper267;
import nintaco.mappers.jy.Mapper281;
import nintaco.mappers.jy.Mapper282;
import nintaco.mappers.jy.Mapper295;
import nintaco.mappers.jy.Mapper351;
import nintaco.mappers.jy.Mapper356;
import nintaco.mappers.jy.Mapper358;
import nintaco.mappers.jy.Mapper361;
import nintaco.mappers.jy.Mapper362;
import nintaco.mappers.jy.Mapper363;
import nintaco.mappers.jy.Mapper364;
import nintaco.mappers.kaiser.Kaiser106C;
import nintaco.mappers.kaiser.Kaiser7012;
import nintaco.mappers.kaiser.Kaiser7013B;
import nintaco.mappers.kaiser.Kaiser7016;
import nintaco.mappers.kaiser.Kaiser7017;
import nintaco.mappers.kaiser.Kaiser7021A;
import nintaco.mappers.kaiser.Kaiser7022;
import nintaco.mappers.kaiser.Kaiser7030;
import nintaco.mappers.kaiser.Kaiser7031;
import nintaco.mappers.kaiser.Kaiser7032;
import nintaco.mappers.kaiser.Kaiser7037;
import nintaco.mappers.kaiser.Kaiser7057;
import nintaco.mappers.kaiser.Kaiser7058;
import nintaco.mappers.konami.VRC1;
import nintaco.mappers.konami.VRC2And4;
import nintaco.mappers.konami.VRC3;
import nintaco.mappers.konami.vrc6.VRC6a;
import nintaco.mappers.konami.vrc6.VRC6b;
import nintaco.mappers.konami.vrc7.VRC7;
import nintaco.mappers.magicseries.Mapper107;
import nintaco.mappers.namco.DxROM;
import nintaco.mappers.namco.Mapper076;
import nintaco.mappers.namco.Mapper088;
import nintaco.mappers.namco.Mapper330;
import nintaco.mappers.namco.NAMCOT3425;
import nintaco.mappers.namco.NAMCOT3453;
import nintaco.mappers.namco.NamcoX;
import nintaco.mappers.nanjing.Mapper534;
import nintaco.mappers.nanjing.Nanjing;
import nintaco.mappers.nihonbussan.CrazyClimber;
import nintaco.mappers.nintendo.CNROM;
import nintaco.mappers.nintendo.GxROM;
import nintaco.mappers.nintendo.MMC1;
import nintaco.mappers.nintendo.MMC1A;
import nintaco.mappers.nintendo.MMC2;
import nintaco.mappers.nintendo.MMC3;
import nintaco.mappers.nintendo.MMC4;
import nintaco.mappers.nintendo.Mapper037;
import nintaco.mappers.nintendo.Mapper047;
import nintaco.mappers.nintendo.Mapper185;
import nintaco.mappers.nintendo.NROM;
import nintaco.mappers.nintendo.NesEvent;
import nintaco.mappers.nintendo.TxSROM;
import nintaco.mappers.nintendo.UxROM;
import nintaco.mappers.nintendo.mmc5.MMC5;
import nintaco.mappers.nintendo.vs.MainVsDualSystem;
import nintaco.mappers.nintendo.vs.VsGame;
import nintaco.mappers.nintendo.vs.VsUniSystem;
import nintaco.mappers.nitra.Mapper250;
import nintaco.mappers.ntdec.AsderPC95;
import nintaco.mappers.ntdec.BMC063;
import nintaco.mappers.ntdec.Mapper041;
import nintaco.mappers.ntdec.Mapper081;
import nintaco.mappers.ntdec.Mapper112;
import nintaco.mappers.ntdec.Mapper174;
import nintaco.mappers.ntdec.Mapper221;
import nintaco.mappers.ntdec.NTD03;
import nintaco.mappers.ntdec.PC95KO01;
import nintaco.mappers.ntdec.TC112;
import nintaco.mappers.ntdec.TF1201;
import nintaco.mappers.pirate.BMC051;
import nintaco.mappers.pirate.BMC235;
import nintaco.mappers.pirate.BMC255;
import nintaco.mappers.pirate.BMC60311C;
import nintaco.mappers.pirate.BMC830425C4391T;
import nintaco.mappers.pirate.GKCX1;
import nintaco.mappers.pirate.Gyruss;
import nintaco.mappers.pirate.HP898F;
import nintaco.mappers.pirate.Mapper035;
import nintaco.mappers.pirate.Mapper040;
import nintaco.mappers.pirate.Mapper042;
import nintaco.mappers.pirate.Mapper050;
import nintaco.mappers.pirate.Mapper057;
import nintaco.mappers.pirate.Mapper058;
import nintaco.mappers.pirate.Mapper060;
import nintaco.mappers.pirate.Mapper061;
import nintaco.mappers.pirate.Mapper062;
import nintaco.mappers.pirate.Mapper083;
import nintaco.mappers.pirate.Mapper103;
import nintaco.mappers.pirate.Mapper106;
import nintaco.mappers.pirate.Mapper108;
import nintaco.mappers.pirate.Mapper117;
import nintaco.mappers.pirate.Mapper120;
import nintaco.mappers.pirate.Mapper170;
import nintaco.mappers.pirate.Mapper200;
import nintaco.mappers.pirate.Mapper201;
import nintaco.mappers.pirate.Mapper202;
import nintaco.mappers.pirate.Mapper203;
import nintaco.mappers.pirate.Mapper204;
import nintaco.mappers.pirate.Mapper212;
import nintaco.mappers.pirate.Mapper213;
import nintaco.mappers.pirate.Mapper214;
import nintaco.mappers.pirate.Mapper216;
import nintaco.mappers.pirate.Mapper222;
import nintaco.mappers.pirate.Mapper225;
import nintaco.mappers.pirate.Mapper226;
import nintaco.mappers.pirate.Mapper227;
import nintaco.mappers.pirate.Mapper229;
import nintaco.mappers.pirate.Mapper230;
import nintaco.mappers.pirate.Mapper231;
import nintaco.mappers.pirate.Mapper233;
import nintaco.mappers.pirate.Mapper253;
import nintaco.mappers.pirate.Mapper272;
import nintaco.mappers.pirate.Mapper273;
import nintaco.mappers.pirate.Mapper293;
import nintaco.mappers.pirate.Mapper326;
import nintaco.mappers.pirate.Mapper343;
import nintaco.mappers.pirate.Mapper354;
import nintaco.mappers.pirate.Mapper520;
import nintaco.mappers.pirate.MrMary2;
import nintaco.mappers.pirate.ShuiGuanPipe;
import nintaco.mappers.pirate.Supervision;
import nintaco.mappers.pirate.Teletubbies;
import nintaco.mappers.pirate._3D_Block;
import nintaco.mappers.piratemmc3.BMC8In1;
import nintaco.mappers.piratemmc3.BMCF15;
import nintaco.mappers.piratemmc3.BMCGN26;
import nintaco.mappers.piratemmc3.BMCHPxx;
import nintaco.mappers.piratemmc3.BMCL6IN1;
import nintaco.mappers.piratemmc3.Boogerman;
import nintaco.mappers.piratemmc3.DragonBallZ5;
import nintaco.mappers.piratemmc3.GN45;
import nintaco.mappers.piratemmc3.Mapper014;
import nintaco.mappers.piratemmc3.Mapper044;
import nintaco.mappers.piratemmc3.Mapper045;
import nintaco.mappers.piratemmc3.Mapper049;
import nintaco.mappers.piratemmc3.Mapper052;
import nintaco.mappers.piratemmc3.Mapper114;
import nintaco.mappers.piratemmc3.Mapper116;
import nintaco.mappers.piratemmc3.Mapper121;
import nintaco.mappers.piratemmc3.Mapper123;
import nintaco.mappers.piratemmc3.Mapper134;
import nintaco.mappers.piratemmc3.Mapper165;
import nintaco.mappers.piratemmc3.Mapper182;
import nintaco.mappers.piratemmc3.Mapper187;
import nintaco.mappers.piratemmc3.Mapper196;
import nintaco.mappers.piratemmc3.Mapper197;
import nintaco.mappers.piratemmc3.Mapper198;
import nintaco.mappers.piratemmc3.Mapper199;
import nintaco.mappers.piratemmc3.Mapper205;
import nintaco.mappers.piratemmc3.Mapper208;
import nintaco.mappers.piratemmc3.Mapper217;
import nintaco.mappers.piratemmc3.Mapper219;
import nintaco.mappers.piratemmc3.Mapper238;
import nintaco.mappers.piratemmc3.Mapper254;
import nintaco.mappers.piratemmc3.Mapper269;
import nintaco.mappers.piratemmc3.Mapper294;
import nintaco.mappers.piratemmc3.Mapper334;
import nintaco.mappers.piratemmc3.Mapper353;
import nintaco.mappers.piratemmc3.Mapper516;
import nintaco.mappers.piratemmc3.PowerJoy;
import nintaco.mappers.piratemmc3.ResetTxROM;
import nintaco.mappers.pyramid.PEC586;
import nintaco.mappers.racermate.RacerMate;
import nintaco.mappers.rare.AxROM;
import nintaco.mappers.rare.TQROM;
import nintaco.mappers.sachen.Mapper147;
import nintaco.mappers.sachen.Mapper512;
import nintaco.mappers.sachen.SA0036;
import nintaco.mappers.sachen.SA0037;
import nintaco.mappers.sachen.SA72007;
import nintaco.mappers.sachen.SA72008;
import nintaco.mappers.sachen.SANROM;
import nintaco.mappers.sachen.Sachen136;
import nintaco.mappers.sachen.Sachen3014;
import nintaco.mappers.sachen.Sachen74LS374N;
import nintaco.mappers.sachen.Sachen74LS374Nb;
import nintaco.mappers.sachen.Sachen8259A;
import nintaco.mappers.sachen.Sachen8259B;
import nintaco.mappers.sachen.Sachen8259C;
import nintaco.mappers.sachen.Sachen8259D;
import nintaco.mappers.subor.DANCE2000;
import nintaco.mappers.subor.Mapper166;
import nintaco.mappers.subor.Mapper167;
import nintaco.mappers.subor.SuborKaraoke;
import nintaco.mappers.sunsoft.Sunsoft1;
import nintaco.mappers.sunsoft.Sunsoft2;
import nintaco.mappers.sunsoft.Sunsoft2IC;
import nintaco.mappers.sunsoft.Sunsoft3;
import nintaco.mappers.sunsoft.Sunsoft4;
import nintaco.mappers.sunsoft.fme7.SunsoftFME7;
import nintaco.mappers.taito.TC0690;
import nintaco.mappers.taito.X1005;
import nintaco.mappers.taito.X1005b;
import nintaco.mappers.taito.X1017;
import nintaco.mappers.tengen.RAMBO1;
import nintaco.mappers.tengen.T800037;
import nintaco.mappers.thq.CPROM;
import nintaco.mappers.txc.Mapper189;
import nintaco.mappers.txc.Mapper241;
import nintaco.mappers.txc.Txc01_22110_000;
import nintaco.mappers.txc.Txc22000;
import nintaco.mappers.txc.Txc22026;
import nintaco.mappers.txc.Txc22211A;
import nintaco.mappers.txc.Txc22211B;
import nintaco.mappers.txc.Txc22211C;
import nintaco.mappers.unif.bmc.A65AS;
import nintaco.mappers.unif.bmc.BMC1024CA1;
import nintaco.mappers.unif.bmc.BMC11160;
import nintaco.mappers.unif.bmc.BMC12In1;
import nintaco.mappers.unif.bmc.BMC190In1;
import nintaco.mappers.unif.bmc.BMC411120C;
import nintaco.mappers.unif.bmc.BMC64In1NoRepeat;
import nintaco.mappers.unif.bmc.BMC70In1;
import nintaco.mappers.unif.bmc.BMC70In1B;
import nintaco.mappers.unif.bmc.BMC8013B;
import nintaco.mappers.unif.bmc.BMC810544CA1;
import nintaco.mappers.unif.bmc.BMC8157;
import nintaco.mappers.unif.bmc.BMC830118C;
import nintaco.mappers.unif.bmc.BMC830134C;
import nintaco.mappers.unif.bmc.BMC891227;
import nintaco.mappers.unif.bmc.BMCCTC09;
import nintaco.mappers.unif.bmc.BMCCTC12IN1;
import nintaco.mappers.unif.bmc.BMCK3006;
import nintaco.mappers.unif.bmc.BMCK3033;
import nintaco.mappers.unif.bmc.BMCK3036;
import nintaco.mappers.unif.bmc.BMCK3046;
import nintaco.mappers.unif.bmc.BMCSA005A;
import nintaco.mappers.unif.bmc.BMCSB5013;
import nintaco.mappers.unif.bmc.BMCTJ03;
import nintaco.mappers.unif.bmc.BS5;
import nintaco.mappers.unif.bmc.D1038;
import nintaco.mappers.unif.bmc.FK23C;
import nintaco.mappers.unif.bmc.G146;
import nintaco.mappers.unif.bmc.GS2004;
import nintaco.mappers.unif.bmc.GS2013;
import nintaco.mappers.unif.bmc.Ghostbusters63In1;
import nintaco.mappers.unif.bmc.N625092;
import nintaco.mappers.unif.bmc.NovelDiamond9999999In1;
import nintaco.mappers.unif.bmc.Super24In1SC03;
import nintaco.mappers.unif.bmc.Supervision16In1;
import nintaco.mappers.unif.bmc.T262;
import nintaco.mappers.unif.bmc.WS;
import nintaco.mappers.unif.btl.BTL900218;
import nintaco.mappers.unif.btl.MARIO1MALEE2;
import nintaco.mappers.unif.unl.AC08;
import nintaco.mappers.unif.unl.AX40G;
import nintaco.mappers.unif.unl.AX5705;
import nintaco.mappers.unif.unl.BB;
import nintaco.mappers.unif.unl.BJ56;
import nintaco.mappers.unif.unl.CC21;
import nintaco.mappers.unif.unl.COOLBOY;
import nintaco.mappers.unif.unl.CityFighter;
import nintaco.mappers.unif.unl.DRAGONFIGHTER;
import nintaco.mappers.unif.unl.DREAMTECH01;
import nintaco.mappers.unif.unl.EDU2000;
import nintaco.mappers.unif.unl.EH8813A;
import nintaco.mappers.unif.unl.FARID_SLROM_8IN1;
import nintaco.mappers.unif.unl.FARID_UNROM_8IN1;
import nintaco.mappers.unif.unl.FS304;
import nintaco.mappers.unif.unl.H2288;
import nintaco.mappers.unif.unl.KOF97;
import nintaco.mappers.unif.unl.LH10;
import nintaco.mappers.unif.unl.LH32;
import nintaco.mappers.unif.unl.LH51;
import nintaco.mappers.unif.unl.MALISB;
import nintaco.mappers.unif.unl.Mapper256;
import nintaco.mappers.unif.unl.RT01;
import nintaco.mappers.unif.unl.SA9602B;
import nintaco.mappers.unif.unl.SHERO;
import nintaco.mappers.unif.unl.SMB2J;
import nintaco.mappers.unif.unl.T230;
import nintaco.mappers.unif.unl.Transformer;
import nintaco.mappers.unif.unl.UNL158B;
import nintaco.mappers.unif.unl.UNL22211;
import nintaco.mappers.unif.unl.UNL43272;
import nintaco.mappers.unif.unl.UNL603_5052;
import nintaco.mappers.unif.unl.UNL8237;
import nintaco.mappers.unif.unl.UNL8237A;
import nintaco.mappers.unif.unl.UNL831128C;
import nintaco.mappers.unif.unl.UNLTH2131_1;
import nintaco.mappers.unif.unl.YOKO;
import nintaco.mappers.unif.unl.dripgame.DripGame;
import nintaco.mappers.waixing.Education;
import nintaco.mappers.waixing.Mapper015;
import nintaco.mappers.waixing.Mapper074;
import nintaco.mappers.waixing.Mapper162;
import nintaco.mappers.waixing.Mapper164;
import nintaco.mappers.waixing.Mapper176;
import nintaco.mappers.waixing.Mapper191;
import nintaco.mappers.waixing.Mapper192;
import nintaco.mappers.waixing.Mapper194;
import nintaco.mappers.waixing.Mapper195;
import nintaco.mappers.waixing.Mapper242;
import nintaco.mappers.waixing.Mapper245;
import nintaco.mappers.waixing.Mapper249;
import nintaco.mappers.waixing.Mapper252;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.serializer.Transients;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.StreamUtil;

public abstract class Mapper
implements Serializable,
Transients {
    private static final long serialVersionUID = 0L;
    protected static final int INSERT_COIN_FRAMES = 6;
    protected transient int[] memory = new int[65536];
    protected transient int[] vram = new int[16384];
    protected transient int[] xram;
    protected transient int[] xChrRam;
    protected final int[] nametableMappings = new int[]{8192, 8192, 8192, 8192};
    protected final int prgShift;
    protected final int prgAddressMask;
    protected final int chrShift;
    protected final int chrAddressMask;
    protected final int minRegisterAddress;
    protected final int minRomAddress;
    protected final int chrRamSizeMask;
    protected Machine machine;
    protected CPU cpu;
    protected PPU ppu;
    protected APU apu;
    protected TVSystem preferredTVSystem;
    protected TVSystem tvSystem;
    protected boolean ntsc;
    protected int nametableMirroring;
    protected boolean vsSystem;
    protected boolean nametableMappingEnabled = true;
    protected boolean chrRamPresent;
    protected boolean nonVolatilePrgRamPresent;
    protected String romFileName;
    protected transient int[] prgROM;
    protected transient int[] chrROM;
    protected int[] prgBanks;
    protected int[] chrBanks;
    protected int prgRomSizeMask;
    protected int chrRomSizeMask;
    protected int prgRomLength;
    protected int chrRomLength;
    protected transient int[][] diskData;
    protected transient int[][] sourceDiskData;
    protected int vramMask = 16383;
    protected Ports ports = Ports.DEFAULTS;
    protected DeviceMapper[] deviceMappers = new DeviceMapper[0];
    protected int coinInserted;
    protected int coinMask;
    protected int serviceButtonPressed;
    protected int serviceButtonMask;
    protected int screamedIntoMicrophone;
    protected int dipSwitchesValue;
    protected volatile int buttons;

    public Mapper(NsfFile nsfFile) {
        this.prgBanks = new int[16];
        this.prgShift = 12;
        this.prgAddressMask = 4095;
        this.minRegisterAddress = 32768;
        this.minRomAddress = 32768;
        this.chrBanks = new int[0];
        this.chrAddressMask = 0;
        this.chrShift = 0;
        this.chrRamPresent = true;
        this.preferredTVSystem = nsfFile.getTvSystem();
        this.setBanks(this.prgBanks, 0, 0, 16, 4096);
        this.romFileName = nsfFile.getFileName();
        this.restore(nsfFile);
        this.prgRomSizeMask = this.prgROM.length - 1;
        this.chrRamSizeMask = 8191;
        this.initializeRAM();
    }

    public Mapper(FdsFile fdsFile) {
        this.prgShift = 0;
        this.prgAddressMask = 65535;
        this.chrShift = 0;
        this.chrAddressMask = 0;
        this.minRegisterAddress = 32768;
        this.minRomAddress = 32768;
        this.chrRamPresent = true;
        this.preferredTVSystem = TVSystem.NTSC;
        this.romFileName = fdsFile.getFileName();
        this.chrRamSizeMask = 8191;
        this.restore(fdsFile);
        this.initializeRAM();
    }

    public Mapper(CartFile cartFile, int prgBanksSize, int chrBanksSize) {
        this(cartFile, prgBanksSize, chrBanksSize, 32768, 32768);
    }

    public Mapper(CartFile cartFile, int prgBanksSize, int chrBanksSize, int minRegisterAddress, int minRomAddress) {
        int cRamSize;
        int power;
        this.romFileName = cartFile.getFileName();
        this.restore(cartFile);
        this.prgRomLength = cartFile.getPrgRomLength();
        this.chrRomLength = cartFile.getChrRomLength();
        this.prgRomSizeMask = this.prgROM.length - 1;
        this.chrRomSizeMask = this.chrROM.length - 1;
        this.chrRamPresent = cartFile.isChrRamPresent();
        this.nonVolatilePrgRamPresent = cartFile.isNonVolatilePrgRamPresent();
        this.preferredTVSystem = cartFile.getTvSystem();
        this.setNametableMirroring(cartFile.getMirroring());
        this.vsSystem = cartFile.isVsSystem();
        boolean usesPrgBanks = true;
        if (prgBanksSize == 0) {
            usesPrgBanks = false;
            prgBanksSize = 2;
        }
        this.prgBanks = new int[prgBanksSize];
        if (BitUtil.isBase2(prgBanksSize)) {
            power = BitUtil.log2(prgBanksSize);
            this.prgShift = 16 - power;
            this.prgAddressMask = 65535 >> power;
            if (usesPrgBanks) {
                this.setBanks(this.prgBanks, 0, 0, prgBanksSize, this.prgAddressMask + 1);
            }
        } else {
            this.prgAddressMask = 0;
            this.prgShift = 0;
        }
        this.chrBanks = new int[chrBanksSize];
        if (BitUtil.isBase2(chrBanksSize)) {
            if (chrBanksSize > 0) {
                power = BitUtil.log2(chrBanksSize);
                this.chrShift = 13 - power;
                this.chrAddressMask = 8191 >> power;
            } else {
                this.chrAddressMask = 0;
                this.chrShift = 0;
            }
            this.setBanks(this.chrBanks, 0, 0, chrBanksSize, this.chrAddressMask + 1);
        } else {
            this.chrAddressMask = 0;
            this.chrShift = 0;
        }
        this.minRegisterAddress = minRegisterAddress;
        this.minRomAddress = minRomAddress;
        this.initializeRAM();
        if (cartFile.isTrainerPresent()) {
            System.arraycopy(cartFile.getTrainer(), 0, this.memory, 28672, cartFile.getTrainerSize());
        }
        if ((cRamSize = this.getChrRamSize(cartFile)) > 8192) {
            this.chrRamPresent = true;
            this.xChrRam = new int[cRamSize];
            this.chrRamSizeMask = this.xChrRam.length - 1;
        } else {
            this.chrRamSizeMask = 8191;
        }
    }

    protected int getChrRamSize(CartFile cartFile) {
        return cartFile.getChrRamSize();
    }

    private void initializeRAM() {
        switch (AppPrefs.getInstance().getUserInterfacePrefs().getInitialRamState()) {
            case AllFF: {
                for (int i = this.memory.length - 1; i >= 0; --i) {
                    this.memory[i] = 255;
                }
                break;
            }
            case Random: {
                Random random = new Random();
                for (int i = this.memory.length - 1; i >= 0; --i) {
                    this.memory[i] = 0xFF & random.nextInt();
                }
                break;
            }
        }
    }

    public void copyMemory(Mapper mapper) {
        System.arraycopy(mapper.memory, 0, this.memory, 0, this.memory.length);
        System.arraycopy(mapper.vram, 0, this.vram, 0, this.vram.length);
    }

    public void restore(NsfFile nsfFile) {
        if (nsfFile != null) {
            this.prgROM = nsfFile.getPrgROM();
        }
    }

    public void restore(CartFile cartFile) {
        if (cartFile != null) {
            this.prgROM = cartFile.getPrgROM();
            this.chrROM = cartFile.getChrROM();
        }
    }

    public void restore(FdsFile fdsFile) {
        block5: {
            if (fdsFile == null) break block5;
            System.arraycopy(fdsFile.getBios(), 0, this.memory, 57344, 8192);
            this.sourceDiskData = fdsFile.getDiskData();
            if (this.diskData == null) {
                this.diskData = new int[this.sourceDiskData.length][65536];
                for (int i = this.sourceDiskData.length - 1; i >= 0; --i) {
                    System.arraycopy(this.sourceDiskData[i], 0, this.diskData[i], 0, 65536);
                }
            } else {
                for (int i = this.sourceDiskData.length - 1; i >= 0; --i) {
                    for (int j = 65535; j >= 0; --j) {
                        if (this.diskData[i][j] >= 0) continue;
                        this.diskData[i][j] = this.sourceDiskData[i][j];
                    }
                }
            }
        }
    }

    public void init() {
        this.writeRegister(this.minRegisterAddress, 0);
    }

    public void resetting() {
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        this.cpu = machine.getCPU();
        this.ppu = machine.getPPU();
        this.apu = machine.getAPU();
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public void setCPU(CPU cpu) {
        this.cpu = cpu;
    }

    public PPU getPPU() {
        return this.ppu;
    }

    public void setPPU(PPU ppu) {
        this.ppu = ppu;
    }

    public APU getAPU() {
        return this.apu;
    }

    public void setAPU(APU apu) {
        this.apu = apu;
    }

    public void setTVSystem(TVSystem tvSystem) {
        this.tvSystem = tvSystem;
        this.ntsc = tvSystem == TVSystem.NTSC;
    }

    public TVSystem getTVSystem() {
        return this.tvSystem;
    }

    public TVSystem getPreferredTVSystem() {
        return this.preferredTVSystem;
    }

    public void setVramMask(int vramMask) {
        this.vramMask = vramMask;
    }

    public void setNsfOptions(boolean automaticallyAdvanceTrack, int idleSeconds, boolean defaultTrackLength, int trackLengthMinutes) {
    }

    public void setSongPaused(boolean songPaused) {
    }

    public boolean isSongPaused() {
        return false;
    }

    public void requestSong(int songNumber) {
    }

    public void screamIntoMicrophone() {
        this.screamedIntoMicrophone = 600;
    }

    public void insertCoin(int vsSystem, int coinSlot) {
        this.coinInserted = 6;
        this.coinMask = 32 << (coinSlot & 1);
    }

    public void pressServiceButton(int vsSystem) {
        this.serviceButtonPressed = 6;
        this.serviceButtonMask = 4;
    }

    public void setDipSwitchesValue(int dipSwitchesValue) {
        this.dipSwitchesValue = dipSwitchesValue;
    }

    public DataRecorderMapper getDataRecorder() {
        DeviceMapper[] mappers = this.deviceMappers;
        for (int i = mappers.length - 1; i >= 0; --i) {
            if (mappers[i].getInputDevice() == 11) {
                return (DataRecorderMapper)mappers[i];
            }
            if (mappers[i].getInputDevice() != 18) continue;
            return ((KeyboardMapper)mappers[i]).getDataRecorder();
        }
        return null;
    }

    public void setNametable(int index, int value) {
        this.nametableMappings[index] = 0x2000 | value << 10;
    }

    public void setNametables(int v0, int v1, int v2, int v3) {
        this.setNametable(0, v0);
        this.setNametable(1, v1);
        this.setNametable(2, v2);
        this.setNametable(3, v3);
    }

    public void setNametableMirroring(int nametableMirroring) {
        this.nametableMirroring = nametableMirroring;
        switch (nametableMirroring) {
            case 0: {
                this.nametableMappings[2] = 8192;
                this.nametableMappings[0] = 8192;
                this.nametableMappings[3] = 9216;
                this.nametableMappings[1] = 9216;
                break;
            }
            case 1: {
                this.nametableMappings[1] = 8192;
                this.nametableMappings[0] = 8192;
                this.nametableMappings[3] = 9216;
                this.nametableMappings[2] = 9216;
                break;
            }
            case 2: {
                this.nametableMappings[3] = 8192;
                this.nametableMappings[2] = 8192;
                this.nametableMappings[1] = 8192;
                this.nametableMappings[0] = 8192;
                break;
            }
            case 3: {
                this.nametableMappings[3] = 9216;
                this.nametableMappings[2] = 9216;
                this.nametableMappings[1] = 9216;
                this.nametableMappings[0] = 9216;
                break;
            }
            case 4: {
                this.nametableMappings[0] = 8192;
                this.nametableMappings[1] = 9216;
                this.nametableMappings[2] = 10240;
                this.nametableMappings[3] = 11264;
                break;
            }
            case 5: {
                this.nametableMappings[3] = 8192;
                this.nametableMappings[0] = 8192;
                this.nametableMappings[2] = 9216;
                this.nametableMappings[1] = 9216;
                break;
            }
            case 6: {
                this.nametableMappings[0] = 8192;
                this.nametableMappings[3] = 9216;
                this.nametableMappings[2] = 9216;
                this.nametableMappings[1] = 9216;
                break;
            }
            case 7: {
                this.nametableMappings[2] = 8192;
                this.nametableMappings[1] = 8192;
                this.nametableMappings[0] = 8192;
                this.nametableMappings[3] = 9216;
            }
        }
    }

    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= this.minRegisterAddress) {
            this.writeRegister(address, value);
        }
    }

    public int readMemory(int address) {
        if (address >= this.minRomAddress) {
            return this.prgROM[(this.prgBanks[address >> this.prgShift] | address & this.prgAddressMask) & this.prgRomSizeMask];
        }
        return this.memory[address];
    }

    public int getPrgRomLength() {
        return this.prgRomLength;
    }

    public int readPrgRom(int address) {
        if (address >= 0 && address < this.prgROM.length) {
            return this.prgROM[address];
        }
        return -1;
    }

    public void writePrgRom(int address, int value) {
        if (address >= 0 && address < this.prgROM.length) {
            this.prgROM[address] = value;
        }
    }

    public int getChrRomLength() {
        return this.chrRomLength;
    }

    public void writeChrRom(int address, int value) {
        if (address >= 0 && address < this.chrROM.length) {
            this.chrROM[address] = value;
        }
    }

    public int readChrRom(int address) {
        if (address >= 0 && address < this.chrROM.length) {
            return this.chrROM[address];
        }
        return -1;
    }

    public int getPrgBankCount() {
        return this.prgROM == null ? 0 : this.prgROM.length / this.getPrgBankSize();
    }

    public int getPrgBankSize() {
        return this.prgROM == null ? 0 : this.prgAddressMask + 1;
    }

    public int getChrBankCount() {
        return this.chrROM == null ? 0 : this.chrROM.length / this.getChrBankSize();
    }

    public int getChrBankSize() {
        return this.chrROM == null ? 0 : this.chrAddressMask + 1;
    }

    public int getPrgBank(int address) {
        if (this.prgBanks != null && (address &= 0xFFFF) >= this.minRomAddress) {
            return this.prgBanks[address >> this.prgShift] >> this.prgShift;
        }
        return -1;
    }

    public int getPrgRomIndex(int address) {
        if (this.prgBanks != null && address >= this.minRomAddress) {
            return (this.prgBanks[address >> this.prgShift] | address & this.prgAddressMask) & this.prgRomSizeMask;
        }
        return -1;
    }

    public int maskAddress(int address) {
        if ((address &= 0xFFFF) < 8192) {
            return address & 0x7FF;
        }
        if (address < 16384) {
            return 0x2000 | address & 7;
        }
        return address;
    }

    public int readCpuMemory(int address) {
        int value;
        int maskedAddress = this.maskAddress(address);
        switch (maskedAddress) {
            case 8192: 
            case 8193: 
            case 8194: 
            case 8195: 
            case 8196: 
            case 8197: 
            case 8198: 
            case 8199: {
                value = this.ppu.readRegister(maskedAddress);
                break;
            }
            case 16405: {
                value = this.apu.readStatus();
                break;
            }
            case 16406: {
                value = this.readInputPort(0);
                break;
            }
            case 16407: {
                value = this.readInputPort(1);
                break;
            }
            default: {
                value = this.readMemory(maskedAddress);
            }
        }
        return this.cpu.applyCheats(address, value);
    }

    public int peekWord(int address) {
        return this.peekCpuMemory(address + 1) << 8 | this.peekCpuMemory(address);
    }

    public int peekCpuMemory(int address) {
        int value;
        int maskedAddress = this.maskAddress(address);
        switch (maskedAddress) {
            case 8192: 
            case 8193: 
            case 8194: 
            case 8195: 
            case 8196: 
            case 8197: 
            case 8198: 
            case 8199: {
                value = this.ppu.peekRegister(maskedAddress);
                break;
            }
            case 16405: {
                value = this.apu.peekStatus();
                break;
            }
            case 16406: {
                value = this.peekInputPort(0);
                break;
            }
            case 16407: {
                value = this.peekInputPort(1);
                break;
            }
            default: {
                value = this.readMemory(maskedAddress);
            }
        }
        return this.cpu.applyCheats(address, value);
    }

    public void writeCpuWord(int address, int value) {
        this.writeCpuMemory(address, value & 0xFF);
        this.writeCpuMemory(address + 1, value >> 8 & 0xFF);
    }

    public void writeWord(int address, int value) {
        this.writeMemory(address, value & 0xFF);
        this.writeMemory(address + 1, value >> 8 & 0xFF);
    }

    public void writeCpuMemory(int address, int value) {
        value &= 0xFF;
        address = this.maskAddress(address);
        switch (address) {
            case 8192: 
            case 8193: 
            case 8194: 
            case 8195: 
            case 8196: 
            case 8197: 
            case 8198: 
            case 8199: {
                this.ppu.writeRegister(address, value);
                break;
            }
            case 16384: {
                this.apu.pulse1.writeEnvelope(value);
                break;
            }
            case 16385: {
                this.apu.pulse1.writeSweep(value);
                break;
            }
            case 16386: {
                this.apu.pulse1.writeTimerReloadLow(value);
                break;
            }
            case 16387: {
                this.apu.pulse1.writeTimerReloadHigh(value);
                break;
            }
            case 16388: {
                this.apu.pulse2.writeEnvelope(value);
                break;
            }
            case 16389: {
                this.apu.pulse2.writeSweep(value);
                break;
            }
            case 16390: {
                this.apu.pulse2.writeTimerReloadLow(value);
                break;
            }
            case 16391: {
                this.apu.pulse2.writeTimerReloadHigh(value);
                break;
            }
            case 16392: {
                this.apu.triangle.writeLinearCounter(value);
                break;
            }
            case 16394: {
                this.apu.triangle.writeTimerReloadLow(value);
                break;
            }
            case 16395: {
                this.apu.triangle.writeTimerReloadHigh(value);
                break;
            }
            case 16396: {
                this.apu.noise.writeEnvelope(value);
                break;
            }
            case 16398: {
                this.apu.noise.writeModeAndPeriod(value);
                break;
            }
            case 16399: {
                this.apu.noise.writeLengthCounter(value);
                break;
            }
            case 16400: {
                this.apu.dmc.writeFlagsAndFrequency(value);
                break;
            }
            case 16401: {
                this.apu.dmc.writeDirectLoad(value);
                break;
            }
            case 16402: {
                this.apu.dmc.writeSampleAddress(value);
                break;
            }
            case 16403: {
                this.apu.dmc.writeSampleLength(value);
                break;
            }
            case 16404: {
                this.cpu.oamTransfer(value);
                break;
            }
            case 16405: {
                this.apu.writeStatus(value);
                break;
            }
            case 16406: {
                this.writeOutputPort(value);
                break;
            }
            case 16407: {
                this.apu.writeFrameCounter(value);
                break;
            }
            default: {
                this.writeMemory(address, value);
            }
        }
    }

    public int maskVRAMAddress(int address) {
        if (this.nametableMappingEnabled && (address &= this.vramMask) >= 8192 && address <= 16127) {
            address = this.nametableMappings[address >> 10 & 3] | address & 0x3FF;
        }
        return address;
    }

    public void handleFrameRendered() {
    }

    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
    }

    public void writeVRAM(int address, int value) {
        if (address < 8192 && this.chrRamPresent && this.chrAddressMask != 0) {
            (this.xChrRam != null ? this.xChrRam : this.vram)[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRamSizeMask] = value;
        } else {
            this.vram[address] = value;
        }
    }

    public int readVRAM(int address) {
        if (address < 8192 && this.chrAddressMask != 0) {
            if (this.chrRamPresent) {
                return (this.xChrRam != null ? this.xChrRam : this.vram)[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRamSizeMask];
            }
            return this.chrROM[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    public int peekVRAM(int address) {
        return this.readVRAM(address);
    }

    public int getChrRomIndex(int address) {
        if (address < 8192 && this.chrAddressMask != 0) {
            if (this.chrRamPresent) {
                return (this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & 0x1FFF;
            }
            return (this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask;
        }
        return -1;
    }

    public void update() {
    }

    public void updateButtons(int buttons) {
        this.buttons = buttons;
        DeviceMapper[] mappers = this.deviceMappers;
        for (int i = mappers.length - 1; i >= 0; --i) {
            mappers[i].update(buttons);
        }
        if (this.coinInserted > 0 && --this.coinInserted == 0) {
            this.coinMask = 0;
        }
        if (this.serviceButtonPressed > 0 && --this.serviceButtonPressed == 0) {
            this.serviceButtonMask = 0;
        }
    }

    public int getButtons() {
        return this.buttons;
    }

    public Ports getPorts() {
        return this.ports;
    }

    public void setPorts(Ports ports) {
        this.ports = ports;
    }

    public boolean hasDeviceMapper(int inputDevice) {
        return this.getDeviceMapper(inputDevice) != null;
    }

    public DeviceMapper getDeviceMapper(int inputDevice) {
        DeviceMapper[] mappers = this.deviceMappers;
        if (mappers == null || mappers.length == 0) {
            return null;
        }
        for (int i = mappers.length - 1; i >= 0; --i) {
            if (mappers[i].getInputDevice() != inputDevice) continue;
            return mappers[i];
        }
        return null;
    }

    public DeviceMapper[] getDeviceMappers() {
        return this.deviceMappers;
    }

    public void setDeviceMappers(DeviceMapper[] deviceMappers) {
        this.deviceMappers = deviceMappers;
    }

    public int getAudioMixerScale() {
        return 65535;
    }

    public float getAudioSample() {
        return 0.0f;
    }

    public boolean isNsfMapper() {
        return false;
    }

    public boolean isFdsMapper() {
        return false;
    }

    public boolean isDiskActivity() {
        return false;
    }

    public int getDiskSideCount() {
        return 0;
    }

    public int getDiskSide() {
        return 0;
    }

    public void setDiskSide(int side) {
    }

    public void ejectDisk() {
    }

    public boolean isVsDualSystem() {
        return false;
    }

    protected void setBanks(int[] banks, int index, int value, int length, int bankSize) {
        int i = 0;
        int offset = value;
        while (i < length) {
            banks[index + i] = offset;
            ++i;
            offset += bankSize;
        }
    }

    protected void setPrgBanks(int firstBank, int numberOfBanks, int firstValue) {
        for (int i = numberOfBanks - 1; i >= 0; --i) {
            this.setPrgBank(firstBank + i, firstValue + i);
        }
    }

    protected void set2PrgBanks(int firstBank, int firstValue) {
        this.setPrgBank(firstBank, firstValue);
        this.setPrgBank(firstBank + 1, firstValue + 1);
    }

    protected void set4PrgBanks(int firstBank, int firstValue) {
        this.setPrgBank(firstBank, firstValue);
        this.setPrgBank(firstBank + 1, firstValue + 1);
        this.setPrgBank(firstBank + 2, firstValue + 2);
        this.setPrgBank(firstBank + 3, firstValue + 3);
    }

    protected void set8PrgBanks(int firstBank, int firstValue) {
        this.setPrgBank(firstBank, firstValue);
        this.setPrgBank(firstBank + 1, firstValue + 1);
        this.setPrgBank(firstBank + 2, firstValue + 2);
        this.setPrgBank(firstBank + 3, firstValue + 3);
        this.setPrgBank(firstBank + 4, firstValue + 4);
        this.setPrgBank(firstBank + 5, firstValue + 5);
        this.setPrgBank(firstBank + 6, firstValue + 6);
        this.setPrgBank(firstBank + 7, firstValue + 7);
    }

    protected void setChrBanks(int firstBank, int numberOfBanks, int firstValue) {
        for (int i = numberOfBanks - 1; i >= 0; --i) {
            this.setChrBank(firstBank + i, firstValue + i);
        }
    }

    protected void set2ChrBanks(int firstBank, int firstValue) {
        this.setChrBank(firstBank, firstValue);
        this.setChrBank(firstBank + 1, firstValue + 1);
    }

    protected void set4ChrBanks(int firstBank, int firstValue) {
        this.setChrBank(firstBank, firstValue);
        this.setChrBank(firstBank + 1, firstValue + 1);
        this.setChrBank(firstBank + 2, firstValue + 2);
        this.setChrBank(firstBank + 3, firstValue + 3);
    }

    protected void set8ChrBanks(int firstBank, int firstValue) {
        this.setChrBank(firstBank, firstValue);
        this.setChrBank(firstBank + 1, firstValue + 1);
        this.setChrBank(firstBank + 2, firstValue + 2);
        this.setChrBank(firstBank + 3, firstValue + 3);
        this.setChrBank(firstBank + 4, firstValue + 4);
        this.setChrBank(firstBank + 5, firstValue + 5);
        this.setChrBank(firstBank + 6, firstValue + 6);
        this.setChrBank(firstBank + 7, firstValue + 7);
    }

    protected void setPrgBank(int value) {
        this.setPrgBank(1, value);
    }

    protected void setPrgBank(int bank, int value) {
        this.prgBanks[bank] = this.prgROM == null ? value : (value < 0 ? this.prgRomLength + (value << this.prgShift) : value << this.prgShift);
    }

    protected void setChrBank(int value) {
        this.setChrBank(0, value);
    }

    protected void setChrBank(int bank, int value) {
        this.chrBanks[bank] = this.chrROM == null ? value : (value < 0 ? this.chrRomLength + (value << this.chrShift) : value << this.chrShift);
    }

    protected void writeRegister(int address, int value) {
    }

    @Override
    public void writeTransients(DataOutput out) throws IOException {
        StreamUtil.writeSparseByteArray(out, this.memory);
        StreamUtil.writeSparseByteArray(out, this.vram);
        StreamUtil.writeSparseByteArray(out, this.xram);
        StreamUtil.writeSparseByteArray(out, this.xChrRam);
        if (this.diskData != null) {
            out.write(this.diskData.length);
            for (int i = 0; i < this.diskData.length; ++i) {
                for (int j = 0; j < 64; ++j) {
                    StreamUtil.writeSparseBlock(out, this.diskData[i], this.sourceDiskData[i], j << 10);
                }
            }
        } else {
            out.write(0);
        }
    }

    @Override
    public void readTransients(DataInput in) throws IOException {
        this.memory = StreamUtil.readSparseByteArray(in);
        this.vram = StreamUtil.readSparseByteArray(in);
        this.xram = StreamUtil.readSparseByteArray(in);
        this.xChrRam = StreamUtil.readSparseByteArray(in);
        int diskDataLength = in.readUnsignedByte();
        if (diskDataLength > 0) {
            this.diskData = new int[diskDataLength][65536];
            for (int i = 0; i < diskDataLength; ++i) {
                for (int j = 0; j < 64; ++j) {
                    StreamUtil.readSparseBlock(in, this.diskData[i], j << 10, -1);
                }
            }
        }
    }

    public void writeOutputPort(int value) {
        DeviceMapper[] mappers = this.deviceMappers;
        for (int i = mappers.length - 1; i >= 0; --i) {
            mappers[i].writePort(value);
        }
    }

    public int readInputPort(int portIndex) {
        int value;
        DeviceMapper[] mappers = this.deviceMappers;
        if (this.vsSystem) {
            value = portIndex == 0 ? this.coinMask | (this.dipSwitchesValue & 3) << 3 | this.serviceButtonMask : this.dipSwitchesValue & 0xFC;
        } else {
            value = 64;
            if (portIndex == 0 && this.screamedIntoMicrophone > 0) {
                --this.screamedIntoMicrophone;
                value |= (this.screamedIntoMicrophone & 1) << 2;
            }
        }
        for (int i = mappers.length - 1; i >= 0; --i) {
            value |= mappers[i].readPort(portIndex);
        }
        return value;
    }

    public int peekInputPort(int portIndex) {
        DeviceMapper[] mappers = this.deviceMappers;
        int value = this.vsSystem ? (portIndex == 0 ? this.coinMask | (this.dipSwitchesValue & 3) << 3 | this.serviceButtonMask : this.dipSwitchesValue & 0xFC) : 64;
        for (int i = mappers.length - 1; i >= 0; --i) {
            value |= mappers[i].peekPort(portIndex);
        }
        return value;
    }

    public boolean isNonVolatilePrgRamPresent() {
        return this.nonVolatilePrgRamPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadNonVolatilePrgRam() {
        if (!this.nonVolatilePrgRamPresent) return;
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            int[] _xram;
            GamePrefs prefs = GamePrefs.getInstance();
            int[] sram = prefs.getNonVolatilePrgRam();
            if (sram != null && sram.length == 8192) {
                System.arraycopy(sram, 0, this.memory, 24576, 8192);
            }
            if (this.xram == null || (_xram = prefs.getNonVolatileXRam()) == null || _xram.length != this.xram.length) return;
            System.arraycopy(_xram, 0, this.xram, 0, this.xram.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveNonVolatilePrgRam() {
        if (!this.nonVolatilePrgRamPresent) return;
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            GamePrefs prefs = GamePrefs.getInstance();
            int[] sram = prefs.getNonVolatilePrgRam();
            if (sram == null || sram.length != 8192) {
                sram = new int[8192];
            }
            System.arraycopy(this.memory, 24576, sram, 0, 8192);
            prefs.setNonVolatilePrgRam(sram);
            if (this.xram != null) {
                int[] _xram = prefs.getNonVolatileXRam();
                if (_xram == null || _xram.length != this.xram.length) {
                    _xram = new int[this.xram.length];
                }
                System.arraycopy(this.xram, 0, _xram, 0, this.xram.length);
                prefs.setNonVolatileXRam(_xram);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            GamePrefs.save();
            return;
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean saveNonVolatileData) {
        if (saveNonVolatileData) {
            this.saveNonVolatilePrgRam();
        }
        DeviceMapper[] mappers = this.deviceMappers;
        for (int i = mappers.length - 1; i >= 0; --i) {
            mappers[i].close(saveNonVolatileData);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readTransients(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeTransients(out);
    }

    public static Mapper create(UnifFile unifFile) {
        String board = unifFile.getBoard();
        if (board == null) {
            return null;
        }
        switch (board.trim().toUpperCase(Locale.ENGLISH)) {
            case "10-24-C-A1": {
                return new BMC1024CA1(unifFile);
            }
            case "11160": {
                return new BMC11160(unifFile);
            }
            case "8-IN-1": 
            case "NEWSTAR-GRM070-8IN1": {
                return new BMC8In1(unifFile);
            }
            case "12-IN-1": {
                return new BMC12In1(unifFile);
            }
            case "13IN1JY110": {
                return new Mapper295(unifFile);
            }
            case "158B": {
                return new UNL158B(unifFile);
            }
            case "190IN1": {
                return new BMC190In1(unifFile);
            }
            case "22211": {
                return new UNL22211(unifFile);
            }
            case "3D-BLOCK": {
                return new _3D_Block(unifFile);
            }
            case "411120-C": 
            case "K-3088": {
                return new BMC411120C(unifFile);
            }
            case "42IN1RESETSWITCH": {
                return new Mapper233(unifFile);
            }
            case "43272": {
                return new UNL43272(unifFile);
            }
            case "603-5052": {
                return new UNL603_5052(unifFile);
            }
            case "64IN1NOREPEAT": {
                return new BMC64In1NoRepeat(unifFile);
            }
            case "70IN1": {
                return new BMC70In1(unifFile);
            }
            case "70IN1B": {
                return new BMC70In1B(unifFile);
            }
            case "80013-B": {
                return new BMC8013B(unifFile);
            }
            case "810544-C-A1": {
                return new BMC810544CA1(unifFile);
            }
            case "8157": {
                return new BMC8157(unifFile);
            }
            case "8237": {
                return new UNL8237(unifFile);
            }
            case "8237A": {
                return new UNL8237A(unifFile);
            }
            case "830118C": {
                return new BMC830118C(unifFile);
            }
            case "830134C": {
                return new BMC830134C(unifFile);
            }
            case "830425C-4391T": {
                return new BMC830425C4391T(unifFile);
            }
            case "831128C": {
                return new UNL831128C(unifFile);
            }
            case "891227": {
                return new BMC891227(unifFile);
            }
            case "900218": {
                return new BTL900218(unifFile);
            }
            case "A65AS": {
                return new A65AS(unifFile);
            }
            case "AC08": {
                return new AC08(unifFile);
            }
            case "ANROM": {
                return new AxROM(unifFile);
            }
            case "AX-40G": {
                return new AX40G(unifFile);
            }
            case "AX5705": {
                return new AX5705(unifFile);
            }
            case "BB": {
                return new BB(unifFile);
            }
            case "BJ-56": {
                return new BJ56(unifFile);
            }
            case "BS-5": {
                return new BS5(unifFile);
            }
            case "CC-21": {
                return new CC21(unifFile);
            }
            case "CHINA_ER_SAN2": {
                return new NamcoX(unifFile);
            }
            case "CITYFIGHT": {
                return new CityFighter(unifFile);
            }
            case "COOLGIRL": {
                return new COOLGIRL(unifFile);
            }
            case "COOLBOY": {
                return new COOLBOY(unifFile);
            }
            case "CPROM": {
                return new CPROM(unifFile);
            }
            case "CNROM": {
                return new CNROM(unifFile);
            }
            case "CTC-09": {
                return new BMCCTC09(unifFile);
            }
            case "CTC-12IN1": {
                return new BMCCTC12IN1(unifFile);
            }
            case "D1038": {
                return new D1038(unifFile);
            }
            case "DANCE": 
            case "ONEBUS": {
                return new Mapper256(unifFile);
            }
            case "DANCE2000": {
                return new DANCE2000(unifFile);
            }
            case "DRAGONFIGHTER": {
                return new DRAGONFIGHTER(unifFile);
            }
            case "DREAMTECH01": {
                return new DREAMTECH01(unifFile);
            }
            case "DRIPGAME": {
                return new DripGame(unifFile);
            }
            case "EDU2000": {
                return new EDU2000(unifFile);
            }
            case "EH8813A": {
                return new EH8813A(unifFile);
            }
            case "EKROM": 
            case "ELROM": 
            case "ETROM": 
            case "EWROM": {
                return new MMC5(unifFile);
            }
            case "F-15": {
                return new BMCF15(unifFile);
            }
            case "FARID_SLROM_8-IN-1": {
                return new FARID_SLROM_8IN1(unifFile);
            }
            case "FARID_UNROM_8-IN-1": {
                return new FARID_UNROM_8IN1(unifFile);
            }
            case "FK23C": {
                return new FK23C(unifFile, false);
            }
            case "FK23CA": {
                return new FK23C(unifFile, true);
            }
            case "FS304": {
                return new FS304(unifFile);
            }
            case "G-146": {
                return new G146(unifFile);
            }
            case "GHOSTBUSTERS63IN1": {
                return new Ghostbusters63In1(unifFile);
            }
            case "GN-26": {
                return new BMCGN26(unifFile);
            }
            case "GN-45": {
                return new GN45(unifFile);
            }
            case "GS-2004": {
                return new GS2004(unifFile);
            }
            case "GS-2013": {
                return new GS2013(unifFile);
            }
            case "GNROM": 
            case "MHROM": {
                return new GxROM(unifFile);
            }
            case "H2288": {
                return new H2288(unifFile);
            }
            case "HP898F": {
                return new HP898F(unifFile);
            }
            case "HPxx": {
                return new BMCHPxx(unifFile);
            }
            case "K-3006": {
                return new BMCK3006(unifFile);
            }
            case "K-3033": {
                return new BMCK3033(unifFile);
            }
            case "K-3036": {
                return new BMCK3036(unifFile);
            }
            case "K-3046": {
                return new BMCK3046(unifFile);
            }
            case "KOF97": {
                return new KOF97(unifFile);
            }
            case "KS106C": {
                return new Kaiser106C(unifFile);
            }
            case "KS7012": {
                return new Kaiser7012(unifFile);
            }
            case "KS7013B": {
                return new Kaiser7013B(unifFile);
            }
            case "KS7016": {
                return new Kaiser7016(unifFile);
            }
            case "KS7017": {
                return new Kaiser7017(unifFile);
            }
            case "KS7021A": {
                return new Kaiser7021A(unifFile);
            }
            case "KS7030": {
                return new Kaiser7030(unifFile);
            }
            case "KS7031": {
                return new Kaiser7031(unifFile);
            }
            case "KS7032": {
                return new Kaiser7032(unifFile);
            }
            case "KS7037": {
                return new Kaiser7037(unifFile);
            }
            case "KS7057": {
                return new Kaiser7057(unifFile);
            }
            case "L6IN1": {
                return new BMCL6IN1(unifFile);
            }
            case "LH10": {
                return new LH10(unifFile);
            }
            case "LH32": {
                return new LH32(unifFile);
            }
            case "LH51": {
                return new LH51(unifFile);
            }
            case "MALISB": {
                return new MALISB(unifFile);
            }
            case "MARIO1-MALEE2": {
                return new MARIO1MALEE2(unifFile);
            }
            case "N625092": {
                return new N625092(unifFile);
            }
            case "NOVELDIAMOND9999999IN1": {
                return new NovelDiamond9999999In1(unifFile);
            }
            case "NTBROM": {
                return new Sunsoft4(unifFile);
            }
            case "NTD-03": {
                return new NTD03(unifFile);
            }
            case "RROM": 
            case "RROM-128": 
            case "NROM": 
            case "NROM-128": 
            case "NROM-256": {
                return new NROM(unifFile);
            }
            case "RESET-TXROM": {
                return new ResetTxROM(unifFile);
            }
            case "RT-01": {
                return new RT01(unifFile);
            }
            case "PEC-586": {
                return new PEC586(unifFile);
            }
            case "SA-0036": {
                return new SA0036(unifFile);
            }
            case "SA-0037": 
            case "SA-004": {
                return new SA0037(unifFile);
            }
            case "SA005-A": {
                return new BMCSA005A(unifFile);
            }
            case "SA-014": 
            case "SA-NROM": 
            case "TC-A001-72P": {
                return new SANROM(unifFile);
            }
            case "SA-010-1": 
            case "SA-016-1M": 
            case "TC-3015-72P-VX": {
                return new NINA06(unifFile);
            }
            case "HKROM": 
            case "TBROM": 
            case "TEROM": 
            case "TFROM": 
            case "TGROM": 
            case "TKROM": 
            case "TK1ROM": 
            case "TKSROM": 
            case "TLROM": 
            case "TL1ROM": 
            case "TL2ROM": 
            case "TLSROM": 
            case "TNROM": 
            case "TQROM": 
            case "TR1ROM": 
            case "TSROM": 
            case "TVROM": {
                return new MMC3(unifFile);
            }
            case "SA-72007": {
                return new SA72007(unifFile);
            }
            case "SA-72008": {
                return new SA72008(unifFile);
            }
            case "SA-72008-VX": 
            case "SACHEN-74LS374N": {
                return new Sachen74LS374Nb(unifFile);
            }
            case "SA-9602B": {
                return new SA9602B(unifFile);
            }
            case "SACHEN-8259A": {
                return new Sachen8259A(unifFile);
            }
            case "SACHEN-8259B": {
                return new Sachen8259B(unifFile);
            }
            case "SACHEN-8259C": {
                return new Sachen8259C(unifFile);
            }
            case "SACHEN-8259D": {
                return new Sachen8259D(unifFile);
            }
            case "SB-5013": {
                return new BMCSB5013(unifFile);
            }
            case "SHERO": {
                return new SHERO(unifFile);
            }
            case "SL1632": {
                return new Mapper014(unifFile);
            }
            case "SAROM": 
            case "SBROM": 
            case "SCROM": 
            case "SC1ROM": 
            case "SEROM": 
            case "SFROM": 
            case "SF1ROM": 
            case "SFEXPROM": 
            case "SGROM": 
            case "SHROM": 
            case "SH1ROM": 
            case "SIROM": 
            case "SJROM": 
            case "SKROM": 
            case "SLROM": 
            case "SL1ROM": 
            case "SL2ROM": 
            case "SL3ROM": 
            case "SLRROM": 
            case "SMROM": 
            case "SNROM": 
            case "SOROM": 
            case "SUROM": 
            case "SXROM": {
                return new MMC1(unifFile);
            }
            case "SMB2J": {
                return new SMB2J(unifFile);
            }
            case "SUPER24IN1SC03": {
                return new Super24In1SC03(unifFile);
            }
            case "SUPERHIK8IN1": {
                return new Mapper045(unifFile);
            }
            case "SUPERVISION16IN1": {
                return new Supervision16In1(unifFile);
            }
            case "T-230": {
                return new T230(unifFile);
            }
            case "T-262": {
                return new T262(unifFile);
            }
            case "TC-U01-1.5M": {
                return new Mapper147(unifFile);
            }
            case "TEK90": {
                return new JY(unifFile, 90);
            }
            case "TF1201": {
                return new TF1201(unifFile);
            }
            case "TH2131-1": {
                return new UNLTH2131_1(unifFile);
            }
            case "TJ-03": {
                return new BMCTJ03(unifFile);
            }
            case "TRANSFORMER": {
                return new Transformer(unifFile);
            }
            case "UN1ROM": {
                return new UN1ROM(unifFile);
            }
            case "UNROM": 
            case "UOROM": {
                return new UxROM(unifFile);
            }
            case "UNROM-512-8": 
            case "UNROM-512-16": 
            case "UNROM-512-32": {
                return new UNROM512(unifFile);
            }
            case "VRC7": {
                return new VRC7(unifFile);
            }
            case "WAIXING-FW01": {
                return new Mapper227(unifFile);
            }
            case "WS": {
                return new WS(unifFile);
            }
            case "YOKO": {
                return new YOKO(unifFile);
            }
        }
        return null;
    }

    public static Mapper create(NesFile nesFile) {
        switch (nesFile.getMapperNumber()) {
            case 0: {
                return new NROM(nesFile);
            }
            case 1: {
                return new MMC1(nesFile);
            }
            case 2: {
                if (nesFile.getFileCRC() == -111739670) {
                    return new DREAMTECH01(nesFile);
                }
                return new UxROM(nesFile);
            }
            case 3: {
                return new CNROM(nesFile);
            }
            case 4: {
                return new MMC3(nesFile);
            }
            case 5: {
                return new MMC5(nesFile);
            }
            case 6: {
                return new Mapper006(nesFile);
            }
            case 7: {
                return new AxROM(nesFile);
            }
            case 8: {
                return new Mapper008(nesFile);
            }
            case 9: {
                return new MMC2(nesFile);
            }
            case 10: {
                return new MMC4(nesFile);
            }
            case 11: {
                return new ColorDreams(nesFile);
            }
            case 12: {
                return new DragonBallZ5(nesFile);
            }
            case 13: {
                return new CPROM(nesFile);
            }
            case 14: {
                return new Mapper014(nesFile);
            }
            case 15: {
                return new Mapper015(nesFile);
            }
            case 16: {
                return new Mapper016(nesFile);
            }
            case 17: {
                return new Mapper017(nesFile);
            }
            case 18: {
                return new SS88006(nesFile);
            }
            case 19: {
                return new NamcoX(nesFile);
            }
            case 20: {
                return null;
            }
            case 21: {
                return new VRC2And4(nesFile);
            }
            case 22: {
                return new VRC2And4(nesFile);
            }
            case 23: {
                return new VRC2And4(nesFile);
            }
            case 24: {
                return new VRC6a(nesFile);
            }
            case 25: {
                return new VRC2And4(nesFile);
            }
            case 26: {
                return new VRC6b(nesFile);
            }
            case 27: {
                return new VRC2And4(nesFile);
            }
            case 28: {
                return new Streemerz(nesFile);
            }
            case 29: {
                return new Glider(nesFile);
            }
            case 30: {
                return new UNROM512(nesFile);
            }
            case 31: {
                return new Puritans(nesFile);
            }
            case 32: {
                return new G101(nesFile);
            }
            case 33: {
                return new TC0690(nesFile);
            }
            case 34: {
                switch (nesFile.getSubmapperNumber()) {
                    case 1: {
                        return new NINA001(nesFile);
                    }
                    case 2: {
                        return new BxROM(nesFile);
                    }
                }
                return nesFile.getChrRomLength() <= 8192 ? new BxROM(nesFile) : new NINA001(nesFile);
            }
            case 35: {
                return new Mapper035(nesFile);
            }
            case 36: {
                return new Txc22000(nesFile);
            }
            case 37: {
                return new Mapper037(nesFile);
            }
            case 38: {
                return new CrimeBusters(nesFile);
            }
            case 39: {
                return new BxROM(nesFile);
            }
            case 40: {
                return new Mapper040(nesFile);
            }
            case 41: {
                return new Mapper041(nesFile);
            }
            case 42: {
                return new Mapper042(nesFile);
            }
            case 43: {
                return new MrMary2(nesFile);
            }
            case 44: {
                return new Mapper044(nesFile);
            }
            case 45: {
                return new Mapper045(nesFile);
            }
            case 46: {
                return new RumbleStation(nesFile);
            }
            case 47: {
                return new Mapper047(nesFile);
            }
            case 48: {
                return new TC0690(nesFile);
            }
            case 49: {
                return new Mapper049(nesFile);
            }
            case 50: {
                return new Mapper050(nesFile);
            }
            case 51: {
                return new BMC051(nesFile);
            }
            case 52: {
                return new Mapper052(nesFile);
            }
            case 53: {
                return new Supervision(nesFile);
            }
            case 54: {
                return new NovelDiamond9999999In1(nesFile);
            }
            case 55: {
                return null;
            }
            case 56: {
                return new Kaiser7032(nesFile);
            }
            case 57: {
                return new Mapper057(nesFile);
            }
            case 58: {
                return new Mapper058(nesFile);
            }
            case 59: {
                return null;
            }
            case 60: {
                return new Mapper060(nesFile);
            }
            case 61: {
                return new Mapper061(nesFile);
            }
            case 62: {
                return new Mapper062(nesFile);
            }
            case 63: {
                return new BMC063(nesFile);
            }
            case 64: {
                return new RAMBO1(nesFile);
            }
            case 65: {
                return new H3001(nesFile);
            }
            case 66: {
                return new GxROM(nesFile);
            }
            case 67: {
                return new Sunsoft3(nesFile);
            }
            case 68: {
                return new Sunsoft4(nesFile);
            }
            case 69: {
                return new SunsoftFME7(nesFile);
            }
            case 70: {
                return new Bandai74161_7432(nesFile, false);
            }
            case 71: {
                return new BF909x(nesFile);
            }
            case 72: {
                return new JF17(nesFile);
            }
            case 73: {
                return new VRC3(nesFile);
            }
            case 74: {
                return new Mapper074(nesFile);
            }
            case 75: {
                return new VRC1(nesFile);
            }
            case 76: {
                return new Mapper076(nesFile);
            }
            case 77: {
                return new Mapper077(nesFile);
            }
            case 78: {
                return new Mapper078(nesFile);
            }
            case 79: {
                return new NINA003006(nesFile);
            }
            case 80: {
                return new X1005(nesFile);
            }
            case 81: {
                return new Mapper081(nesFile);
            }
            case 82: {
                return new X1017(nesFile);
            }
            case 83: {
                return new Mapper083(nesFile);
            }
            case 84: {
                return null;
            }
            case 85: {
                return new VRC7(nesFile);
            }
            case 86: {
                return new Moero(nesFile);
            }
            case 87: {
                return new Mapper087(nesFile);
            }
            case 88: {
                return new Mapper088(nesFile);
            }
            case 89: {
                return new Sunsoft2(nesFile);
            }
            case 90: {
                return new JY(nesFile, 90);
            }
            case 91: {
                return new Mapper091(nesFile);
            }
            case 92: {
                return new Mapper092(nesFile);
            }
            case 93: {
                return new Sunsoft2IC(nesFile);
            }
            case 94: {
                return new UN1ROM(nesFile);
            }
            case 95: {
                return new NAMCOT3425(nesFile);
            }
            case 96: {
                return new OekaKidsTablet(nesFile);
            }
            case 97: {
                return new TAMS1(nesFile);
            }
            case 98: {
                return null;
            }
            case 99: {
                VsGame vsGame = nesFile.getVsGame();
                if (vsGame != null && vsGame.isDualSystemGame()) {
                    return new MainVsDualSystem(nesFile);
                }
                return new VsUniSystem(nesFile);
            }
            case 100: {
                return null;
            }
            case 101: {
                return new JF10(nesFile);
            }
            case 102: {
                return null;
            }
            case 103: {
                return new Mapper103(nesFile);
            }
            case 104: {
                return new GoldenFive(nesFile);
            }
            case 105: {
                return new NesEvent(nesFile);
            }
            case 106: {
                return new Mapper106(nesFile);
            }
            case 107: {
                return new Mapper107(nesFile);
            }
            case 108: {
                return new Mapper108(nesFile);
            }
            case 109: {
                return null;
            }
            case 110: {
                return null;
            }
            case 111: {
                return null;
            }
            case 112: {
                return new Mapper112(nesFile);
            }
            case 113: {
                return new NINA06(nesFile);
            }
            case 114: {
                return new Mapper114(nesFile);
            }
            case 115: {
                return new Carson(nesFile);
            }
            case 116: {
                return new Mapper116(nesFile);
            }
            case 117: {
                return new Mapper117(nesFile);
            }
            case 118: {
                return new TxSROM(nesFile);
            }
            case 119: {
                return new TQROM(nesFile);
            }
            case 120: {
                return new Mapper120(nesFile);
            }
            case 121: {
                return new Mapper121(nesFile);
            }
            case 122: {
                return null;
            }
            case 123: {
                return new Mapper123(nesFile);
            }
            case 124: {
                return null;
            }
            case 125: {
                return new LH32(nesFile);
            }
            case 126: {
                return new PowerJoy(nesFile);
            }
            case 127: {
                return null;
            }
            case 128: {
                return null;
            }
            case 129: {
                return null;
            }
            case 130: {
                return null;
            }
            case 131: {
                return null;
            }
            case 132: {
                return new Txc22211A(nesFile);
            }
            case 133: {
                return new SA72008(nesFile);
            }
            case 134: {
                return new Mapper134(nesFile);
            }
            case 135: {
                return null;
            }
            case 136: {
                return new Sachen136(nesFile);
            }
            case 137: {
                return new Sachen8259D(nesFile);
            }
            case 138: {
                return new Sachen8259B(nesFile);
            }
            case 139: {
                return new Sachen8259C(nesFile);
            }
            case 140: {
                return new JF11(nesFile);
            }
            case 141: {
                return new Sachen8259A(nesFile);
            }
            case 142: {
                return new Kaiser7032(nesFile);
            }
            case 143: {
                return new SANROM(nesFile);
            }
            case 144: {
                return new DeathRace(nesFile);
            }
            case 145: {
                return new SA72007(nesFile);
            }
            case 146: {
                return new NINA06(nesFile);
            }
            case 147: {
                return new Mapper147(nesFile);
            }
            case 148: {
                return new SA0037(nesFile);
            }
            case 149: {
                return new SA0036(nesFile);
            }
            case 150: {
                return new Sachen74LS374Nb(nesFile);
            }
            case 151: {
                return new VRC1(nesFile);
            }
            case 152: {
                return new Bandai74161_7432(nesFile, true);
            }
            case 153: {
                return new Mapper153(nesFile);
            }
            case 154: {
                return new NAMCOT3453(nesFile);
            }
            case 155: {
                return new MMC1A(nesFile);
            }
            case 156: {
                return new DaouInfosys(nesFile);
            }
            case 157: {
                return new Mapper157(nesFile);
            }
            case 158: {
                return new T800037(nesFile);
            }
            case 159: {
                return new Mapper159(nesFile);
            }
            case 160: {
                return null;
            }
            case 161: {
                return null;
            }
            case 162: {
                return new Mapper162(nesFile);
            }
            case 163: {
                return new Nanjing(nesFile);
            }
            case 164: {
                return new Mapper164(nesFile);
            }
            case 165: {
                return new Mapper165(nesFile);
            }
            case 166: {
                return new Mapper166(nesFile);
            }
            case 167: {
                return new Mapper167(nesFile);
            }
            case 168: {
                return new RacerMate(nesFile);
            }
            case 169: {
                return null;
            }
            case 170: {
                return new Mapper170(nesFile);
            }
            case 171: {
                return new Kaiser7058(nesFile);
            }
            case 172: {
                return new Txc22211B(nesFile);
            }
            case 173: {
                return new Txc22211C(nesFile);
            }
            case 174: {
                return new Mapper174(nesFile);
            }
            case 175: {
                return new Kaiser7022(nesFile);
            }
            case 176: {
                return new Mapper176(nesFile);
            }
            case 177: {
                return new Henggedianzi177(nesFile);
            }
            case 178: {
                return new Education(nesFile);
            }
            case 179: {
                return new Henggedianzi179(nesFile);
            }
            case 180: {
                return new CrazyClimber(nesFile);
            }
            case 181: {
                return null;
            }
            case 182: {
                return new Mapper182(nesFile);
            }
            case 183: {
                return new ShuiGuanPipe(nesFile);
            }
            case 184: {
                return new Sunsoft1(nesFile);
            }
            case 185: {
                return new Mapper185(nesFile);
            }
            case 186: {
                return new StudyBox(nesFile);
            }
            case 187: {
                return new Mapper187(nesFile);
            }
            case 188: {
                return new KaraokeStudio(nesFile);
            }
            case 189: {
                return new Mapper189(nesFile);
            }
            case 190: {
                return new MagicKidGooGoo(nesFile);
            }
            case 191: {
                return new Mapper191(nesFile);
            }
            case 192: {
                return new Mapper192(nesFile);
            }
            case 193: {
                return new TC112(nesFile);
            }
            case 194: {
                return new Mapper194(nesFile);
            }
            case 195: {
                return new Mapper195(nesFile);
            }
            case 196: {
                return new Mapper196(nesFile);
            }
            case 197: {
                return new Mapper197(nesFile);
            }
            case 198: {
                return new Mapper198(nesFile);
            }
            case 199: {
                return new Mapper199(nesFile);
            }
            case 200: {
                return new Mapper200(nesFile);
            }
            case 201: {
                return new Mapper201(nesFile);
            }
            case 202: {
                return new Mapper202(nesFile);
            }
            case 203: {
                return new Mapper203(nesFile);
            }
            case 204: {
                return new Mapper204(nesFile);
            }
            case 205: {
                return new Mapper205(nesFile);
            }
            case 206: {
                return new DxROM(nesFile);
            }
            case 207: {
                return new X1005b(nesFile);
            }
            case 208: {
                return new Mapper208(nesFile);
            }
            case 209: {
                return new JY(nesFile, 209);
            }
            case 210: {
                return new NamcoX(nesFile);
            }
            case 211: {
                return new JY(nesFile, 211);
            }
            case 212: {
                return new Mapper212(nesFile);
            }
            case 213: {
                return new Mapper213(nesFile);
            }
            case 214: {
                return new Mapper214(nesFile);
            }
            case 215: {
                if (nesFile.getPrgRomLength() == 262144 && nesFile.getChrRomLength() == 524288) {
                    return new UNL8237(nesFile);
                }
                return new Boogerman(nesFile);
            }
            case 216: {
                return new Mapper216(nesFile);
            }
            case 217: {
                return new Mapper217(nesFile);
            }
            case 218: {
                return new MagicFloor(nesFile);
            }
            case 219: {
                return new Mapper219(nesFile);
            }
            case 220: {
                return new Gyruss(nesFile);
            }
            case 221: {
                return new Mapper221(nesFile);
            }
            case 222: {
                return new Mapper222(nesFile);
            }
            case 223: {
                return new Mapper074(nesFile);
            }
            case 224: {
                return null;
            }
            case 225: {
                return new Mapper225(nesFile);
            }
            case 226: {
                return new Mapper226(nesFile);
            }
            case 227: {
                return new Mapper227(nesFile);
            }
            case 228: {
                return new Mapper228(nesFile);
            }
            case 229: {
                return new Mapper229(nesFile);
            }
            case 230: {
                return new Mapper230(nesFile);
            }
            case 231: {
                return new Mapper231(nesFile);
            }
            case 232: {
                return new Mapper232(nesFile);
            }
            case 233: {
                return new Mapper233(nesFile);
            }
            case 234: {
                return new Maxi15(nesFile);
            }
            case 235: {
                return new BMC235(nesFile);
            }
            case 236: {
                return new BMC70In1(nesFile);
            }
            case 237: {
                return new Teletubbies(nesFile);
            }
            case 238: {
                return new Mapper238(nesFile);
            }
            case 239: {
                return null;
            }
            case 240: {
                return new Mapper240(nesFile);
            }
            case 241: {
                return new Mapper241(nesFile);
            }
            case 242: {
                return new Mapper242(nesFile);
            }
            case 243: {
                return new Sachen74LS374N(nesFile);
            }
            case 244: {
                return new Mapper244(nesFile);
            }
            case 245: {
                return new Mapper245(nesFile);
            }
            case 246: {
                return new Mapper246(nesFile);
            }
            case 247: {
                return null;
            }
            case 248: {
                return new Carson(nesFile);
            }
            case 249: {
                return new Mapper249(nesFile);
            }
            case 250: {
                return new Mapper250(nesFile);
            }
            case 251: {
                return null;
            }
            case 252: {
                return new Mapper252(nesFile);
            }
            case 253: {
                return new Mapper253(nesFile);
            }
            case 254: {
                return new Mapper254(nesFile);
            }
            case 255: {
                return new BMC255(nesFile);
            }
            case 256: {
                return new Mapper256(nesFile);
            }
            case 257: {
                return new PEC586(nesFile);
            }
            case 258: {
                return new UNL158B(nesFile);
            }
            case 259: {
                return new BMCF15(nesFile);
            }
            case 260: {
                return new BMCHPxx(nesFile);
            }
            case 261: {
                return new BMC810544CA1(nesFile);
            }
            case 262: {
                return new SHERO(nesFile);
            }
            case 263: {
                return new KOF97(nesFile);
            }
            case 264: {
                return new YOKO(nesFile);
            }
            case 265: {
                return new T262(nesFile);
            }
            case 266: {
                return new CityFighter(nesFile);
            }
            case 267: {
                return new Mapper267(nesFile);
            }
            case 268: {
                return new COOLBOY(nesFile);
            }
            case 269: {
                return new Mapper269(nesFile);
            }
            case 270: {
                return null;
            }
            case 271: {
                return new Txc22026(nesFile);
            }
            case 272: {
                return new Mapper272(nesFile);
            }
            case 273: {
                return new Mapper273(nesFile);
            }
            case 274: {
                return new BMC8013B(nesFile);
            }
            case 275: {
                return null;
            }
            case 276: {
                return null;
            }
            case 277: {
                return null;
            }
            case 278: {
                return null;
            }
            case 279: {
                return null;
            }
            case 280: {
                return null;
            }
            case 281: {
                return new Mapper281(nesFile);
            }
            case 282: {
                return new Mapper282(nesFile);
            }
            case 283: {
                return new GS2004(nesFile);
            }
            case 284: {
                return new DripGame(nesFile);
            }
            case 285: {
                return new A65AS(nesFile);
            }
            case 286: {
                return new BS5(nesFile);
            }
            case 287: {
                return new BMC411120C(nesFile);
            }
            case 288: {
                return new GKCX1(nesFile);
            }
            case 289: {
                return new BMC60311C(nesFile);
            }
            case 290: {
                return new NTD03(nesFile);
            }
            case 291: {
                return new Mapper291(nesFile);
            }
            case 292: {
                return new DRAGONFIGHTER(nesFile);
            }
            case 293: {
                return new Mapper293(nesFile);
            }
            case 294: {
                return new Mapper294(nesFile);
            }
            case 295: {
                return new Mapper295(nesFile);
            }
            case 296: {
                return null;
            }
            case 297: {
                return new Txc01_22110_000(nesFile);
            }
            case 298: {
                return new TF1201(nesFile);
            }
            case 299: {
                return new BMC11160(nesFile);
            }
            case 300: {
                return new BMC190In1(nesFile);
            }
            case 301: {
                return new BMC8157(nesFile);
            }
            case 302: {
                return new Kaiser7057(nesFile);
            }
            case 303: {
                return new Kaiser7017(nesFile);
            }
            case 304: {
                return new SMB2J(nesFile);
            }
            case 305: {
                return new Kaiser7031(nesFile);
            }
            case 306: {
                return new Kaiser7016(nesFile);
            }
            case 307: {
                return new Kaiser7037(nesFile);
            }
            case 308: {
                return new UNLTH2131_1(nesFile);
            }
            case 309: {
                return new LH51(nesFile);
            }
            case 310: {
                return null;
            }
            case 311: {
                return null;
            }
            case 312: {
                return new Kaiser7013B(nesFile);
            }
            case 313: {
                return new ResetTxROM(nesFile);
            }
            case 314: {
                return new BMC64In1NoRepeat(nesFile);
            }
            case 315: {
                return new BMC830134C(nesFile);
            }
            case 316: {
                return null;
            }
            case 317: {
                return null;
            }
            case 319: {
                return new HP898F(nesFile);
            }
            case 320: {
                return new BMC830425C4391T(nesFile);
            }
            case 321: {
                return null;
            }
            case 322: {
                return new BMCK3033(nesFile);
            }
            case 323: {
                return new FARID_SLROM_8IN1(nesFile);
            }
            case 324: {
                return new FARID_UNROM_8IN1(nesFile);
            }
            case 325: {
                return new MALISB(nesFile);
            }
            case 326: {
                return new Mapper326(nesFile);
            }
            case 327: {
                return new BMC1024CA1(nesFile);
            }
            case 328: {
                return new RT01(nesFile);
            }
            case 329: {
                return new EDU2000(nesFile);
            }
            case 330: {
                return new Mapper330(nesFile);
            }
            case 331: {
                return new BMC12In1(nesFile);
            }
            case 332: {
                return new WS(nesFile);
            }
            case 333: {
                return new BMC8In1(nesFile);
            }
            case 334: {
                return new Mapper334(nesFile);
            }
            case 335: {
                return new BMCCTC09(nesFile);
            }
            case 336: {
                return new BMCK3046(nesFile);
            }
            case 337: {
                return new BMCCTC12IN1(nesFile);
            }
            case 338: {
                return new BMCSA005A(nesFile);
            }
            case 339: {
                return new BMCK3006(nesFile);
            }
            case 340: {
                return new BMCK3036(nesFile);
            }
            case 341: {
                return new BMCTJ03(nesFile);
            }
            case 342: {
                return new COOLGIRL(nesFile);
            }
            case 343: {
                return new Mapper343(nesFile);
            }
            case 344: {
                return new BMCGN26(nesFile);
            }
            case 345: {
                return new BMCL6IN1(nesFile);
            }
            case 346: {
                return new Kaiser7012(nesFile);
            }
            case 347: {
                return new Kaiser7030(nesFile);
            }
            case 348: {
                return new BMC830118C(nesFile);
            }
            case 349: {
                return new G146(nesFile);
            }
            case 350: {
                return new BMC891227(nesFile);
            }
            case 351: {
                return new Mapper351(nesFile);
            }
            case 352: {
                return new Kaiser106C(nesFile);
            }
            case 353: {
                return new Mapper353(nesFile);
            }
            case 354: {
                return new Mapper354(nesFile);
            }
            case 355: {
                return new _3D_Block(nesFile);
            }
            case 356: {
                return new Mapper356(nesFile);
            }
            case 357: {
                return new Mapper357(nesFile);
            }
            case 358: {
                return new Mapper358(nesFile);
            }
            case 359: {
                return new BMCSB5013(nesFile);
            }
            case 360: {
                return new Mapper360(nesFile);
            }
            case 361: {
                return new Mapper361(nesFile);
            }
            case 362: {
                return new Mapper362(nesFile);
            }
            case 363: {
                return new Mapper363(nesFile);
            }
            case 364: {
                return new Mapper364(nesFile);
            }
            case 365: {
                return new AsderPC95(nesFile);
            }
            case 366: {
                return new GN45(nesFile);
            }
            case 512: {
                return new Mapper512(nesFile);
            }
            case 513: {
                return new SA9602B(nesFile);
            }
            case 514: {
                return new SuborKaraoke(nesFile);
            }
            case 515: {
                return new Mapper515(nesFile);
            }
            case 516: {
                return new Mapper516(nesFile);
            }
            case 517: {
                return new Mapper517(nesFile);
            }
            case 518: {
                return new DANCE2000(nesFile);
            }
            case 519: {
                return new EH8813A(nesFile);
            }
            case 520: {
                return new Mapper520(nesFile);
            }
            case 521: {
                return new DREAMTECH01(nesFile);
            }
            case 522: {
                return new LH10(nesFile);
            }
            case 523: {
                return null;
            }
            case 524: {
                return new BTL900218(nesFile);
            }
            case 525: {
                return new Kaiser7021A(nesFile);
            }
            case 526: {
                return new BJ56(nesFile);
            }
            case 527: {
                return new AX40G(nesFile);
            }
            case 528: {
                return new UNL831128C(nesFile);
            }
            case 529: {
                return new T230(nesFile);
            }
            case 530: {
                return new AX5705(nesFile);
            }
            case 531: {
                return new PC95KO01(nesFile);
            }
            case 532: {
                return new NamcoX(nesFile);
            }
            case 533: {
                return new Sachen3014(nesFile);
            }
            case 534: {
                return new Mapper534(nesFile);
            }
        }
        return null;
    }
}

