/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.daouinfosys;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper517
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int adcData;
    private int adcHigh;
    private int adcLow;
    private int state;

    public Mapper517(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.setPrgBank(3, -1);
        this.state = 0;
        this.adcData = 0;
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 24576) {
            if (address == 0) {
                switch (this.state) {
                    case 0: {
                        ++this.state;
                        return 0;
                    }
                    case 1: {
                        ++this.state;
                        return 1;
                    }
                }
                if (this.adcLow > 0) {
                    --this.adcLow;
                    return 1;
                }
                this.state = 0;
                return 0;
            }
            return this.adcHigh-- > 0 ? 0 : 1;
        }
        return super.readMemory(address);
    }

    private int readMicrophone() {
        return 0;
    }

    @Override
    protected void writeRegister(int address, int value) {
        if ((address & 0xF000) == 32768) {
            this.adcData = (int)((double)this.readMicrophone() * 63.0);
            this.adcHigh = this.adcData >> 2;
            this.adcLow = 64 - this.adcHigh - ((this.adcData & 3) << 2);
            this.state = 0;
            this.setPrgBank(2, value);
        }
    }
}

