/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper267
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int outerBank;

    public Mapper267(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.outerBank = 0;
        this.writeOuterBank(0);
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void writeOuterBank(int value) {
        if (!BitUtil.getBitBool(this.outerBank, 7)) {
            this.outerBank = value;
            int block = (this.outerBank & 0x20) >> 2 | this.outerBank & 6;
            this.setPrgBlock(block << 4, 31);
            this.setChrBlock(block << 6, 127);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.writeOuterBank(value);
        }
        super.writeMemory(address, value);
    }
}

