/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.kaiser;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Kaiser7022
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int reg;

    public Kaiser7022(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.reg = 0;
        this.setPrgBank(2, 0);
    }

    @Override
    public void resetting() {
        this.reg = 0;
        this.readMemory(65532);
    }

    @Override
    public int readMemory(int address) {
        if (address == 65532) {
            this.setChrBank(this.reg);
            this.setPrgBank(2, this.reg);
            this.setPrgBank(3, this.reg);
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address) {
            case 32768: {
                this.setNametableMirroring(BitUtil.getBit(value, 2));
                break;
            }
            case 40960: {
                this.reg = value & 0xF;
            }
        }
    }
}

