/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.kaiser;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Kaiser7030
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int bank1;
    private int bank2;

    public Kaiser7030(CartFile cartFile) {
        super(cartFile, 1, 1);
    }

    @Override
    public void init() {
        this.bank2 = 255;
        this.bank1 = 255;
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void writeMirroringSelect(int value) {
        this.setNametableMirroring(BitUtil.getBit(value, 3));
    }

    private void writePrgRomBankSelect1(int value) {
        this.bank1 = (value & 7) << 12;
    }

    private void writePrgRomBankSelect2(int value) {
        this.bank2 = (value & 0xF) << 12;
    }

    @Override
    public int readMemory(int address) {
        if (address >= 24576 && address <= 27647) {
            return this.memory[address];
        }
        if (address >= 27648 && address <= 28671) {
            return this.prgROM[address - 27648 + 4096 * this.bank2 + 32768 & this.prgRomSizeMask];
        }
        if (address >= 28672 && address <= Short.MAX_VALUE) {
            return this.prgROM[address - 28672 + 4096 * this.bank1 + 0 & this.prgRomSizeMask];
        }
        if (address >= 47104 && address <= 49151) {
            return this.memory[address];
        }
        if (address >= 49152 && address <= 52223) {
            return this.prgROM[address - 49152 + 4096 * this.bank2 + 33792 & this.prgRomSizeMask];
        }
        if (address >= 52224 && address <= 55295) {
            return this.memory[address];
        }
        if (address >= 32768) {
            return this.prgROM[address - 32768 + 98304 & this.prgRomSizeMask];
        }
        return this.memory[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address == 16421) {
            this.setNametableMirroring((value & 8) != 0 ? 1 : 0);
        }
        if (address >= 24576 && address <= 27647) {
            this.memory[address] = value;
        } else if (address >= 47104 && address <= 49151) {
            this.memory[address] = value;
        } else if (address >= 52224 && address <= 55295) {
            this.memory[address] = value;
        } else if (address >= 32768 && address <= 36863) {
            this.bank1 = value & 7;
        } else if (address >= 36864 && address <= 40959) {
            this.bank2 = value & 0xF;
        }
    }
}

