/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc6;

import nintaco.mappers.konami.vrc6.VrcChannel;
import nintaco.util.BitUtil;

public class VrcPulseGenerator
extends VrcChannel {
    private static final long serialVersionUID = 0L;
    private int volume;
    private int dutyReset;
    private boolean ignoreDuty;
    private int duty = 15;

    public void reset() {
        this.volume = 0;
        this.dutyReset = 0;
        this.ignoreDuty = false;
        this.duty = 15;
    }

    public void writeControl(int value) {
        this.volume = value & 0xF;
        this.dutyReset = value >> 4 & 7;
        this.ignoreDuty = BitUtil.getBitBool(value, 7);
        this.outputLevel = this.ignoreDuty ? this.volume : (this.duty <= this.dutyReset ? this.volume : 0);
    }

    public void update() {
        if (this.runOscillator) {
            if (this.frequency == 0) {
                this.frequency = this.frequencyReload >> this.frequencyShift;
                if (this.enabled) {
                    this.duty = this.duty == 0 ? 15 : --this.duty;
                }
                if (!this.ignoreDuty) {
                    this.outputLevel = this.duty <= this.dutyReset ? this.volume : 0;
                }
            } else {
                --this.frequency;
            }
        }
    }

    @Override
    public void writeFrequencyHigh(int value) {
        super.writeFrequencyHigh(value);
        if (!this.enabled) {
            this.duty = 15;
        }
    }
}

