/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc7;

import nintaco.mappers.Audio;
import nintaco.mappers.konami.vrc7.Emu2413;
import nintaco.mappers.konami.vrc7.OPLL;
import nintaco.util.BitUtil;

public final class VRC7Audio
extends Audio {
    private static final long serialVersionUID = 0L;
    private static final int MIX_RANGE = Short.MAX_VALUE;
    private static final int AUDIO_SCALE = 63;
    private static float volume;
    private boolean soundEnabled;
    private int soundSample;
    private OPLL opll;
    private int divider;

    public static void setVolume(int volume) {
        VRC7Audio.volume = (float)volume / 100.0f;
    }

    @Override
    public void init() {
        Emu2413.OPLL_init();
        this.opll = Emu2413.OPLL_new();
        this.reset();
    }

    @Override
    public void reset() {
        this.soundEnabled = false;
        this.soundSample = 0;
        this.divider = 0;
        for (int i = 0; i < 64; ++i) {
            Emu2413.OPLL_writeIO(this.opll, 0, i);
            Emu2413.OPLL_writeIO(this.opll, 1, 0);
        }
        Emu2413.OPLL_reset_patch(this.opll);
        Emu2413.OPLL_reset(this.opll);
    }

    @Override
    public boolean writeRegister(int address, int value) {
        switch (address) {
            case 36880: {
                Emu2413.OPLL_writeIO(this.opll, 0, value);
                return true;
            }
            case 36912: {
                Emu2413.OPLL_writeIO(this.opll, 1, value);
                return true;
            }
            case 57344: {
                this.soundEnabled = !BitUtil.getBitBool(value, 6);
                return false;
            }
        }
        return false;
    }

    @Override
    public void update() {
        while (++this.divider >= 36) {
            this.divider -= 36;
            Emu2413.OPLL_calc(this.opll);
        }
        this.soundSample = 0;
        for (int i = 0; i < 6; ++i) {
            this.soundSample += this.opll.slot[i << 1 | 1].output[1];
        }
        this.soundSample = 32768 + this.soundSample * 63;
    }

    @Override
    public int getAudioMixerScale() {
        return 32768;
    }

    @Override
    public float getAudioSample() {
        return volume * (float)this.soundSample;
    }

    static {
        VRC7Audio.setVolume(100);
    }
}

