/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.vs;

import nintaco.files.CartFile;
import nintaco.input.DeviceMapper;
import nintaco.input.InputDevices;
import nintaco.input.gamepad.GamepadMapper;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.MainVsDualSystem;
import nintaco.mappers.nintendo.vs.SplitCartFile;
import nintaco.util.BitUtil;

public class SubVsDualSystem
extends Mapper {
    private static final long serialVersionUID = 0L;
    private MainVsDualSystem mainVsDualSystem;

    public SubVsDualSystem(CartFile cartFile) {
        super(new SplitCartFile(cartFile, false), 8, 1);
        this.setNametableMirroring(4);
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 1);
        this.setPrgBank(6, 2);
        this.setPrgBank(7, 3);
    }

    @Override
    public boolean isVsDualSystem() {
        return true;
    }

    public MainVsDualSystem getMainVsDualSystem() {
        return this.mainVsDualSystem;
    }

    public void setMainVsDualSystem(MainVsDualSystem mainVsDualSystem) {
        this.mainVsDualSystem = mainVsDualSystem;
    }

    @Override
    public int readCpuMemory(int address) {
        if ((address & 0xE000) == 24576) {
            return this.mainVsDualSystem.readCpuMemory(address);
        }
        if (address == 16406) {
            return 0x80 | super.readCpuMemory(address);
        }
        return super.readCpuMemory(address);
    }

    @Override
    public void writeCpuMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.mainVsDualSystem.writeCpuMemory(address, value);
        } else {
            if (address == 16406) {
                this.writeBankSelect(value);
            }
            super.writeCpuMemory(address, value);
        }
    }

    public void setMapperIrq(boolean value) {
        this.cpu.setMapperIrq(value);
    }

    private void writeBankSelect(int value) {
        int bank = BitUtil.getBit(value, 2);
        this.setChrBank(bank);
        if (this.prgRomLength > 32768) {
            this.setPrgBank(4, bank << 2);
        }
        if (BitUtil.getBitBool(value, 1)) {
            this.mainVsDualSystem.setMapperIrq(false);
        } else {
            this.mainVsDualSystem.setMapperIrq(true);
        }
    }

    @Override
    public void updateButtons(int buttons) {
        this.buttons = buttons;
        if (this.coinInserted > 0 && --this.coinInserted == 0) {
            this.coinMask = 0;
        }
        if (this.serviceButtonPressed > 0 && --this.serviceButtonPressed == 0) {
            this.serviceButtonMask = 0;
        }
    }

    @Override
    public void writeOutputPort(int value) {
        DeviceMapper[] mappers = this.deviceMappers;
        for (int i = mappers.length - 1; i >= 0; --i) {
            DeviceMapper mapper = mappers[i];
            if (!InputDevices.isGamepad(mapper.getInputDevice()) || ((GamepadMapper)mapper).getPortIndex() <= 1) continue;
            mappers[i].writePort(value);
        }
    }

    @Override
    public int readInputPort(int portIndex) {
        DeviceMapper[] mappers = this.deviceMappers;
        int value = portIndex == 0 ? this.coinMask | (this.dipSwitchesValue & 3) << 3 | this.serviceButtonMask : this.dipSwitchesValue & 0xFC;
        portIndex += 2;
        for (int i = mappers.length - 1; i >= 0; --i) {
            value |= mappers[i].readPort(portIndex);
        }
        return value;
    }

    @Override
    public int peekInputPort(int portIndex) {
        DeviceMapper[] mappers = this.deviceMappers;
        int value = portIndex == 0 ? this.coinMask | (this.dipSwitchesValue & 3) << 3 | this.serviceButtonMask : this.dipSwitchesValue & 0xFC;
        portIndex += 2;
        for (int i = mappers.length - 1; i >= 0; --i) {
            value |= mappers[i].peekPort(portIndex);
        }
        return value;
    }
}

