/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class TC112
extends Mapper {
    private static final long serialVersionUID = 0L;

    public TC112(CartFile cartFile) {
        super(cartFile, 8, 4);
        this.setPrgBank(5, -3);
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 24576 && address < 32768) {
            switch (address & 0x6003) {
                case 24576: {
                    this.writeChrBank(0, value);
                    this.writeChrBank(1, value + 2);
                    break;
                }
                case 24577: {
                    this.writeChrBank(2, value);
                    break;
                }
                case 24578: {
                    this.writeChrBank(3, value);
                    break;
                }
                case 24579: {
                    this.setPrgBank(4, value);
                }
            }
        } else {
            this.memory[address] = value;
        }
    }

    private void writeChrBank(int bank, int value) {
        this.chrBanks[bank] = value << 10;
    }
}

