/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper057
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int AAA;
    private int BBB;

    public Mapper057(NesFile nesFile) {
        super(nesFile, 4, 1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0x8800) {
            case 32768: {
                this.writeA(value);
                break;
            }
            case 34816: {
                this.writeB(value);
            }
        }
    }

    private void writeA(int value) {
        this.AAA = (value & 0x40) >> 3 | value & 7;
        this.updateChrBank();
    }

    private void writeB(int value) {
        int PPP = value >> 5;
        if (BitUtil.getBitBool(value, 4)) {
            this.setPrgBank(2, PPP & 6);
            this.setPrgBank(3, PPP | 1);
        } else {
            this.setPrgBank(2, PPP);
            this.setPrgBank(3, PPP);
        }
        this.BBB = value & 7;
        this.updateChrBank();
        this.setNametableMirroring(BitUtil.getBit(value, 3));
    }

    private void updateChrBank() {
        this.setChrBank(0, this.AAA | this.BBB);
    }
}

