/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper103
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean prgRamDisabled;

    public Mapper103(CartFile cartFile) {
        super(cartFile, 8, 1);
    }

    @Override
    public void init() {
        this.setChrBank(0);
        this.setPrgBanks(4, 4, -4);
    }

    @Override
    public int readMemory(int address) {
        if (address >= 24576 && (this.prgRamDisabled || address >= 55296 || address >= 32768 && address < 47104)) {
            return this.prgROM[(this.prgBanks[address >> this.prgShift] | address & this.prgAddressMask) & this.prgRomSizeMask];
        }
        return this.memory[address];
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF000) {
            case 32768: {
                this.setPrgBank(3, value & 0xF);
                break;
            }
            case 57344: {
                this.setNametableMirroring(BitUtil.getBit(value, 3));
                break;
            }
            case 61440: {
                this.prgRamDisabled = BitUtil.getBitBool(value, 4);
            }
        }
    }
}

