/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper226
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected int[] registers = new int[2];

    public Mapper226(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.registers[0] = 0;
        this.registers[1] = 0;
        this.setPrgBank(2, 0);
        this.setPrgBank(3, 1);
        this.setChrBank(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0x8001) {
            case 32768: {
                this.registers[0] = value;
                break;
            }
            case 32769: {
                this.registers[1] = value;
            }
        }
        this.updatePrg();
        this.setNametableMirroring(BitUtil.getBit(this.registers[0], 6) ^ 1);
    }

    protected int getPrgPage() {
        return this.registers[0] & 0x1F | (this.registers[0] & 0x80) >> 2 | (this.registers[1] & 1) << 6;
    }

    protected void updatePrg() {
        int prgPage = this.getPrgPage();
        if (BitUtil.getBitBool(this.registers[0], 5)) {
            this.setPrgBank(2, prgPage);
            this.setPrgBank(3, prgPage);
        } else {
            this.setPrgBank(2, prgPage & 0xFE);
            this.setPrgBank(3, (prgPage & 0xFE) + 1);
        }
    }
}

