/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper253
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] chrLow = new int[8];
    private final int[] chrHigh = new int[8];
    private final boolean[] chrRamBanks = new boolean[8];
    private boolean chrRomMode;
    private int irqScaler;
    private int irqReloadValue;
    private int irqCounter;
    private boolean irqEnabled;

    public Mapper253(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192 && this.chrAddressMask != 0) {
            return (this.chrRamBanks[address >> this.chrShift] ? this.vram : this.chrROM)[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192 && this.chrAddressMask != 0) {
            if (this.chrRamBanks[address >> this.chrShift]) {
                this.vram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask] = value;
            }
        } else {
            this.vram[address] = value;
        }
    }

    private void updateChrBanks() {
        for (int i = 7; i >= 0; --i) {
            int low = this.chrLow[i];
            int bank = this.chrHigh[i] << 8 | low;
            if (!(low != 4 && low != 5 || this.chrRomMode)) {
                this.chrRamBanks[i] = true;
                this.setChrBank(i, bank & 1);
                continue;
            }
            this.chrRamBanks[i] = false;
            this.setChrBank(i, bank);
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            this.irqScaler = this.irqScaler + 1 & 0xFFFF;
            if (this.irqScaler >= 114) {
                this.irqScaler = 0;
                this.irqCounter = this.irqCounter + 1 & 0xFF;
                if (this.irqCounter == 0) {
                    this.irqCounter = this.irqReloadValue;
                    this.cpu.setMapperIrq(true);
                }
            }
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 45056 && address <= 57356) {
            int low;
            int index = ((address & 8 | address >> 8) >> 3) + 2 & 7;
            int shift = address & 4;
            this.chrLow[index] = low = this.chrLow[index] & 240 >> shift | value << shift;
            if (index == 0) {
                if (low == 200) {
                    this.chrRomMode = false;
                } else if (low == 136) {
                    this.chrRomMode = true;
                }
            }
            if (shift != 0) {
                this.chrHigh[index] = value >> 4;
            }
            this.updateChrBanks();
        } else {
            switch (address) {
                case 32784: {
                    this.setPrgBank(4, value);
                    break;
                }
                case 40976: {
                    this.setPrgBank(5, value);
                    break;
                }
                case 37888: {
                    this.setNametableMirroring(value & 3);
                    break;
                }
                case 61440: {
                    this.irqReloadValue = this.irqReloadValue & 0xF0 | value & 0xF;
                    this.cpu.setMapperIrq(false);
                    break;
                }
                case 61444: {
                    this.irqReloadValue = this.irqReloadValue & 0xF | value << 4;
                    this.cpu.setMapperIrq(false);
                    break;
                }
                case 61448: {
                    this.irqCounter = this.irqReloadValue;
                    this.irqEnabled = BitUtil.getBitBool(value, 1);
                    this.irqScaler = 0;
                    this.cpu.setMapperIrq(false);
                }
            }
        }
    }
}

