/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class MrMary2
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] LUT = new int[]{4, 3, 5, 3, 6, 3, 7, 3};
    private int bank6;
    private int irqCounter;
    private boolean irqEnabled;
    private boolean swap;

    public MrMary2(CartFile cartFile) {
        super(cartFile, 8, 1, 16416, 24576);
    }

    @Override
    public void init() {
        this.bank6 = 0;
        this.irqCounter = 0;
        this.irqEnabled = false;
        this.swap = false;
        this.updateBanks();
        this.setPrgBank(4, 1);
        this.setPrgBank(5, 0);
        this.setChrBank(0);
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            ++this.irqCounter;
            if (this.irqCounter >= 4096) {
                this.irqEnabled = false;
                this.cpu.setMapperIrq(true);
            }
        }
    }

    private void updateBanks() {
        this.setPrgBank(3, this.swap ? 0 : 2);
        this.setPrgBank(6, this.bank6);
        this.setPrgBank(7, this.swap ? 8 : 9);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 20480) {
            return this.prgROM[(0x10000 | address & this.prgAddressMask) & this.prgRomSizeMask];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address & 0xF1FF) {
            case 16418: {
                this.bank6 = LUT[value & 7];
                this.updateBanks();
                break;
            }
            case 16672: {
                this.swap = BitUtil.getBitBool(value, 0);
                this.updateBanks();
                break;
            }
            case 16674: 
            case 33058: {
                this.irqEnabled = BitUtil.getBitBool(value, 0);
                this.cpu.setMapperIrq(false);
                this.irqCounter = 0;
            }
        }
    }
}

