/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper014
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] vrcChrRegs = new int[8];
    private int mode;

    public Mapper014(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void updateChrBanks() {
        int page0 = (this.mode & 8) << 5;
        int page1 = (this.mode & 0x20) << 3;
        int page2 = (this.mode & 0x80) << 1;
        if (this.chrMode) {
            this.setChrBank(0, page1 | this.R[2]);
            this.setChrBank(1, page1 | this.R[3]);
            this.setChrBank(2, page2 | this.R[4]);
            this.setChrBank(3, page2 | this.R[5]);
            this.setChrBank(4, page0 | this.R[0] & 0xFE);
            this.setChrBank(5, page0 | (this.R[0] | 1));
            this.setChrBank(6, page0 | this.R[1] & 0xFE);
            this.setChrBank(7, page0 | (this.R[1] | 1));
        } else {
            this.setChrBank(0, page0 | this.R[0] & 0xFE);
            this.setChrBank(1, page0 | (this.R[0] | 1));
            this.setChrBank(2, page0 | this.R[1] & 0xFE);
            this.setChrBank(3, page0 | (this.R[1] | 1));
            this.setChrBank(4, page1 | this.R[2]);
            this.setChrBank(5, page1 | this.R[3]);
            this.setChrBank(6, page2 | this.R[4]);
            this.setChrBank(7, page2 | this.R[5]);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 16640) {
            if (address == 41265) {
                this.mode = value;
            }
            if (BitUtil.getBitBool(this.mode, 1)) {
                this.updateBanks();
                this.writeRegister(address, value);
            } else {
                if (address >= 45056 && address <= 57347) {
                    int index = ((address & 2 | address >> 10) >> 1) + 2 & 7;
                    int shift = (address & 1) << 2;
                    this.vrcChrRegs[index] = this.vrcChrRegs[index] & 240 >> shift | (value & 0xF) << shift;
                    this.setChrBank(index, this.vrcChrRegs[index]);
                } else {
                    switch (address & 0xF003) {
                        case 32768: {
                            this.setPrgBank(4, value);
                            break;
                        }
                        case 40960: {
                            this.setPrgBank(5, value);
                            break;
                        }
                        case 36864: {
                            this.setNametableMirroring(value & 1);
                        }
                    }
                }
                this.setPrgBank(6, -2);
                this.setPrgBank(7, -1);
            }
        }
    }
}

