/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.piratemmc3.BlockMMC3;
import nintaco.util.BitUtil;

public class Mapper049
extends BlockMMC3 {
    private static final long serialVersionUID = 0L;
    protected int prgReg;
    protected boolean mmc3PrgMode;

    public Mapper049(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.sramRegister = false;
        super.init();
    }

    @Override
    protected void updateBlock(int value) {
        this.setBlock((value & 0xC0) >> 2, 15, (value & 0xC0) << 1, 127);
        this.prgReg = (value & 0x30) << 11;
        this.mmc3PrgMode = BitUtil.getBitBool(value, 0);
        this.updatePrgBanks();
    }

    @Override
    protected void writePrgRamProtect(int value) {
        super.writePrgRamProtect(value);
        this.sramRegister = this.prgRamWritesEnabled;
    }

    @Override
    protected void updatePrgBanks() {
        if (this.mmc3PrgMode) {
            super.updatePrgBanks();
        } else {
            this.setBanks(this.prgBanks, 4, this.prgReg, 4, 8192);
        }
    }
}

