/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class PowerJoy
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int reg0;
    private int reg1;
    private int reg2;

    public PowerJoy(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void updateBanks() {
        int chrBank;
        int chrMask;
        int prgBank;
        int prgMask;
        if (BitUtil.getBitBool(this.reg0, 6)) {
            prgMask = 15;
            prgBank = (this.reg0 & 7) << 4;
        } else {
            prgMask = 31;
            prgBank = (this.reg0 & 6) << 4;
        }
        prgBank |= (this.reg0 & 0x10) << 3;
        if (BitUtil.getBitBool(this.reg0, 7)) {
            chrMask = 127;
            chrBank = (this.reg0 & 8) << 4;
        } else {
            chrMask = 255;
            chrBank = 0;
        }
        chrBank |= (this.reg0 & 0x20) << 3;
        chrBank |= (this.reg0 & 0x10) << 5;
        if (!BitUtil.getBitBool(this.reg2, 3)) {
            switch (this.reg2 & 3) {
                case 0: {
                    this.setPrgBlockMask(prgMask);
                    this.setPrgBlockOffset(prgBank);
                    this.updatePrgBanks();
                    break;
                }
                case 1: 
                case 2: {
                    this.setPrgBlockMask(-1);
                    this.setPrgBlockOffset(0);
                    int bank = ((this.prgMode ? 62 : this.R[6]) & prgMask | prgBank) & 0xFE;
                    this.setPrgBanks(4, 2, bank);
                    this.setPrgBanks(6, 2, bank);
                    break;
                }
                case 3: {
                    this.setPrgBlockMask(-1);
                    this.setPrgBlockOffset(0);
                    this.setPrgBanks(4, 4, ((this.prgMode ? 62 : this.R[6]) & prgMask | prgBank) & 0xFC);
                }
            }
        }
        if (BitUtil.getBitBool(this.reg2, 4)) {
            if (!BitUtil.getBitBool(this.reg0, 7)) {
                chrBank |= this.reg1 & 0x80;
            }
            this.setChrBlockMask(-1);
            this.setChrBlockOffset(0);
            this.setChrBanks(0, 8, (this.reg1 & 0xF | chrBank >> 3) << 3);
        } else {
            this.setChrBlockMask(chrMask);
            this.setChrBlockOffset(chrBank);
            this.updateChrBanks();
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if ((address & 0xE000) == 24576) {
            switch (address & 3) {
                case 0: {
                    if (BitUtil.getBitBool(this.reg2, 7)) {
                        return;
                    }
                    this.reg0 = value;
                    break;
                }
                case 2: {
                    this.reg1 = value;
                    break;
                }
                case 3: {
                    if (BitUtil.getBitBool(this.reg2, 7)) {
                        return;
                    }
                    this.reg2 = value;
                }
            }
            this.updateBanks();
        } else if (address >= 32768) {
            this.writeRegister(address, value);
        }
    }
}

