/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sachen;

import nintaco.files.CartFile;
import nintaco.mappers.sachen.Sachen8259;
import nintaco.util.BitUtil;

public class Sachen8259D
extends Sachen8259 {
    private static final long serialVersionUID = 0L;

    public Sachen8259D(CartFile cartFile) {
        super(cartFile, 2, 8);
        this.setChrBank(4, -4);
        this.setChrBank(5, -3);
        this.setChrBank(6, -2);
        this.setChrBank(7, -1);
    }

    @Override
    public void init() {
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address & 0xC101) {
            case 16640: {
                this.writeRegisterSelect(value);
                break;
            }
            case 16384: 
            case 16385: 
            case 16641: {
                this.writeRegisterData(value);
                break;
            }
            default: {
                this.memory[address] = value;
            }
        }
    }

    @Override
    protected void writeRegisterData(int value) {
        value &= 7;
        switch (this.register) {
            case 0: {
                this.writeChrSelect(0, value);
                break;
            }
            case 1: {
                this.writeChrSelect(1, value);
                break;
            }
            case 2: {
                this.writeChrSelect(2, value);
                break;
            }
            case 3: {
                this.writeChrSelect(3, value);
                break;
            }
            case 4: {
                this.writeChrTopBit(1, value, 0);
                this.writeChrTopBit(2, value, 1);
                this.writeChrTopBit(3, value, 2);
                break;
            }
            case 5: {
                this.setPrgBank(value);
                break;
            }
            case 6: {
                this.chrRegs[3] = this.chrRegs[3] & 0xF7 | (value & 1) << 3;
                this.updateChrBanks();
                break;
            }
            case 7: {
                this.writeModeAndMirroringSelect(value);
            }
        }
    }

    private void writeChrTopBit(int bank, int value, int bit) {
        this.chrRegs[bank] = this.chrRegs[bank] & 0xEF | BitUtil.getBit(value, bit) << 4;
        this.updateChrBanks();
    }

    @Override
    protected void updateChrBanks() {
        for (int i = 3; i >= 0; --i) {
            this.setChrBank(i, this.chrRegs[i]);
        }
    }
}

