/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sunsoft;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Sunsoft4
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int LICENSING_TIMER_RESET = 107520;
    private final int[] nametableBanks = new int[2];
    private int licensingTimer;
    private boolean licensingEnabled;
    private boolean wramEnabled;
    private boolean internalRomEnabled;
    private boolean chrRomNametablesEnabled;

    public Sunsoft4(CartFile cartFile) {
        super(cartFile, 4, 4);
    }

    @Override
    public void init() {
        this.setPrgBank(3, 7);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.chrROM[(this.chrBanks[address >> 11] | address & 0x7FF) & this.chrRomSizeMask];
        }
        if (this.chrRomNametablesEnabled && address < 10240) {
            return this.chrROM[(this.nametableBanks[address < 9216 ? 0 : 1] | address & 0x3FF) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public int readMemory(int address) {
        if (address >= 32768) {
            if (address >= 49152) {
                return this.prgROM[(this.prgBanks[3] | address & 0x3FFF) & this.prgRomSizeMask];
            }
            if (this.internalRomEnabled || !this.licensingEnabled || this.licensingTimer > 0) {
                return this.prgROM[(this.prgBanks[2] | address & 0x3FFF) & this.prgRomSizeMask];
            }
            return 0;
        }
        if (address >= 24576) {
            return this.wramEnabled ? this.memory[address] : 0;
        }
        return this.memory[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 24576) {
            switch (address & 0xF000) {
                case 24576: 
                case 28672: {
                    this.writeLicensingIC(address, value);
                    break;
                }
                case 32768: {
                    this.setChrBank(0, value);
                    break;
                }
                case 36864: {
                    this.setChrBank(1, value);
                    break;
                }
                case 40960: {
                    this.setChrBank(2, value);
                    break;
                }
                case 45056: {
                    this.setChrBank(3, value);
                    break;
                }
                case 49152: {
                    this.writeNametableBank(0, value);
                    break;
                }
                case 53248: {
                    this.writeNametableBank(1, value);
                    break;
                }
                case 57344: {
                    this.writeNametableMirroring(value);
                    break;
                }
                case 61440: {
                    this.writePrgBank(value);
                }
            }
        } else {
            this.memory[address] = value;
        }
    }

    private void writeNametableMirroring(int value) {
        this.setNametableMirroring(value & 3);
        this.chrRomNametablesEnabled = BitUtil.getBitBool(value, 4);
    }

    private void writePrgBank(int value) {
        this.setPrgBank(2, value & 7);
        this.internalRomEnabled = BitUtil.getBitBool(value, 3);
        this.wramEnabled = BitUtil.getBitBool(value, 4);
    }

    private void writeNametableBank(int bank, int value) {
        this.nametableBanks[bank] = (0x80 | value) << 10;
    }

    private void writeLicensingIC(int address, int value) {
        if (this.wramEnabled) {
            this.memory[address] = value;
        } else {
            this.licensingTimer = 107520;
            this.licensingEnabled = true;
        }
    }

    @Override
    public void update() {
        if (this.licensingTimer > 0) {
            --this.licensingTimer;
        }
    }
}

