/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.taito;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;

public class X1017
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final boolean[] ramEnabled = new boolean[3];
    private int chrMode;

    public X1017(NesFile nesFile) {
        super(nesFile, 8, 8);
        this.setPrgBank(7, -1);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.chrROM[this.chrBanks[address >> 10 ^ this.chrMode] | address & 0x3FF];
        }
        return this.vram[address];
    }

    @Override
    public int readMemory(int address) {
        if (address >= 32768) {
            return this.prgROM[(this.prgBanks[address >> 13] | address & 0x1FFF) & this.prgRomSizeMask];
        }
        if (address >= 24576 && address < 29696) {
            if (address < 26624) {
                return this.ramEnabled[0] ? this.memory[address] : 0;
            }
            if (address < 28672) {
                return this.ramEnabled[1] ? this.memory[address] : 0;
            }
            return this.ramEnabled[2] ? this.memory[address] : 0;
        }
        return this.memory[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 24576 && address < 29696) {
            if (address < 26624) {
                if (this.ramEnabled[0]) {
                    this.memory[address] = value;
                }
            } else if (address < 28672) {
                if (this.ramEnabled[1]) {
                    this.memory[address] = value;
                }
            } else if (this.ramEnabled[2]) {
                this.memory[address] = value;
            }
        } else {
            switch (address) {
                case 32496: {
                    this.writeChrBank(0, value);
                    break;
                }
                case 32497: {
                    this.writeChrBank(2, value);
                    break;
                }
                case 32498: {
                    this.writeChrBank(4, value);
                    break;
                }
                case 32499: {
                    this.writeChrBank(5, value);
                    break;
                }
                case 32500: {
                    this.writeChrBank(6, value);
                    break;
                }
                case 32501: {
                    this.writeChrBank(7, value);
                    break;
                }
                case 32502: {
                    this.writeChrMode(value);
                    break;
                }
                case 32503: {
                    this.ramEnabled[0] = value == 202;
                    break;
                }
                case 32504: {
                    this.ramEnabled[1] = value == 105;
                    break;
                }
                case 32505: {
                    this.ramEnabled[2] = value == 132;
                    break;
                }
                case 32506: {
                    this.writePrgBank(4, value);
                    break;
                }
                case 32507: {
                    this.writePrgBank(5, value);
                    break;
                }
                case 32508: {
                    this.writePrgBank(6, value);
                    break;
                }
                default: {
                    this.memory[address] = value;
                }
            }
        }
    }

    private void writePrgBank(int bank, int value) {
        this.prgBanks[bank] = (value & 0xFC) << 11;
    }

    private void writeChrMode(int value) {
        this.setNametableMirroring(value & 1 ^ 1);
        this.chrMode = (value & 2) << 1;
    }

    private void writeChrBank(int bank, int value) {
        if (bank < 4) {
            this.setChrBank(bank, value);
            this.setChrBank(bank + 1, value + 1);
        } else {
            this.setChrBank(bank, value);
        }
    }
}

