/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class BMC830118C
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int reg;

    public BMC830118C(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.reg = 0;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public void setChrBank(int bank, int value) {
        super.setChrBank(bank, (this.reg & 0xC) << 5 | value & 0x7F);
    }

    @Override
    public void setPrgBank(int bank, int value) {
        if ((this.reg & 0xC) == 12) {
            if (bank == 4) {
                super.setPrgBank(4, (this.reg & 0xC) << 2 | value & 0xF);
                super.setPrgBank(6, 0x32 | value & 0xF);
            } else if (bank == 5) {
                super.setPrgBank(5, (this.reg & 0xC) << 2 | value & 0xF);
                super.setPrgBank(7, 0x32 | value & 0xF);
            }
        } else {
            super.setPrgBank(bank, (this.reg & 0xC) << 2 | value & 0xF);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xFF00) == 26624) {
            this.reg = value;
            this.updateBanks();
        }
        super.writeMemory(address, value);
    }
}

