/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMCCTC09
extends Mapper {
    private static final long serialVersionUID = 0L;

    public BMCCTC09(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.writeChrRom(0);
        this.writePrgRomAndMirroring(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void writeChrRom(int value) {
        this.setChrBank(value & 0xF);
    }

    private void writePrgRomAndMirroring(int value) {
        int v = (value & 7) << 1;
        if (BitUtil.getBitBool(value, 4)) {
            this.setPrgBank(2, v |= value >> 3 & 1);
            this.setPrgBank(3, v);
        } else {
            this.set2PrgBanks(2, v);
        }
        this.setNametableMirroring(BitUtil.getBit(value, 5));
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 49152) {
            this.writeChrRom(value);
        } else {
            this.writePrgRomAndMirroring(value);
        }
    }
}

