/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class BMCK3033
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int outerBank;
    private int innerBank;
    private boolean nromMode;

    public BMCK3033(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBank(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void updatePrgBanks() {
        if (this.nromMode) {
            if ((this.innerBank & 3) != 0) {
                this.set4PrgBanks(4, ((this.outerBank << 3 | this.innerBank) & 0xFE) << 1);
            } else {
                this.set2PrgBanks(4, this.outerBank << 3 | this.innerBank);
                this.set2PrgBanks(6, this.outerBank << 3 | this.innerBank);
            }
        } else {
            super.updatePrgBanks();
        }
    }

    private void writeOuterBank(int address) {
        this.outerBank = (address & 0x40) >> 4 | (address & 0x18) >> 3;
        this.innerBank = address & 7;
        boolean bl = this.nromMode = !BitUtil.getBitBool(address, 5);
        if (this.nromMode) {
            this.setPrgBlock(0, -1);
            this.setChrBlock(0, 127);
        } else if (BitUtil.getBitBool(address, 7)) {
            this.setPrgBlock(this.outerBank << 5, 31);
            this.setChrBlock(this.outerBank << 8, 255);
        } else {
            this.setPrgBlock(this.outerBank << 4, 15);
            this.setChrBlock(this.outerBank << 7, 127);
        }
        this.updateBanks();
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.writeOuterBank(address);
        }
        super.writeMemory(address, value);
    }
}

