/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class COOLBOY
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];
    private final int xramMask;
    private boolean registerWritesEnabled = true;
    private boolean weirdMode;

    public COOLBOY(CartFile cartFile) {
        super(cartFile);
        this.xram = new int[262144];
        this.xramMask = this.xram.length - 1;
    }

    @Override
    public void init() {
        this.sync();
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.xram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.xramMask];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            this.xram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.xramMask] = value;
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if (this.registerWritesEnabled && (0xE000 & address) == 24576) {
            this.regs[address & 3] = value;
            this.sync();
        }
        super.writeMemory(address, value);
    }

    @Override
    protected void updatePrgBanks() {
        if (!this.prgMode && this.weirdMode) {
            this.setPrgBank(4, this.R[6]);
            this.setPrgBank(5, this.R[7]);
            this.setPrgBank(6, 0);
            this.setPrgBank(7, 0);
        } else {
            super.updatePrgBanks();
        }
    }

    @Override
    protected void updateChrBanks() {
        if (this.weirdMode) {
            if (this.chrMode) {
                this.setChrBank(0, this.R[2]);
                this.setChrBank(1, this.R[3]);
                this.setChrBank(2, this.R[4]);
                this.setChrBank(3, this.R[5]);
                this.setChrBank(4, this.R[0]);
                this.setChrBank(5, 0);
                this.setChrBank(6, this.R[1]);
                this.setChrBank(7, 0);
            } else {
                this.setChrBank(0, this.R[0]);
                this.setChrBank(1, 0);
                this.setChrBank(2, this.R[1]);
                this.setChrBank(3, 0);
                this.setChrBank(4, this.R[2]);
                this.setChrBank(5, this.R[3]);
                this.setChrBank(6, this.R[4]);
                this.setChrBank(7, this.R[5]);
            }
        } else {
            super.updateChrBanks();
        }
    }

    private void sync() {
        this.weirdMode = BitUtil.getBitBool(this.regs[3], 6);
        int CCKKJEEE = (this.regs[0] & 0x30 | this.regs[1] & 0xC) << 2 | (this.regs[1] & 0x10) >> 1 | this.regs[0] & 7;
        if (BitUtil.getBitBool(this.regs[3], 4)) {
            int CCKKJEEEQQR = CCKKJEEE << 3 | (this.regs[3] & 0xE) >> 1;
            if (BitUtil.getBitBool(this.regs[1], 1)) {
                this.prgBlockOffset = (CCKKJEEEQQR & 0xFFFFFFFE) << 1;
                this.prgBlockMask = 3;
            } else {
                this.prgBlockOffset = CCKKJEEEQQR << 1;
                this.prgBlockMask = 1;
            }
            if (BitUtil.getBitBool(this.regs[0], 7)) {
                this.chrBlockOffset = BitUtil.moveBit(this.regs[0], 3, 7) | (this.regs[2] & 0xF) << 3;
                this.chrBlockMask = 7;
            } else {
                this.chrBlockOffset = (this.regs[2] & 0xF) << 3;
                this.chrBlockMask = 135;
            }
            this.registerWritesEnabled = true;
        } else {
            int IHGB = BitUtil.moveBit(this.regs[1], 5, 3) | BitUtil.moveBit(this.regs[1], 6, 2) | BitUtil.moveBit(this.regs[1], 7, 1, true) | BitUtil.moveBit(this.regs[0], 6, 0, true);
            this.prgBlockOffset = (CCKKJEEE & ~IHGB) << 4;
            this.prgBlockMask = IHGB << 4 | 0xF;
            if (BitUtil.getBitBool(this.regs[0], 7)) {
                this.chrBlockOffset = BitUtil.moveBit(this.regs[0], 3, 7);
                this.chrBlockMask = 127;
            } else {
                this.chrBlockOffset = 0;
                this.chrBlockMask = 255;
            }
            this.registerWritesEnabled = !BitUtil.getBitBool(this.regs[3], 7);
        }
        this.updateBanks();
    }
}

