/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class EH8813A
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean locked;
    private boolean dipMode;
    private int chr;
    private int dip;

    public EH8813A(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.locked = false;
        this.chr = 0;
        super.init();
    }

    @Override
    public void resetting() {
        this.dip = this.dip + 1 & 0xF;
        this.init();
    }

    @Override
    public int readMemory(int address) {
        if (this.dipMode && (address & 0x8040) == 32832) {
            address = address & 0xFFF0 | this.dip;
        } else if ((address & 0xF000) == 20480) {
            if ((address & 0x800) == 0) {
                return 255;
            }
            address &= 0xF003;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF000) == 20480) {
            address &= 0xF003;
            value &= 0xF;
        }
        super.writeMemory(address, value);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (!this.locked) {
            this.locked = BitUtil.getBitBool(address, 8);
            this.dipMode = BitUtil.getBitBool(address, 6);
            if (BitUtil.getBitBool(address, 7)) {
                this.setPrgBank(2, address & 0x3F);
                this.setPrgBank(3, address & 0x3F);
            } else {
                this.set2PrgBanks(2, address & 0x3E);
            }
            this.setNametableMirroring(BitUtil.getBit(value, 7));
            this.chr = value & 0x7C;
        }
        this.setChrBank(this.chr | value & 3);
    }
}

