/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class FARID_UNROM_8IN1
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean clock;
    private boolean latch;
    private int prgInner;
    private int prgOuter;

    public FARID_UNROM_8IN1(CartFile cartFile) {
        super(cartFile, 4, 0);
    }

    @Override
    public void init() {
        this.prgOuter = 0;
        this.prgInner = 0;
        this.latch = false;
        this.clock = false;
        this.updatePrgBanks();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.prgInner = value & 7;
        boolean nextClock = BitUtil.getBitBool(value, 7);
        boolean nextLatch = BitUtil.getBitBool(value, 3);
        if (nextClock && !this.clock && !this.latch) {
            this.latch = nextLatch;
            this.prgOuter = (value >> 4 & 7) << 3;
        }
        this.clock = nextClock;
        this.updatePrgBanks();
    }

    private void updatePrgBanks() {
        this.setPrgBank(2, this.prgOuter | this.prgInner);
        this.setPrgBank(3, this.prgOuter | 7);
    }
}

