/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl.dripgame;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.unif.unl.dripgame.DripGameAudio;
import nintaco.util.BitUtil;

public class DripGame
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] attributeBits = new int[]{0, 85, 170, 255};
    private final DripGameAudio audio = new DripGameAudio();
    private int lastNametableAddress;
    private boolean sramWritesEnabled;
    private boolean extendedAttributesEnabled;
    private int irqLow;
    private int irqCounter;
    private boolean irqEnabled;

    public DripGame(CartFile cartFile) {
        super(cartFile, 4, 4);
        this.setPrgBank(3, -1);
        this.xram = new int[2048];
    }

    @Override
    public int readVRAM(int address) {
        if (address >= 8192 && address < 16128) {
            if ((address & 0x3C0) == 960) {
                if (this.extendedAttributesEnabled) {
                    return this.xram[this.lastNametableAddress & 0x7FF];
                }
            } else {
                this.lastNametableAddress = address;
            }
        }
        return super.readVRAM(address);
    }

    @Override
    public int readMemory(int address) {
        switch (address & 0xF800) {
            case 18432: {
                return 100;
            }
            case 20480: {
                return this.audio.getStatus(0);
            }
            case 22528: {
                return this.audio.getStatus(1);
            }
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) != 24576 || this.sramWritesEnabled) {
            super.writeMemory(address, value);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (!this.audio.writeRegister(address, value)) {
            if (address < 49152) {
                switch (address & 0xF) {
                    case 8: {
                        this.writeLowIrqCounter(value);
                        break;
                    }
                    case 9: {
                        this.writeHighIrqCounter(value);
                        break;
                    }
                    case 10: {
                        this.writeControl(value);
                        break;
                    }
                    case 11: {
                        this.setPrgBank(2, value & 0xF);
                        break;
                    }
                    case 12: {
                        this.setChrBank(0, value & 0xF);
                        break;
                    }
                    case 13: {
                        this.setChrBank(1, value & 0xF);
                        break;
                    }
                    case 14: {
                        this.setChrBank(2, value & 0xF);
                        break;
                    }
                    case 15: {
                        this.setChrBank(3, value & 0xF);
                    }
                }
            } else {
                this.writeExtendedAttributes(address, value);
            }
        }
    }

    private void writeLowIrqCounter(int value) {
        this.irqLow = value;
    }

    private void writeHighIrqCounter(int value) {
        this.irqCounter = (value & 0x7F) << 8 | this.irqLow;
        this.irqEnabled = BitUtil.getBitBool(value, 7);
        this.cpu.setMapperIrq(false);
    }

    private void writeControl(int value) {
        this.setNametableMirroring(value & 3);
        this.extendedAttributesEnabled = BitUtil.getBitBool(value, 2);
        this.sramWritesEnabled = BitUtil.getBitBool(value, 3);
    }

    private void writeExtendedAttributes(int address, int value) {
        this.xram[address & 0x7FF] = attributeBits[value & 3];
    }

    @Override
    public void update() {
        if (this.irqEnabled && this.irqCounter > 0 && --this.irqCounter == 0) {
            this.cpu.setMapperIrq(true);
        }
        this.audio.update();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }
}

