/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl.dripgame;

import java.io.Serializable;
import java.util.Arrays;

public class DripGameAudioChannel
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int[] buffer = new int[256];
    private int head;
    private int tail;
    private int period;
    private int volume;
    private int counter;
    private int size;
    private int sample = 128;

    public void reset() {
        this.head = 0;
        this.tail = 0;
        this.period = 0;
        this.volume = 0;
        this.counter = 0;
        this.size = 0;
        this.sample = 128;
        Arrays.fill(this.buffer, 0);
    }

    public int getStatus() {
        switch (this.size) {
            case 0: {
                return 64;
            }
            case 256: {
                return 128;
            }
        }
        return 0;
    }

    public int getSample() {
        return this.sample;
    }

    public void silence() {
        this.tail = 0;
        this.head = 0;
        this.size = 0;
    }

    public void enqueue(int value) {
        if (this.size < 256) {
            this.buffer[this.head] = value;
            this.head = this.head + 1 & 0xFF;
            ++this.size;
        }
    }

    public void setLowPeriod(int value) {
        this.period = this.period & 0xF00 | value;
    }

    public void setHighPeriod(int value) {
        this.period = (value & 0xF) << 8 | this.period & 0xFF;
        this.volume = value >> 4;
    }

    public void update() {
        if (this.counter > 0) {
            --this.counter;
        } else if (this.size > 0) {
            this.counter = this.period;
            this.sample = this.buffer[this.tail] * this.volume;
            this.tail = this.tail + 1 & 0xFF;
            --this.size;
        } else {
            this.sample = 128;
        }
    }
}

