/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper015
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Mapper015(CartFile cartFile) {
        super(cartFile, 8, 0);
    }

    @Override
    public void init() {
        this.setPrgBanks(4, 4, -4);
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.setNametableMirroring(BitUtil.getBit(value, 6));
        int high = (value & 0x7F) << 1;
        int low = value >> 7;
        switch (address & 0x8FFF) {
            case 32768: {
                for (int i = 3; i >= 0; --i) {
                    this.setPrgBank(4 | i, high + i ^ low);
                }
                break;
            }
            case 32769: 
            case 32771: {
                for (int i = 3; i >= 0; --i) {
                    int b = value & 0x7F;
                    if (i >= 2 && !BitUtil.getBitBool(address, 1)) {
                        b = 127;
                    }
                    this.setPrgBank(4 | i, (i & 1) + (b << 1 ^ low));
                }
                break;
            }
            case 32770: {
                int bank = high | low;
                for (int i = 3; i >= 0; --i) {
                    this.setPrgBank(4 | i, bank);
                }
                break;
            }
        }
    }
}

