/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper245
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int chrModeMask;

    public Mapper245(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public int readVRAM(int address) {
        if (this.chrRamPresent && address < 8192) {
            return this.vram[address ^ this.chrModeMask];
        }
        return super.readVRAM(address);
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (this.chrRamPresent && address < 8192) {
            this.vram[address ^ this.chrModeMask] = value;
        } else {
            super.writeVRAM(address, value);
        }
    }

    @Override
    protected void writeBankSelect(int value) {
        super.writeBankSelect(value);
        this.chrModeMask = this.chrMode ? 4096 : 0;
    }

    @Override
    protected void writeBankData(int value) {
        if (this.register == 0) {
            this.setPrgBlock((value & 2) << 5, 63);
        }
        super.writeBankData(value);
    }
}

