/*
 * Decompiled with CFR 0.152.
 */
package nintaco.movie;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.gui.historyeditor.HistoryEditorFrame;
import nintaco.gui.rob.RobController;
import nintaco.input.OtherInput;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.MovieBlock;
import nintaco.movie.MovieFrame;
import nintaco.netplay.protocol.ControllerInput;
import nintaco.util.BitUtil;
import nintaco.util.StreamUtil;

public class Movie
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int BLOCK_SIZE = 64;
    public static final int BLOCK_MASK = 63;
    public static final int BLOCK_SHIFT = BitUtil.log2(64);
    public static final int DOUBLE_SIZE = 128;
    public static final int DOUBLE_MASK = 127;
    public static final int DOUBLE_SHIFT = BitUtil.log2(128);
    public final List<MovieBlock> movieBlocks = new ArrayList<MovieBlock>();
    public final boolean vsDualSystem;
    public int frameIndex = -1;
    public int frameCount = 0;
    public transient MovieFrame[] movieFrames;
    private volatile transient HistoryEditorFrame historyEditorFrame;

    public Movie(boolean vsDualSystem) {
        this.vsDualSystem = vsDualSystem;
        this.initMovieFrames();
    }

    private void initMovieFrames() {
        this.movieFrames = new MovieFrame[128];
        for (int i = this.movieFrames.length - 1; i >= 0; --i) {
            this.movieFrames[i] = new MovieFrame(this.vsDualSystem);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initMovieFrames();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public void clear() {
        this.clear(null);
    }

    public void clear(byte[] saveState) {
        this.clearCachedFrames();
        this.frameIndex = -1;
        this.frameCount = 0;
        this.movieBlocks.clear();
        if (saveState != null) {
            MovieBlock block = new MovieBlock();
            block.saveState = saveState;
            this.movieBlocks.add(block);
        }
    }

    public void clearCachedFrames() {
        for (int i = this.movieFrames.length - 1; i >= 0; --i) {
            this.movieFrames[i].frameIndex = -1;
        }
    }

    public void truncate() {
        this.frameCount = this.frameIndex + 1;
        int blockIndex = this.frameIndex >> BLOCK_SHIFT;
        if (blockIndex < this.movieBlocks.size()) {
            MovieBlock movieBlock = this.movieBlocks.get(blockIndex);
            for (int i = (this.frameIndex & 0x3F) + 1; i < 64; ++i) {
                movieBlock.buttons[i] = 0;
            }
            if (this.movieBlocks.size() > blockIndex + 1) {
                this.movieBlocks.subList(blockIndex + 1, this.movieBlocks.size()).clear();
            }
        }
    }

    public void setHistoryEditorFrame(HistoryEditorFrame historyEditorFrame) {
        this.historyEditorFrame = historyEditorFrame;
    }

    public MovieFrame getCurrentMovieFrame() {
        return this.movieFrames[this.frameIndex & 0x7F];
    }

    public void updateMovieFrame(int[] screen, Machine machine) {
        HistoryEditorFrame frame;
        MovieFrame movieFrame = this.getCurrentMovieFrame();
        movieFrame.frameIndex = this.frameIndex;
        System.arraycopy(screen, 0, movieFrame.screen, 0, screen.length);
        if (machine != null) {
            PPU ppu = machine.getPPU();
            RobController rob = ppu.getRob();
            if (rob == null) {
                movieFrame.robState.game = 0;
            } else {
                movieFrame.robState.init(rob.getState());
            }
            if (machine.isVsDualSystem()) {
                PPU subPPU = ((MainCPU)machine.getCPU()).getSubPPU();
                System.arraycopy(subPPU.getScreen(), 0, movieFrame.screen2, 0, screen.length);
            }
        }
        if ((frame = this.historyEditorFrame) != null) {
            frame.movieUpdated(this.frameIndex);
        }
    }

    public void updateMovieBlock(Machine machine, ControllerInput controllerInput, boolean isNotClient) {
        ++this.frameIndex;
        this.getCurrentMovieFrame().audioLength = 0;
        if (isNotClient) {
            MovieBlock movieBlock = null;
            int blockIndex = this.frameIndex >> BLOCK_SHIFT;
            while (blockIndex >= this.movieBlocks.size()) {
                this.movieBlocks.add(new MovieBlock());
            }
            movieBlock = this.movieBlocks.get(blockIndex);
            int index = this.frameIndex & 0x3F;
            if (index == 0) {
                try {
                    movieBlock.saveState = StreamUtil.toByteArrayOutputStream(machine).toByteArray();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            movieBlock.buttons[index] = controllerInput.input;
            if (controllerInput.otherInputs != null) {
                if (movieBlock.otherInputs == null) {
                    movieBlock.otherInputs = new OtherInput[64][];
                }
                movieBlock.otherInputs[index] = controllerInput.otherInputs;
            }
            this.frameCount = (this.movieBlocks.size() - 1 << BLOCK_SHIFT | this.frameIndex & 0x3F) + 1;
        }
    }

    public boolean isVsDualSystem() {
        return this.vsDualSystem;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public List<MovieBlock> getMovieBlocks() {
        return this.movieBlocks;
    }

    public MovieFrame[] getMovieFrames() {
        return this.movieFrames;
    }
}

