/*
 * Decompiled with CFR 0.152.
 */
package nintaco.movie;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;

public final class MovieStates {
    private MovieStates() {
    }

    public static void save(String fileName, Movie movie, boolean compact) throws Throwable {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));){
            List<MovieBlock> blocks = movie.getMovieBlocks();
            out.writeBoolean(movie.isVsDualSystem());
            out.writeInt(movie.getFrameIndex());
            out.writeInt(movie.getFrameCount());
            out.writeInt(blocks.size());
            out.writeBoolean(compact);
            for (int i = 0; i < blocks.size(); ++i) {
                MovieBlock block = blocks.get(i);
                int[] buttons = block.buttons;
                if (i == 0 || !compact) {
                    byte[] saveState = block.saveState;
                    out.writeInt(saveState.length);
                    out.write(saveState);
                }
                for (int j = 0; j < 64; ++j) {
                    out.writeInt(buttons[j]);
                }
            }
        }
    }

    public static Movie load(String fileName) throws Throwable {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));){
            boolean vsDualSystem = in.readBoolean();
            Movie movie = new Movie(vsDualSystem);
            List<MovieBlock> blocks = movie.getMovieBlocks();
            movie.frameIndex = in.readInt();
            movie.frameCount = in.readInt();
            int blocksSize = in.readInt();
            boolean compact = in.readBoolean();
            for (int i = 0; i < blocksSize; ++i) {
                MovieBlock block = new MovieBlock();
                int[] buttons = block.buttons;
                blocks.add(block);
                if (i == 0 || !compact) {
                    block.saveState = new byte[in.readInt()];
                    in.readFully(block.saveState);
                }
                for (int j = 0; j < 64; ++j) {
                    buttons[j] = in.readInt();
                }
            }
            Movie movie2 = movie;
            return movie2;
        }
    }
}

