/*
 * Decompiled with CFR 0.152.
 */
package nintaco.palettes;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nintaco.App;
import nintaco.Machine;
import nintaco.api.local.LocalAPI;
import nintaco.gui.fonts.FontUtil;
import nintaco.gui.image.ImageFrame;
import nintaco.input.icons.InputIcons;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.Palettes;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.MathUtil;

public final class PaletteUtil {
    private static final double ATTENUATION_SCALE = 0.79399;
    private static final double ATTENUATION_OFFSET = 0.0782838;
    private static final int[] TINTS = new int[]{0, 6, 10, 8, 2, 4, 0, 0};
    private static final double[] LO_LEVELS = new double[]{-0.12, 0.0, 0.31, 0.72};
    private static final double[] HI_LEVELS = new double[]{0.4, 0.68, 1.0, 1.0};
    private static final double[] PHASES = new double[19];
    private static final int[][] EXTENDED_PALETTES;
    public static final boolean[] ZAPPER_COLORS;
    public static final boolean[] ROB_COLORS;
    private static final Set<String> standardPaletteNames;
    public static final Map<PalettePPU, String> defaultMapping;
    public static final Map<PalettePPU, boolean[]> zapperColors;
    public static final Map<PalettePPU, boolean[]> robColors;
    private static PalettePPU palettePPU;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws Throwable {
        Palettes prefs = AppPrefs.getInstance().getPalettes();
        Map<PalettePPU, String> map = defaultMapping;
        synchronized (map) {
            for (Map.Entry<PalettePPU, String> entry : defaultMapping.entrySet()) {
                prefs.ppuPaletteMapping.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        Map<String, int[]> pals = prefs.originalPalettes;
        PaletteUtil.loadPalette(pals, "2C03_2C05", "2C03/2C05");
        PaletteUtil.loadPalette(pals, "3DS_VC", "3DS VC");
        PaletteUtil.loadPalette(pals, "ASQ_Reality_C", "ASQ Reality C");
        PaletteUtil.loadPalette(pals, "AV_Famicom", "AV Famicom");
        PaletteUtil.loadPalette(pals, "BMF_Final_3", "BMF Final 3");
        PaletteUtil.loadPalette(pals, "Composite Direct (FBX)", "Composite Direct (FBX)");
        PaletteUtil.loadPalette(pals, "Consumer", "Consumer");
        PaletteUtil.loadPalette(pals, "Drag 3", "Drag 3");
        PaletteUtil.loadPalette(pals, "Dougeff", "Dougeff");
        PaletteUtil.loadPalette(pals, "FCEUX", "FCEUX");
        PaletteUtil.loadPalette(pals, "FCEUX-15", "FCEUX-15");
        PaletteUtil.loadPalette(pals, "Game_Boy", "Game Boy");
        PaletteUtil.loadPalette(pals, "Grayscale", "Grayscale");
        PaletteUtil.loadPalette(pals, "Kizul", "Kizul");
        PaletteUtil.loadPalette(pals, "NES Classic (FBX)", "NES Classic (FBX)");
        PaletteUtil.loadPalette(pals, "nesticle", "Nesticle");
        PaletteUtil.loadPalette(pals, "Nestopia_RGB", "Nestopia RGB");
        PaletteUtil.loadPalette(pals, "Nestopia_YUV", "Nestopia YUV");
        PaletteUtil.loadPalette(pals, "Nintendulator-NTSC", "Nintendulator NTSC");
        PaletteUtil.loadPalette(pals, "PVM Style D93 (FBX)", "PVM Style D93 (FBX)");
        PaletteUtil.loadPalette(pals, "Rinao", "Rinao");
        PaletteUtil.loadPalette(pals, "Rockman 9", "Rockman 9");
        PaletteUtil.loadPalette(pals, "RP2C04-0001", "RP2C04-0001");
        PaletteUtil.loadPalette(pals, "RP2C04-0002", "RP2C04-0002");
        PaletteUtil.loadPalette(pals, "RP2C04-0003", "RP2C04-0003");
        PaletteUtil.loadPalette(pals, "RP2C04-0004", "RP2C04-0004");
        PaletteUtil.loadPalette(pals, "Smooth (FBX)", "Smooth (FBX)");
        PaletteUtil.loadPalette(pals, "Sony CXA", "Sony CXA");
        PaletteUtil.loadPalette(pals, "terratec-cinergy", "Terratec Cinergy");
        PaletteUtil.loadPalette(pals, "Trebor", "Trebor");
        PaletteUtil.loadPalette(pals, "Wavebeam", "Wavebeam");
        PaletteUtil.loadPalette(pals, "Wii_VC", "Wii VC");
        PaletteUtil.setLightSensorColors(PalettePPU._2C02, pals.get("Smooth (FBX)"));
        PaletteUtil.setLightSensorColors(PalettePPU._2C03_2C05, pals.get("2C03/2C05"));
        PaletteUtil.setLightSensorColors(PalettePPU.RP2C04_0001, pals.get("RP2C04-0001"));
        PaletteUtil.setLightSensorColors(PalettePPU.RP2C04_0002, pals.get("RP2C04-0002"));
        PaletteUtil.setLightSensorColors(PalettePPU.RP2C04_0003, pals.get("RP2C04-0003"));
        PaletteUtil.setLightSensorColors(PalettePPU.RP2C04_0004, pals.get("RP2C04-0004"));
        PaletteUtil.setPalettePPU(PalettePPU._2C02);
    }

    public static int[] getExtendedPalette(Machine machine) {
        return PaletteUtil.getExtendedPalette(machine.getMapper().getTVSystem());
    }

    public static int[] getExtendedPalette(TVSystem tvSystem) {
        return EXTENDED_PALETTES[tvSystem == TVSystem.NTSC ? 0 : 1];
    }

    public static int[][] getExtendedPalettes() {
        return EXTENDED_PALETTES;
    }

    private static void loadPalette(Map<String, int[]> palettes, String fileName, String displayName) throws Throwable {
        standardPaletteNames.add(displayName);
        palettes.put(displayName, PaletteUtil.loadPaletteResource(fileName));
    }

    public static void savePalette(int[] palette, String fileName) throws Throwable {
        PaletteUtil.savePalette(palette, new FileOutputStream(fileName));
    }

    public static void savePalette(int[] palette, File file) throws Throwable {
        PaletteUtil.savePalette(palette, new FileOutputStream(file));
    }

    public static void savePalette(int[] palette, OutputStream out) throws Throwable {
        try (BufferedOutputStream bout = new BufferedOutputStream(out);){
            for (int i = 0; i < palette.length; ++i) {
                int p = palette[i];
                bout.write(p >> 16 & 0xFF);
                bout.write(p >> 8 & 0xFF);
                bout.write(p & 0xFF);
            }
        }
    }

    public static int[] loadPalette(String fileName) throws Throwable {
        return PaletteUtil.loadPalette(new FileInputStream(fileName));
    }

    public static int[] loadPalette(File file) throws Throwable {
        return PaletteUtil.loadPalette(new FileInputStream(file));
    }

    public static int[] loadPaletteResource(String fileName) throws Throwable {
        return PaletteUtil.loadPalette(Palettes.class.getResourceAsStream(String.format("/nintaco/palettes/%s.pal", fileName)));
    }

    private static void setLightSensorColors(PalettePPU palettePPU, int[] palette) {
        boolean[] zs = new boolean[palette.length];
        boolean[] rs = new boolean[palette.length];
        for (int i = palette.length - 1; i >= 0; --i) {
            int c = palette[i];
            int R = c >> 16 & 0xFF;
            int G = c >> 8 & 0xFF;
            int B = c & 0xFF;
            zs[i] = R + G + B > 255;
            rs[i] = G > 127;
        }
        zapperColors.put(palettePPU, zs);
        robColors.put(palettePPU, rs);
    }

    public static int[] loadPalette(InputStream in) throws Throwable {
        try (BufferedInputStream bin = new BufferedInputStream(in);){
            int[] palette = new int[64];
            for (int i = 0; i < palette.length; ++i) {
                int r = bin.read();
                int g = bin.read();
                int b = bin.read();
                palette[i] = r << 16 | g << 8 | b;
            }
            int[] nArray = palette;
            return nArray;
        }
    }

    public static boolean isStandardPaletteName(String name) {
        return standardPaletteNames.contains(name);
    }

    public static void getDefaultMapping(Map<PalettePPU, String> mapping) {
        mapping.clear();
        mapping.putAll(defaultMapping);
    }

    public static String getDefaultName() {
        return PaletteUtil.getDefaultName(PaletteUtil.getPalettePPU());
    }

    public static String getDefaultName(PalettePPU palettePPU) {
        return defaultMapping.get((Object)palettePPU);
    }

    public static synchronized PalettePPU getPalettePPU() {
        return palettePPU == null ? PalettePPU._2C02 : palettePPU;
    }

    public static synchronized boolean setPalettePPU(PalettePPU palettePPU) {
        if (PaletteUtil.palettePPU != palettePPU) {
            PaletteUtil.palettePPU = palettePPU;
            PaletteUtil.update();
            FontUtil.setPalettePPU(palettePPU);
            InputIcons.setPalettePPU(palettePPU);
            LocalAPI localAPI = LocalAPI.getLocalAPI();
            if (localAPI != null) {
                localAPI.setPalettePPU(palettePPU);
            }
            return true;
        }
        return false;
    }

    public static boolean usePlayChoice10PPU() {
        return PaletteUtil.setPalettePPU(PalettePPU._2C03_2C05);
    }

    public static boolean setVsPPU(int vsPPU) {
        switch (vsPPU) {
            case 2: {
                return PaletteUtil.setPalettePPU(PalettePPU.RP2C04_0001);
            }
            case 3: {
                return PaletteUtil.setPalettePPU(PalettePPU.RP2C04_0002);
            }
            case 4: {
                return PaletteUtil.setPalettePPU(PalettePPU.RP2C04_0003);
            }
            case 5: {
                return PaletteUtil.setPalettePPU(PalettePPU.RP2C04_0004);
            }
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return PaletteUtil.setPalettePPU(PalettePPU._2C03_2C05);
            }
        }
        return PaletteUtil.setPalettePPU(PalettePPU._2C02);
    }

    public static synchronized void update() {
        int[] palette = new int[64];
        AppPrefs.getInstance().getPalettes().getPalette(palettePPU, palette);
        PaletteUtil.extendPalette(palette, EXTENDED_PALETTES);
        System.arraycopy(zapperColors.get((Object)palettePPU), 0, ZAPPER_COLORS, 0, ZAPPER_COLORS.length);
        System.arraycopy(robColors.get((Object)palettePPU), 0, ROB_COLORS, 0, ROB_COLORS.length);
        ImageFrame imageFrame = App.getImageFrame();
        if (imageFrame != null) {
            imageFrame.getImagePane().setExtendedPalettes(EXTENDED_PALETTES);
        }
    }

    public static void applyPalette(int[] source, TVSystem tvSystem) {
        PaletteUtil.applyPalette(source, source, EXTENDED_PALETTES[tvSystem == TVSystem.NTSC ? 0 : 1]);
    }

    public static void applyPalette(int[] source, int[] palette) {
        PaletteUtil.applyPalette(source, source, palette);
    }

    public static void applyPalette(int[] source, int[] destination, int[] palette) {
        for (int i = destination.length - 1; i >= 0; --i) {
            destination[i] = palette[source[i]];
        }
    }

    private static double toSinAngle(int color) {
        return PHASES[color];
    }

    private static double toCosAngle(int color) {
        return PHASES[color + 3];
    }

    public static void extendPalette(int[] palette, int[][] extendedPalettes) {
        PaletteUtil.extendPalette(palette, extendedPalettes[0], TVSystem.NTSC);
        PaletteUtil.extendPalette(palette, extendedPalettes[1], TVSystem.PAL);
    }

    public static void extendPalette(int[] palette, int[] extended, TVSystem tvSystem) {
        boolean ntsc = tvSystem == TVSystem.NTSC;
        for (int i = 7; i >= 0; --i) {
            int offset = i << 6;
            int emphasis = ntsc ? i : i & 4 | (i & 1) << 1 | i >> 1 & 1;
            for (int j = 63; j >= 0; --j) {
                int color = j & 0xF;
                int RGB = palette[j];
                int R = RGB >> 16 & 0xFF;
                int G = RGB >> 8 & 0xFF;
                int B = RGB & 0xFF;
                if (i > 0 && color <= 13) {
                    double r = (double)R / 255.0;
                    double g = (double)G / 255.0;
                    double b = (double)B / 255.0;
                    double Y = 0.299 * r + 0.587 * g + 0.144 * b;
                    double I = 0.596 * r - 0.274 * g - 0.322 * b;
                    double Q = 0.211 * r - 0.523 * g + 0.312 * b;
                    int level = j >> 4 & 3;
                    double lo = LO_LEVELS[level];
                    double hi = HI_LEVELS[level];
                    if (color == 0) {
                        lo = hi;
                    } else if (color == 13) {
                        hi = lo;
                    }
                    if (emphasis == 7) {
                        Y = 1.13 * (Y * 0.79399 - 0.0782838);
                    } else {
                        int tintColor = TINTS[emphasis];
                        double saturation = (hi * 0.20601000000000003 + 0.0782838) / 2.0;
                        Y -= saturation / 2.0;
                        if (emphasis >= 3 && emphasis != 4) {
                            Y -= (saturation *= (double)0.6f);
                        }
                        I += PaletteUtil.toSinAngle(tintColor) * saturation;
                        Q += PaletteUtil.toCosAngle(tintColor) * saturation;
                    }
                    r = Y + 0.956 * I + 0.621 * Q;
                    g = Y - 0.272 * I - 0.647 * Q;
                    b = Y - 1.106 * I + 1.703 * Q;
                    R = (int)(255.0 * MathUtil.clamp(r, 0.0, 1.0));
                    G = (int)(255.0 * MathUtil.clamp(g, 0.0, 1.0));
                    B = (int)(255.0 * MathUtil.clamp(b, 0.0, 1.0));
                }
                extended[offset | j] = R << 16 | G << 8 | B;
            }
        }
    }

    private PaletteUtil() {
    }

    static {
        for (int i = PHASES.length - 1; i >= 0; --i) {
            PaletteUtil.PHASES[i] = -Math.cos((double)i * Math.PI / 6.0);
        }
        EXTENDED_PALETTES = new int[2][512];
        ZAPPER_COLORS = new boolean[64];
        ROB_COLORS = new boolean[64];
        standardPaletteNames = Collections.synchronizedSet(new HashSet());
        defaultMapping = Collections.synchronizedMap(new HashMap());
        zapperColors = Collections.synchronizedMap(new HashMap());
        robColors = Collections.synchronizedMap(new HashMap());
        defaultMapping.put(PalettePPU._2C02, "Smooth (FBX)");
        defaultMapping.put(PalettePPU._2C03_2C05, "2C03/2C05");
        defaultMapping.put(PalettePPU.RP2C04_0001, "RP2C04-0001");
        defaultMapping.put(PalettePPU.RP2C04_0002, "RP2C04-0002");
        defaultMapping.put(PalettePPU.RP2C04_0003, "RP2C04-0003");
        defaultMapping.put(PalettePPU.RP2C04_0004, "RP2C04-0004");
    }
}

