/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

public final class MathUtil {
    public static final Integer ZERO = 0;
    private static final int[] digitsTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    private MathUtil() {
    }

    public static final int getDigits(int value) {
        int i = 0;
        while (value > digitsTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static final int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final int roundUp(int value, int unit) {
        if (value % unit == 0) {
            return value;
        }
        return (value / unit + 1) * unit;
    }

    public static final double deviation(double idealValue, double measuredValue) {
        return Math.abs(idealValue - measuredValue) / idealValue;
    }

    public static final boolean isOdd(long value) {
        return (value & 1L) == 1L;
    }

    public static final boolean isEven(long value) {
        return (value & 1L) == 0L;
    }

    public static final boolean isOdd(int value) {
        return (value & 1) == 1;
    }

    public static final boolean isEven(int value) {
        return (value & 1) == 0;
    }

    public static final int roundUpDivision(int m, int n) {
        return (m + n - 1) / n;
    }

    public static final int hash(byte[] data) {
        return MathUtil.hash(data, 0, data.length);
    }

    public static final int hash(byte[] data, int offset, int length) {
        int hash = length;
        for (int i = length - 1; i >= 0; --i) {
            hash += data[i + offset] & 0xFF;
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static final int hash(byte[][] data, int x, int y, int width, int height) {
        int hash = width * height;
        for (int i = height - 1; i >= 0; --i) {
            byte[] row = data[i + y];
            for (int j = width - 1; j >= 0; --j) {
                hash += row[j + x] & 0xFF;
                hash += hash << 10;
                hash ^= hash >> 6;
            }
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }
}

