/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public final class ThreadUtil {
    private ThreadUtil() {
    }

    public static void threadJoin(Thread thread) {
        try {
            if (thread != Thread.currentThread()) {
                thread.join();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void threadWait(Object obj) {
        try {
            obj.wait();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void threadWait(Object obj, long timeout) {
        if (timeout > 0L) {
            try {
                obj.wait(timeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void pause() {
        ThreadUtil.sleep(1000L);
    }

    public static void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Object createWorkerProxy(Object target) {
        return Proxy.newProxyInstance(ThreadUtil.class.getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)new WorkerHandler(target));
    }

    public static Object createSwingProxy(Object target) {
        return Proxy.newProxyInstance(ThreadUtil.class.getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)new SwingHandler(target));
    }

    public static void interrupt(Thread thread) {
        if (thread != null) {
            try {
                thread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void interruptAll(Thread ... threads) {
        for (Thread thread : threads) {
            ThreadUtil.interrupt(thread);
        }
    }

    public static void join(Thread thread) {
        if (thread != null && !Thread.currentThread().equals(thread)) {
            try {
                thread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void joinAll(Thread ... threads) {
        for (Thread thread : threads) {
            ThreadUtil.join(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void joinAll(List<Thread> threads) {
        ArrayList<Thread> ts;
        List<Thread> list = threads;
        synchronized (list) {
            ts = new ArrayList<Thread>(threads);
        }
        for (Thread thread : ts) {
            ThreadUtil.join(thread);
        }
    }

    public static void forceHighResolutionTime() {
        new Thread(){
            {
                this.setDaemon(true);
                this.start();
            }

            @Override
            public void run() {
                while (true) {
                    ThreadUtil.sleep(Integer.MAX_VALUE);
                }
            }
        };
    }

    private static class SwingHandler
    implements InvocationHandler {
        private final Class targetClass;
        private final Object target;

        public SwingHandler(Object target) {
            this.target = target;
            this.targetClass = target.getClass();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            TargetInvoker targetInvoker = new TargetInvoker(this.target, this.targetClass.getMethod(method.getName(), method.getParameterTypes()), args);
            if (method.getReturnType() != Void.TYPE) {
                EventQueue.invokeAndWait(targetInvoker);
                if (targetInvoker.threwException()) {
                    throw targetInvoker.getException();
                }
                return targetInvoker.getReturnValue();
            }
            EventQueue.invokeLater(targetInvoker);
            return null;
        }
    }

    private static class WorkerHandler
    implements InvocationHandler {
        private final Class targetClass;
        private final Object target;

        public WorkerHandler(Object target) {
            this.target = target;
            this.targetClass = target.getClass();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            new Thread(new TargetInvoker(this.target, this.targetClass.getMethod(method.getName(), method.getParameterTypes()), args)).start();
            return null;
        }
    }

    private static class TargetInvoker
    implements Runnable {
        private final Object target;
        private final Method method;
        private final Object[] arguments;
        private Object returnValue;
        private Throwable exception;

        public TargetInvoker(Object target, Method method, Object[] arguments) {
            this.target = target;
            this.method = method;
            this.arguments = arguments;
        }

        public boolean threwException() {
            return this.exception != null;
        }

        public Throwable getException() {
            return this.exception;
        }

        public Object getReturnValue() {
            return this.returnValue;
        }

        @Override
        public void run() {
            try {
                this.returnValue = this.method.invoke(this.target, this.arguments);
            }
            catch (Throwable t) {
                this.exception = t;
            }
        }
    }
}

