/*
 * Decompiled with CFR 0.152.
 */
package nintaco;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nintaco.App;
import nintaco.Breakpoint;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.ServicedType;
import nintaco.api.local.AccessPoint;
import nintaco.apu.APU;
import nintaco.apu.DeltaModulationChannel;
import nintaco.cheats.Cheat;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;
import nintaco.util.CollectionsUtil;

public class CPU
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int REG_OAM_DMA = 16404;
    public static final int REG_OUTPUT_PORT = 16406;
    public static final int REG_INPUT_PORT_1 = 16406;
    public static final int REG_INPUT_PORT_2 = 16407;
    private static final int IRQ_MAPPER = 0;
    private static final int IRQ_APU = 1;
    private static final int IRQ_DMC = 2;
    private int A;
    private int X;
    private int Y;
    private int S;
    private int PC;
    private int N;
    private int V;
    private int D;
    private int I;
    private int Z;
    private int C;
    private long cycleCounter;
    private int opcode;
    private boolean running = true;
    private boolean resetRequested;
    private boolean nmiRequested;
    private int irqRequested;
    private boolean triggerNMI;
    private boolean triggerIRQ;
    private ServicedType serviced;
    private volatile int instructionsCounter;
    private Mapper mapper;
    private PPU ppu;
    private APU apu;
    private DeltaModulationChannel dmc;
    private Cheat[] cheats;
    private int dmcCycle;
    private int dmcAddress;
    private volatile transient Breakpoint[] executeBreakpoints;
    private volatile transient Breakpoint[] readBreakpoints;
    private volatile transient Breakpoint[] writeBreakpoints;
    private volatile transient AccessPoint[] preReadAccessPoints;
    private volatile transient AccessPoint[] postReadAccessPoints;
    private volatile transient AccessPoint[] preWriteAccessPoints;
    private volatile transient AccessPoint[] postWriteAccessPoints;
    private volatile transient AccessPoint[] preExecuteAccessPoints;
    private volatile transient AccessPoint[] postExecuteAccessPoints;

    public void executeInstruction() {
        Breakpoint[] breakpoints;
        this.serviced = ServicedType.None;
        if (this.resetRequested) {
            this.resetRequested = false;
            this.running = true;
            this.apu.reset();
            this.ppu.reset();
            this.RESET();
        }
        AccessPoint[] preAccessPoints = this.preExecuteAccessPoints;
        int pc = this.PC;
        if (preAccessPoints != null) {
            for (int i = preAccessPoints.length - 1; i >= 0; --i) {
                AccessPoint accessPoint = preAccessPoints[i];
                if (accessPoint.minAddress > pc || pc > accessPoint.maxAddress || accessPoint.bank >= 0 && accessPoint.bank != this.mapper.getPrgBank(pc)) continue;
                accessPoint.listener.accessPointHit(4, pc, -1);
            }
        }
        this.opcode = this.read(this.PC);
        this.incrementPC();
        switch (this.opcode) {
            case 0: {
                this.BRK();
                break;
            }
            case 64: {
                this.RTI();
                break;
            }
            case 96: {
                this.RTS();
                break;
            }
            case 8: 
            case 72: {
                this.PUSH();
                break;
            }
            case 40: 
            case 104: {
                this.PULL();
                break;
            }
            case 32: {
                this.JSR();
                break;
            }
            case 10: 
            case 24: 
            case 26: 
            case 42: 
            case 56: 
            case 58: 
            case 74: 
            case 88: 
            case 90: 
            case 106: 
            case 120: 
            case 122: 
            case 136: 
            case 138: 
            case 152: 
            case 154: 
            case 168: 
            case 170: 
            case 184: 
            case 186: 
            case 200: 
            case 202: 
            case 216: 
            case 218: 
            case 232: 
            case 234: 
            case 248: 
            case 250: {
                this.ACCUMULATOR_OR_IMPLIED();
                break;
            }
            case 9: 
            case 11: 
            case 41: 
            case 43: 
            case 73: 
            case 75: 
            case 105: 
            case 107: 
            case 128: 
            case 130: 
            case 137: 
            case 139: 
            case 160: 
            case 162: 
            case 169: 
            case 171: 
            case 192: 
            case 194: 
            case 201: 
            case 203: 
            case 224: 
            case 226: 
            case 233: 
            case 235: {
                this.IMMEDIATE();
                break;
            }
            case 76: {
                this.ABSOLUTE_JUMP();
                break;
            }
            case 12: 
            case 13: 
            case 44: 
            case 45: 
            case 77: 
            case 109: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 204: 
            case 205: 
            case 236: 
            case 237: {
                this.ABSOLUTE_READ();
                break;
            }
            case 14: 
            case 15: 
            case 46: 
            case 47: 
            case 78: 
            case 79: 
            case 110: 
            case 111: 
            case 206: 
            case 207: 
            case 238: 
            case 239: {
                this.ABSOLUTE_READ_MODIFY_WRITE();
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                this.ABSOLUTE_WRITE();
                break;
            }
            case 4: 
            case 5: 
            case 36: 
            case 37: 
            case 68: 
            case 69: 
            case 100: 
            case 101: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 196: 
            case 197: 
            case 228: 
            case 229: {
                this.ZERO_PAGE_READ();
                break;
            }
            case 6: 
            case 7: 
            case 38: 
            case 39: 
            case 70: 
            case 71: 
            case 102: 
            case 103: 
            case 198: 
            case 199: 
            case 230: 
            case 231: {
                this.ZERO_PAGE_READ_MODIFY_WRITE();
                break;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                this.ZERO_PAGE_WRITE();
                break;
            }
            case 20: 
            case 21: 
            case 52: 
            case 53: 
            case 84: 
            case 85: 
            case 116: 
            case 117: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 212: 
            case 213: 
            case 244: 
            case 245: {
                this.ZERO_PAGE_INDEXED_READ();
                break;
            }
            case 22: 
            case 23: 
            case 54: 
            case 55: 
            case 86: 
            case 87: 
            case 118: 
            case 119: 
            case 214: 
            case 215: 
            case 246: 
            case 247: {
                this.ZERO_PAGE_INDEXED_READ_MODIFY_WRITE();
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                this.ZERO_PAGE_INDEXED_WRITE();
                break;
            }
            case 25: 
            case 28: 
            case 29: 
            case 57: 
            case 60: 
            case 61: 
            case 89: 
            case 92: 
            case 93: 
            case 121: 
            case 124: 
            case 125: 
            case 185: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 217: 
            case 220: 
            case 221: 
            case 249: 
            case 252: 
            case 253: {
                this.ABSOLUTE_INDEXED_READ();
                break;
            }
            case 27: 
            case 30: 
            case 31: 
            case 59: 
            case 62: 
            case 63: 
            case 91: 
            case 94: 
            case 95: 
            case 123: 
            case 126: 
            case 127: 
            case 219: 
            case 222: 
            case 223: 
            case 251: 
            case 254: 
            case 255: {
                this.ABSOLUTE_INDEXED_READ_MODIFY_WRITE();
                break;
            }
            case 153: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                this.ABSOLUTE_INDEXED_WRITE();
                break;
            }
            case 16: 
            case 48: 
            case 80: 
            case 112: 
            case 144: 
            case 176: 
            case 208: 
            case 240: {
                this.RELATIVE_BRANCH();
                break;
            }
            case 1: 
            case 33: 
            case 65: 
            case 97: 
            case 161: 
            case 163: 
            case 193: 
            case 225: {
                this.INDEXED_INDIRECT_READ();
                break;
            }
            case 3: 
            case 35: 
            case 67: 
            case 99: 
            case 195: 
            case 227: {
                this.INDEXED_INDIRECT_READ_MODIFY_WRITE();
                break;
            }
            case 129: 
            case 131: {
                this.INDEXED_INDIRECT_WRITE();
                break;
            }
            case 17: 
            case 49: 
            case 81: 
            case 113: 
            case 177: 
            case 179: 
            case 209: 
            case 241: {
                this.INDIRECT_INDEXED_READ();
                break;
            }
            case 19: 
            case 51: 
            case 83: 
            case 115: 
            case 211: 
            case 243: {
                this.INDIRECT_INDEXED_READ_MODIFY_WRITE();
                break;
            }
            case 145: 
            case 147: {
                this.INDIRECT_INDEXED_WRITE();
                break;
            }
            case 108: {
                this.ABSOLUTE_INDIRECT_JUMP();
                break;
            }
            case 2: 
            case 18: 
            case 34: 
            case 50: 
            case 66: 
            case 82: 
            case 98: 
            case 114: 
            case 146: 
            case 178: 
            case 210: 
            case 242: {
                this.KIL();
            }
        }
        AccessPoint[] postAccessPoints = this.postExecuteAccessPoints;
        if (postAccessPoints != null) {
            for (int i = postAccessPoints.length - 1; i >= 0; --i) {
                AccessPoint accessPoint = postAccessPoints[i];
                if (accessPoint.minAddress > pc || pc > accessPoint.maxAddress || accessPoint.bank >= 0 && accessPoint.bank != this.mapper.getPrgBank(pc)) continue;
                accessPoint.listener.accessPointHit(5, pc, -1);
            }
        }
        if (this.running) {
            if (this.triggerNMI) {
                this.NMI();
                this.nmiRequested = false;
            } else if (this.triggerIRQ) {
                this.IRQ();
            }
        }
        if ((breakpoints = this.executeBreakpoints) != null) {
            for (int i = breakpoints.length - 1; i >= 0; --i) {
                Breakpoint breakpoint = breakpoints[i];
                if (breakpoint.startAddress != this.PC && (!breakpoint.range || breakpoint.startAddress > this.PC || this.PC > breakpoint.endAddress) || breakpoint.bank >= 0 && breakpoint.bank != this.mapper.getPrgBank(this.PC)) continue;
                breakpoint.hit = true;
            }
        }
        ++this.instructionsCounter;
    }

    public void init() {
        this.reset();
    }

    public void reset() {
        this.resetRequested = true;
    }

    public void setNMI(boolean value) {
        this.nmiRequested = value;
    }

    public void setMapperIrq(boolean value) {
        this.irqRequested = BitUtil.setBit(this.irqRequested, 0, value);
    }

    public boolean getMapperIrq() {
        return BitUtil.getBitBool(this.irqRequested, 0);
    }

    public void setApuIrq(boolean value) {
        this.irqRequested = BitUtil.setBit(this.irqRequested, 1, value);
    }

    public boolean getApuIrq() {
        return BitUtil.getBitBool(this.irqRequested, 1);
    }

    public void setDmcIrq(boolean value) {
        this.irqRequested = BitUtil.setBit(this.irqRequested, 2, value);
    }

    public boolean getDmcIrq() {
        return BitUtil.getBitBool(this.irqRequested, 2);
    }

    public void dmcRead(int address) {
        this.dmcAddress = address;
        this.dmcCycle = 4;
    }

    public int getInstructionsCounter() {
        return this.instructionsCounter;
    }

    public void oamTransfer(int value) {
        value <<= 8;
        if ((this.cycleCounter & 1L) == 0L) {
            this.read(this.PC);
        }
        this.read(this.PC);
        for (int i = 0; i < 256; ++i) {
            this.write(8196, this.read(value | i));
        }
    }

    public void setCheats(Cheat[] cheats) {
        this.cheats = cheats;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMachine(Machine machine) {
        this.mapper = machine.getMapper();
        this.ppu = machine.getPPU();
        this.apu = machine.getAPU();
        this.dmc = this.apu.getDMC();
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setPPU(PPU ppu) {
        this.ppu = ppu;
    }

    public void setAPU(APU apu) {
        this.apu = apu;
        this.dmc = apu.getDMC();
    }

    public long getCycleCounter() {
        return this.cycleCounter;
    }

    public boolean isTriggerNMI() {
        return this.triggerNMI;
    }

    public boolean isTriggerIRQ() {
        return this.triggerIRQ;
    }

    public boolean isTriggerInterrupt() {
        return this.triggerNMI || this.triggerIRQ;
    }

    public boolean isNmiRequested() {
        return this.nmiRequested;
    }

    public int getIrqRequested() {
        return this.irqRequested;
    }

    public ServicedType getServiced() {
        return this.serviced;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setBreakpoints(Breakpoint[] breakpoints) {
        ArrayList<Breakpoint> executes = new ArrayList<Breakpoint>();
        ArrayList<Breakpoint> reads = new ArrayList<Breakpoint>();
        ArrayList<Breakpoint> writes = new ArrayList<Breakpoint>();
        if (breakpoints != null) {
            block5: for (Breakpoint breakpoint : breakpoints) {
                if (!breakpoint.isEnabled()) continue;
                switch (breakpoint.getType()) {
                    case 0: {
                        executes.add(breakpoint);
                        continue block5;
                    }
                    case 1: {
                        reads.add(breakpoint);
                        continue block5;
                    }
                    case 2: {
                        writes.add(breakpoint);
                        continue block5;
                    }
                    default: {
                        executes.add(breakpoint);
                        reads.add(breakpoint);
                        writes.add(breakpoint);
                    }
                }
            }
        }
        this.executeBreakpoints = CollectionsUtil.convertToArray(Breakpoint.class, executes);
        this.readBreakpoints = CollectionsUtil.convertToArray(Breakpoint.class, reads);
        this.writeBreakpoints = CollectionsUtil.convertToArray(Breakpoint.class, writes);
    }

    public void setAccessPoints(AccessPoint[] accessPoints) {
        List[] as = new List[6];
        if (!CollectionsUtil.isBlank(accessPoints)) {
            for (int i = as.length - 1; i >= 0; --i) {
                as[i] = new ArrayList();
            }
            for (AccessPoint accessPoint : accessPoints) {
                if (accessPoint.getMinAddress() < 0 || accessPoint.getMinAddress() > 65535) continue;
                as[accessPoint.getType()].add(accessPoint);
            }
        }
        this.preReadAccessPoints = CollectionsUtil.convertToArray(AccessPoint.class, as[0]);
        this.postReadAccessPoints = CollectionsUtil.convertToArray(AccessPoint.class, as[1]);
        this.preWriteAccessPoints = CollectionsUtil.convertToArray(AccessPoint.class, as[2]);
        this.postWriteAccessPoints = CollectionsUtil.convertToArray(AccessPoint.class, as[3]);
        this.preExecuteAccessPoints = CollectionsUtil.convertToArray(AccessPoint.class, as[4]);
        this.postExecuteAccessPoints = CollectionsUtil.convertToArray(AccessPoint.class, as[5]);
    }

    public int getA() {
        return this.A;
    }

    public void setA(int A) {
        this.A = A & 0xFF;
    }

    public int getS() {
        return this.S;
    }

    public void setS(int S) {
        this.S = S & 0xFF;
    }

    public int getP() {
        return this.getFlags();
    }

    public void setP(int P) {
        this.setFlags(P);
    }

    public int getPC() {
        return this.PC;
    }

    public void setPC(int PC) {
        this.PC = PC & 0xFFFF;
    }

    public int getX() {
        return this.X;
    }

    public void setX(int X) {
        this.X = X & 0xFF;
    }

    public int getY() {
        return this.Y;
    }

    public void setY(int Y) {
        this.Y = Y & 0xFF;
    }

    public int getN() {
        return this.N;
    }

    public void setN(int N) {
        this.N = N & 1;
    }

    public int getV() {
        return this.V;
    }

    public void setV(int V) {
        this.V = V & 1;
    }

    public int getD() {
        return this.D;
    }

    public void setD(int D) {
        this.D = D & 1;
    }

    public int getI() {
        return this.I;
    }

    public void setI(int I) {
        this.I = I & 1;
    }

    public int getZ() {
        return this.Z;
    }

    public void setZ(int Z) {
        this.Z = Z & 1;
    }

    public int getC() {
        return this.C;
    }

    public void setC(int C) {
        this.C = C & 1;
    }

    private void handleCpuCycle() {
        this.triggerNMI = this.nmiRequested;
        this.triggerIRQ = this.irqRequested != 0 && this.I == 0;
        this.mapper.update();
        ++this.cycleCounter;
        this.apu.update((this.cycleCounter & 1L) == 1L);
        this.ppu.update();
    }

    private void setFlags(int value) {
        this.N = value >> 7 & 1;
        this.V = value >> 6 & 1;
        this.D = value >> 3 & 1;
        this.I = value >> 2 & 1;
        this.Z = value >> 1 & 1;
        this.C = value & 1;
    }

    private int getFlags() {
        return this.N << 7 | this.V << 6 | 0x20 | this.D << 3 | this.I << 2 | this.Z << 1 | this.C;
    }

    private int readStack() {
        return this.read(0x100 | this.S);
    }

    private void writeStack(int value) {
        this.write(0x100 | this.S, value);
    }

    private void decrementS() {
        --this.S;
        this.S &= 0xFF;
    }

    private void incrementS() {
        ++this.S;
        this.S &= 0xFF;
    }

    private void incrementPC() {
        ++this.PC;
        this.PC &= 0xFFFF;
    }

    private void write(int address, int value) {
        Breakpoint[] breakpoints;
        if (this.dmcCycle > 0) {
            --this.dmcCycle;
        }
        this.handleCpuCycle();
        AccessPoint[] preAccessPoints = this.preWriteAccessPoints;
        if (preAccessPoints != null) {
            for (int i = preAccessPoints.length - 1; i >= 0; --i) {
                int v;
                AccessPoint accessPoint = preAccessPoints[i];
                if (accessPoint.minAddress > address || address > accessPoint.maxAddress || accessPoint.bank >= 0 && accessPoint.bank != this.mapper.getPrgBank(address) || (v = accessPoint.listener.accessPointHit(2, address, value)) < 0) continue;
                value = v & 0xFF;
            }
        }
        this.mapper.writeCpuMemory(address, value);
        AccessPoint[] postAccessPoints = this.postWriteAccessPoints;
        if (postAccessPoints != null) {
            for (int i = postAccessPoints.length - 1; i >= 0; --i) {
                AccessPoint accessPoint = postAccessPoints[i];
                if (accessPoint.minAddress > address || address > accessPoint.maxAddress || accessPoint.bank >= 0 && accessPoint.bank != this.mapper.getPrgBank(address)) continue;
                accessPoint.listener.accessPointHit(3, address, value);
            }
        }
        if ((breakpoints = this.writeBreakpoints) != null) {
            for (int i = breakpoints.length - 1; i >= 0; --i) {
                Breakpoint breakpoint = breakpoints[i];
                if (breakpoint.startAddress != address && (!breakpoint.range || breakpoint.startAddress > address || address > breakpoint.endAddress) || breakpoint.bank >= 0 && breakpoint.bank != this.mapper.getPrgBank(address)) continue;
                breakpoint.hit = true;
            }
        }
    }

    private int read(int address) {
        Breakpoint[] breakpoints = this.readBreakpoints;
        if (breakpoints != null) {
            for (int i = breakpoints.length - 1; i >= 0; --i) {
                Breakpoint breakpoint = breakpoints[i];
                if (breakpoint.startAddress != address && (!breakpoint.range || breakpoint.startAddress > address || address > breakpoint.endAddress) || breakpoint.bank >= 0 && breakpoint.bank != this.mapper.getPrgBank(address)) continue;
                breakpoint.hit = true;
            }
        }
        if (this.dmcCycle > 0) {
            int cycle = this.dmcCycle - 1;
            this.dmcCycle = 0;
            if (address == 16406 || address == 16407) {
                if (cycle-- > 0) {
                    this.read(address);
                }
                while (cycle-- > 0) {
                    this.handleCpuCycle();
                }
            } else {
                while (cycle-- > 0) {
                    this.read(address);
                }
            }
            this.dmc.fillSampleBuffer(this.read(this.dmcAddress));
        }
        this.handleCpuCycle();
        AccessPoint[] preAccessPoints = this.preReadAccessPoints;
        if (preAccessPoints != null) {
            for (int i = preAccessPoints.length - 1; i >= 0; --i) {
                int v;
                AccessPoint accessPoint = preAccessPoints[i];
                if (accessPoint.minAddress > address || address > accessPoint.maxAddress || accessPoint.bank >= 0 && accessPoint.bank != this.mapper.getPrgBank(address) || (v = accessPoint.listener.accessPointHit(0, address, -1)) < 0) continue;
                return v & 0xFF;
            }
        }
        int value = this.mapper.readCpuMemory(address);
        AccessPoint[] postAccessPoints = this.postReadAccessPoints;
        if (postAccessPoints != null) {
            for (int i = postAccessPoints.length - 1; i >= 0; --i) {
                int v;
                AccessPoint accessPoint = postAccessPoints[i];
                if (accessPoint.minAddress > address || address > accessPoint.maxAddress || accessPoint.bank >= 0 && accessPoint.bank != this.mapper.getPrgBank(address) || (v = accessPoint.listener.accessPointHit(1, address, value)) < 0) continue;
                return v & 0xFF;
            }
        }
        return value;
    }

    public int applyCheats(int address, int value) {
        if (this.cheats != null) {
            for (int i = this.cheats.length - 1; i >= 0; --i) {
                int result = this.cheats[i].apply(address, value);
                if (result < 0) continue;
                return result;
            }
        }
        return value;
    }

    private void AAC(int value) {
        this.A &= value;
        this.C = this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private void ADC(int value) {
        int t = this.A + value + this.C;
        this.N = BitUtil.getBit(t, 7);
        this.C = BitUtil.getBit(t, 8);
        this.V = BitUtil.getBit((this.A ^ t) & (value ^ t), 7);
        this.A = t & 0xFF;
        this.Z = this.A == 0 ? 1 : 0;
    }

    private void AND(int value) {
        this.A &= value;
        this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private void ARR(int value) {
        this.A &= value;
        this.A = this.ROR(this.A);
        switch (BitUtil.getBit(this.A, 6) << 1 | BitUtil.getBit(this.A, 5)) {
            case 0: {
                this.C = 0;
                this.V = 0;
                break;
            }
            case 1: {
                this.V = 1;
                this.C = 0;
                break;
            }
            case 2: {
                this.C = 1;
                this.V = 1;
                break;
            }
            case 3: {
                this.V = 0;
                this.C = 1;
            }
        }
        this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private int ASL(int value) {
        this.C = BitUtil.getBit(value, 7);
        value = value << 1 & 0xFE;
        this.N = BitUtil.getBit(value, 7);
        this.Z = value == 0 ? 1 : 0;
        return value;
    }

    private void ASR(int value) {
        this.A = this.LSR(this.A & value);
    }

    private void ATX(int value) {
        this.A = value;
        this.TAX();
    }

    private void AXS(int value) {
        this.X = (this.A & this.X) + 256 - value;
        this.C = BitUtil.getBit(this.X, 8);
        this.X &= 0xFF;
        this.N = BitUtil.getBit(this.X, 7);
        this.Z = this.X == 0 ? 1 : 0;
    }

    private void BIT(int value) {
        this.N = BitUtil.getBit(value, 7);
        this.V = BitUtil.getBit(value, 6);
        this.Z = (this.A & value) == 0 ? 1 : 0;
    }

    private void CLC() {
        this.C = 0;
    }

    private void CLD() {
        this.D = 0;
    }

    private void CLI() {
        this.I = 0;
    }

    private void CLV() {
        this.V = 0;
    }

    private void CMP(int value) {
        this.C = this.A >= value ? 1 : 0;
        this.N = BitUtil.getBit(this.A - value, 7);
        this.Z = this.A == value ? 1 : 0;
    }

    private void CPX(int value) {
        this.C = this.X >= value ? 1 : 0;
        this.N = BitUtil.getBit(this.X - value, 7);
        this.Z = this.X == value ? 1 : 0;
    }

    private void CPY(int value) {
        this.C = this.Y >= value ? 1 : 0;
        this.N = BitUtil.getBit(this.Y - value, 7);
        this.Z = this.Y == value ? 1 : 0;
    }

    private int DCP(int value) {
        value = this.DEC(value);
        this.CMP(value);
        return value;
    }

    private int DEC(int value) {
        value = value - 1 & 0xFF;
        this.N = BitUtil.getBit(value, 7);
        this.Z = value == 0 ? 1 : 0;
        return value;
    }

    private void DEX() {
        this.X = this.X - 1 & 0xFF;
        this.Z = this.X == 0 ? 1 : 0;
        this.N = BitUtil.getBit(this.X, 7);
    }

    private void DEY() {
        this.Y = this.Y - 1 & 0xFF;
        this.Z = this.Y == 0 ? 1 : 0;
        this.N = BitUtil.getBit(this.Y, 7);
    }

    private void EOR(int value) {
        this.A ^= value;
        this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private int INC(int value) {
        value = value + 1 & 0xFF;
        this.N = BitUtil.getBit(value, 7);
        this.Z = value == 0 ? 1 : 0;
        return value;
    }

    private void INX() {
        this.X = this.X + 1 & 0xFF;
        this.Z = this.X == 0 ? 1 : 0;
        this.N = BitUtil.getBit(this.X, 7);
    }

    private void INY() {
        this.Y = this.Y + 1 & 0xFF;
        this.Z = this.Y == 0 ? 1 : 0;
        this.N = BitUtil.getBit(this.Y, 7);
    }

    private int ISB(int value) {
        value = this.INC(value);
        this.SBC(value);
        return value;
    }

    private void LAR(int value) {
        this.S = this.A = value & this.S;
        this.TAX();
    }

    private void LAX(int value) {
        this.LDA(value);
        this.TAX();
    }

    private void LDA(int value) {
        this.A = value;
        this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private void LDX(int value) {
        this.X = value;
        this.N = BitUtil.getBit(this.X, 7);
        this.Z = this.X == 0 ? 1 : 0;
    }

    private void LDY(int value) {
        this.Y = value;
        this.N = BitUtil.getBit(this.Y, 7);
        this.Z = this.Y == 0 ? 1 : 0;
    }

    private int LSR(int value) {
        this.N = 0;
        this.C = BitUtil.getBit(value, 0);
        this.Z = (value = value >> 1 & 0x7F) == 0 ? 1 : 0;
        return value;
    }

    private void ORA(int value) {
        this.A |= value;
        this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private int RLA(int value) {
        value = this.ROL(value);
        this.AND(value);
        return value;
    }

    private int ROL(int value) {
        int t = BitUtil.getBit(value, 7);
        value = value << 1 & 0xFE;
        this.C = t;
        this.Z = (value |= this.C) == 0 ? 1 : 0;
        this.N = BitUtil.getBit(value, 7);
        return value;
    }

    private int ROR(int value) {
        int t = BitUtil.getBit(value, 0);
        value = value >> 1 & 0x7F;
        this.C = t;
        this.Z = (value |= this.C << 7) == 0 ? 1 : 0;
        this.N = BitUtil.getBit(value, 7);
        return value;
    }

    private int RRA(int value) {
        value = this.ROR(value);
        this.ADC(value);
        return value;
    }

    private void SBC(int value) {
        this.ADC(value ^ 0xFF);
    }

    private void SEC() {
        this.C = 1;
    }

    private void SED() {
        this.D = 1;
    }

    private void SEI() {
        this.I = 1;
    }

    private int SLO(int value) {
        value = this.ASL(value);
        this.ORA(value);
        return value;
    }

    private int SRE(int value) {
        value = this.LSR(value);
        this.EOR(value);
        return value;
    }

    private void TAX() {
        this.X = this.A;
        this.N = BitUtil.getBit(this.X, 7);
        this.Z = this.X == 0 ? 1 : 0;
    }

    private void TAY() {
        this.Y = this.A;
        this.N = BitUtil.getBit(this.Y, 7);
        this.Z = this.Y == 0 ? 1 : 0;
    }

    private void TSX() {
        this.X = this.S;
        this.N = BitUtil.getBit(this.X, 7);
        this.Z = this.X == 0 ? 1 : 0;
    }

    private void TXA() {
        this.A = this.X;
        this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private void TXS() {
        this.S = this.X;
    }

    private void TYA() {
        this.A = this.Y;
        this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private void XAA(int value) {
        this.A &= this.X & value;
        this.C = this.N = BitUtil.getBit(this.A, 7);
        this.Z = this.A == 0 ? 1 : 0;
    }

    private int XAS(int value) {
        this.S = this.X & this.A;
        return this.S & value;
    }

    private void RESET() {
        this.read(this.PC);
        this.read(this.PC);
        this.readStack();
        this.decrementS();
        this.readStack();
        this.decrementS();
        this.readStack();
        this.decrementS();
        this.PC = this.PC & 0xFF00 | this.read(65532);
        this.I = 1;
        this.PC = this.read(65533) << 8 | this.PC & 0xFF;
        this.serviced = ServicedType.RST;
    }

    private void NMI() {
        this.read(this.PC);
        this.read(this.PC);
        this.writeStack(this.PC >> 8);
        this.decrementS();
        this.writeStack(this.PC & 0xFF);
        this.decrementS();
        this.writeStack(this.getFlags());
        this.decrementS();
        this.I = 1;
        this.PC = this.PC & 0xFF00 | this.read(65530);
        this.PC = this.read(65531) << 8 | this.PC & 0xFF;
        this.serviced = ServicedType.NMI;
    }

    private void IRQ() {
        int address;
        this.read(this.PC);
        this.read(this.PC);
        this.writeStack(this.PC >> 8);
        this.decrementS();
        this.writeStack(this.PC & 0xFF);
        this.decrementS();
        this.writeStack(this.getFlags());
        this.decrementS();
        if (this.nmiRequested) {
            this.nmiRequested = false;
            address = 65530;
            this.serviced = ServicedType.NMI;
        } else {
            address = 65534;
            this.serviced = ServicedType.IRQ;
        }
        this.I = 1;
        this.PC = this.PC & 0xFF00 | this.read(address++);
        this.PC = this.read(address) << 8 | this.PC & 0xFF;
    }

    private void BRK() {
        int address;
        this.read(this.PC);
        this.incrementPC();
        this.writeStack(this.PC >> 8);
        this.decrementS();
        this.writeStack(this.PC & 0xFF);
        this.decrementS();
        this.writeStack(this.getFlags() | 0x10);
        this.decrementS();
        if (this.nmiRequested) {
            this.nmiRequested = false;
            address = 65530;
            this.serviced = ServicedType.NMI;
        } else {
            address = 65534;
            this.serviced = ServicedType.BRK;
        }
        this.I = 1;
        this.PC = this.PC & 0xFF00 | this.read(address++);
        this.PC = this.read(address) << 8 | this.PC & 0xFF;
    }

    private void RTI() {
        this.read(this.PC);
        this.readStack();
        this.incrementS();
        this.setFlags(this.readStack());
        this.incrementS();
        this.PC = this.PC & 0xFF00 | this.readStack();
        this.incrementS();
        this.PC = this.PC & 0xFF | this.readStack() << 8;
    }

    private void RTS() {
        this.read(this.PC);
        this.readStack();
        this.incrementS();
        this.PC = this.PC & 0xFF00 | this.readStack();
        this.incrementS();
        this.PC = this.PC & 0xFF | this.readStack() << 8;
        this.read(this.PC);
        this.incrementPC();
    }

    private void PUSH() {
        this.read(this.PC);
        switch (this.opcode) {
            case 8: {
                this.writeStack(0x10 | this.getFlags());
                break;
            }
            case 72: {
                this.writeStack(this.A);
            }
        }
        this.decrementS();
    }

    private void PULL() {
        this.read(this.PC);
        this.readStack();
        this.incrementS();
        switch (this.opcode) {
            case 40: {
                this.setFlags(this.readStack());
                break;
            }
            case 104: {
                this.A = this.readStack();
                this.N = BitUtil.getBit(this.A, 7);
                this.Z = this.A == 0 ? 1 : 0;
            }
        }
    }

    private void JSR() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.readStack();
        this.writeStack(this.PC >> 8);
        this.decrementS();
        this.writeStack(this.PC & 0xFF);
        this.decrementS();
        this.PC = this.read(this.PC) << 8 | address;
    }

    private void KIL() {
        --this.PC;
        this.PC &= 0xFFFF;
        if (this.running) {
            this.running = false;
            App.cpuKilled(this.mapper.readCpuMemory(this.PC), this.PC);
        }
    }

    private void ACCUMULATOR_OR_IMPLIED() {
        this.read(this.PC);
        switch (this.opcode) {
            case 10: {
                this.A = this.ASL(this.A);
                break;
            }
            case 24: {
                this.CLC();
                break;
            }
            case 42: {
                this.A = this.ROL(this.A);
                break;
            }
            case 56: {
                this.SEC();
                break;
            }
            case 74: {
                this.A = this.LSR(this.A);
                break;
            }
            case 88: {
                this.CLI();
                break;
            }
            case 106: {
                this.A = this.ROR(this.A);
                break;
            }
            case 120: {
                this.SEI();
                break;
            }
            case 136: {
                this.DEY();
                break;
            }
            case 138: {
                this.TXA();
                break;
            }
            case 152: {
                this.TYA();
                break;
            }
            case 154: {
                this.TXS();
                break;
            }
            case 168: {
                this.TAY();
                break;
            }
            case 170: {
                this.TAX();
                break;
            }
            case 184: {
                this.CLV();
                break;
            }
            case 186: {
                this.TSX();
                break;
            }
            case 200: {
                this.INY();
                break;
            }
            case 202: {
                this.DEX();
                break;
            }
            case 216: {
                this.CLD();
                break;
            }
            case 232: {
                this.INX();
                break;
            }
            case 248: {
                this.SED();
                break;
            }
        }
    }

    private void IMMEDIATE() {
        int value = this.read(this.PC);
        this.incrementPC();
        switch (this.opcode) {
            case 9: {
                this.ORA(value);
                break;
            }
            case 11: 
            case 43: {
                this.AAC(value);
                break;
            }
            case 41: {
                this.AND(value);
                break;
            }
            case 73: {
                this.EOR(value);
                break;
            }
            case 75: {
                this.ASR(value);
                break;
            }
            case 105: {
                this.ADC(value);
                break;
            }
            case 107: {
                this.ARR(value);
                break;
            }
            case 139: {
                this.XAA(value);
                break;
            }
            case 160: {
                this.LDY(value);
                break;
            }
            case 162: {
                this.LDX(value);
                break;
            }
            case 169: {
                this.LDA(value);
                break;
            }
            case 171: {
                this.ATX(value);
                break;
            }
            case 192: {
                this.CPY(value);
                break;
            }
            case 201: {
                this.CMP(value);
                break;
            }
            case 203: {
                this.AXS(value);
                break;
            }
            case 224: {
                this.CPX(value);
                break;
            }
            case 233: 
            case 235: {
                this.SBC(value);
                break;
            }
        }
    }

    private void ABSOLUTE_JUMP() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.PC = this.read(this.PC) << 8 | address;
    }

    private void ABSOLUTE_READ() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.incrementPC();
        int value = this.read(address |= this.read(this.PC) << 8);
        switch (this.opcode) {
            case 12: {
                break;
            }
            case 13: {
                this.ORA(value);
                break;
            }
            case 44: {
                this.BIT(value);
                break;
            }
            case 45: {
                this.AND(value);
                break;
            }
            case 77: {
                this.EOR(value);
                break;
            }
            case 109: {
                this.ADC(value);
                break;
            }
            case 172: {
                this.LDY(value);
                break;
            }
            case 173: {
                this.LDA(value);
                break;
            }
            case 174: {
                this.LDX(value);
                break;
            }
            case 175: {
                this.LAX(value);
                break;
            }
            case 204: {
                this.CPY(value);
                break;
            }
            case 205: {
                this.CMP(value);
                break;
            }
            case 236: {
                this.CPX(value);
                break;
            }
            case 237: {
                this.SBC(value);
            }
        }
    }

    private void ABSOLUTE_READ_MODIFY_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.incrementPC();
        int value = this.read(address |= this.read(this.PC) << 8);
        this.write(address, value);
        switch (this.opcode) {
            case 14: {
                value = this.ASL(value);
                break;
            }
            case 15: {
                value = this.SLO(value);
                break;
            }
            case 46: {
                value = this.ROL(value);
                break;
            }
            case 47: {
                value = this.RLA(value);
                break;
            }
            case 79: {
                value = this.SRE(value);
                break;
            }
            case 78: {
                value = this.LSR(value);
                break;
            }
            case 110: {
                value = this.ROR(value);
                break;
            }
            case 111: {
                value = this.RRA(value);
                break;
            }
            case 206: {
                value = this.DEC(value);
                break;
            }
            case 207: {
                value = this.DCP(value);
                break;
            }
            case 238: {
                value = this.INC(value);
                break;
            }
            case 239: {
                value = this.ISB(value);
            }
        }
        this.write(address, value);
    }

    private void ABSOLUTE_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        address |= this.read(this.PC) << 8;
        this.incrementPC();
        switch (this.opcode) {
            case 140: {
                this.write(address, this.Y);
                break;
            }
            case 141: {
                this.write(address, this.A);
                break;
            }
            case 142: {
                this.write(address, this.X);
                break;
            }
            case 143: {
                this.write(address, this.A & this.X);
            }
        }
    }

    private void ZERO_PAGE_READ() {
        int address = this.read(this.PC);
        this.incrementPC();
        int value = this.read(address);
        switch (this.opcode) {
            case 4: {
                break;
            }
            case 5: {
                this.ORA(value);
                break;
            }
            case 36: {
                this.BIT(value);
                break;
            }
            case 37: {
                this.AND(value);
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                this.EOR(value);
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                this.ADC(value);
                break;
            }
            case 164: {
                this.LDY(value);
                break;
            }
            case 165: {
                this.LDA(value);
                break;
            }
            case 166: {
                this.LDX(value);
                break;
            }
            case 167: {
                this.LAX(value);
                break;
            }
            case 196: {
                this.CPY(value);
                break;
            }
            case 197: {
                this.CMP(value);
                break;
            }
            case 228: {
                this.CPX(value);
                break;
            }
            case 229: {
                this.SBC(value);
            }
        }
    }

    private void ZERO_PAGE_READ_MODIFY_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        int value = this.read(address);
        this.write(address, value);
        switch (this.opcode) {
            case 6: {
                value = this.ASL(value);
                break;
            }
            case 7: {
                value = this.SLO(value);
                break;
            }
            case 38: {
                value = this.ROL(value);
                break;
            }
            case 39: {
                value = this.RLA(value);
                break;
            }
            case 70: {
                value = this.LSR(value);
                break;
            }
            case 71: {
                value = this.SRE(value);
                break;
            }
            case 102: {
                value = this.ROR(value);
                break;
            }
            case 103: {
                value = this.RRA(value);
                break;
            }
            case 198: {
                value = this.DEC(value);
                break;
            }
            case 199: {
                value = this.DCP(value);
                break;
            }
            case 230: {
                value = this.INC(value);
                break;
            }
            case 231: {
                value = this.ISB(value);
            }
        }
        this.write(address, value);
    }

    private void ZERO_PAGE_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        switch (this.opcode) {
            case 132: {
                this.write(address, this.Y);
                break;
            }
            case 133: {
                this.write(address, this.A);
                break;
            }
            case 134: {
                this.write(address, this.X);
                break;
            }
            case 135: {
                this.write(address, this.A & this.X);
            }
        }
    }

    private void ZERO_PAGE_INDEXED_READ() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.read(address);
        switch (this.opcode) {
            case 182: 
            case 183: {
                address += this.Y;
                break;
            }
            default: {
                address += this.X;
            }
        }
        int value = this.read(address &= 0xFF);
        switch (this.opcode) {
            case 21: {
                this.ORA(value);
                break;
            }
            case 53: {
                this.AND(value);
                break;
            }
            case 85: {
                this.EOR(value);
                break;
            }
            case 117: {
                this.ADC(value);
                break;
            }
            case 180: {
                this.LDY(value);
                break;
            }
            case 181: {
                this.LDA(value);
                break;
            }
            case 182: {
                this.LDX(value);
                break;
            }
            case 183: {
                this.LAX(value);
                break;
            }
            case 213: {
                this.CMP(value);
                break;
            }
            case 245: {
                this.SBC(value);
                break;
            }
        }
    }

    private void ZERO_PAGE_INDEXED_READ_MODIFY_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.read(address);
        address += this.X;
        int value = this.read(address &= 0xFF);
        this.write(address, value);
        switch (this.opcode) {
            case 22: {
                value = this.ASL(value);
                break;
            }
            case 23: {
                value = this.SLO(value);
                break;
            }
            case 54: {
                value = this.ROL(value);
                break;
            }
            case 55: {
                value = this.RLA(value);
                break;
            }
            case 86: {
                value = this.LSR(value);
                break;
            }
            case 87: {
                value = this.SRE(value);
                break;
            }
            case 118: {
                value = this.ROR(value);
                break;
            }
            case 119: {
                value = this.RRA(value);
                break;
            }
            case 214: {
                value = this.DEC(value);
                break;
            }
            case 215: {
                value = this.DCP(value);
                break;
            }
            case 246: {
                value = this.INC(value);
                break;
            }
            case 247: {
                value = this.ISB(value);
            }
        }
        this.write(address, value);
    }

    private void ZERO_PAGE_INDEXED_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.read(address);
        switch (this.opcode) {
            case 148: 
            case 149: {
                address += this.X;
                break;
            }
            case 150: 
            case 151: {
                address += this.Y;
            }
        }
        address &= 0xFF;
        switch (this.opcode) {
            case 148: {
                this.write(address, this.Y);
                break;
            }
            case 149: {
                this.write(address, this.A);
                break;
            }
            case 150: {
                this.write(address, this.X);
                break;
            }
            case 151: {
                this.write(address, this.A & this.X);
            }
        }
    }

    private void ABSOLUTE_INDEXED_READ() {
        int offset;
        int address1 = this.read(this.PC);
        this.incrementPC();
        address1 |= this.read(this.PC) << 8;
        switch (this.opcode) {
            case 25: 
            case 57: 
            case 89: 
            case 121: 
            case 185: 
            case 187: 
            case 190: 
            case 191: 
            case 217: 
            case 249: {
                offset = this.Y;
                break;
            }
            default: {
                offset = this.X;
            }
        }
        int address2 = address1 + offset & 0xFFFF;
        address1 = address1 & 0xFF00 | address2 & 0xFF;
        this.incrementPC();
        int value = this.read(address1);
        if (address1 != address2) {
            value = this.read(address2);
        }
        switch (this.opcode) {
            case 25: 
            case 29: {
                this.ORA(value);
                break;
            }
            case 57: 
            case 61: {
                this.AND(value);
                break;
            }
            case 89: 
            case 93: {
                this.EOR(value);
                break;
            }
            case 121: 
            case 125: {
                this.ADC(value);
                break;
            }
            case 187: {
                this.LAR(value);
                break;
            }
            case 188: {
                this.LDY(value);
                break;
            }
            case 185: 
            case 189: {
                this.LDA(value);
                break;
            }
            case 190: {
                this.LDX(value);
                break;
            }
            case 191: {
                this.LAX(value);
                break;
            }
            case 217: 
            case 221: {
                this.CMP(value);
                break;
            }
            case 249: 
            case 253: {
                this.SBC(value);
                break;
            }
        }
    }

    private void ABSOLUTE_INDEXED_READ_MODIFY_WRITE() {
        int offset;
        int value = this.read(this.PC);
        this.incrementPC();
        switch (this.opcode) {
            case 27: 
            case 59: 
            case 91: 
            case 123: 
            case 219: 
            case 251: {
                offset = this.Y;
                break;
            }
            default: {
                offset = this.X;
            }
        }
        int address = (value |= this.read(this.PC) << 8) + offset & 0xFFFF;
        this.incrementPC();
        this.read(value & 0xFF00 | address & 0xFF);
        value = this.read(address);
        this.write(address, value);
        switch (this.opcode) {
            case 27: 
            case 31: {
                value = this.SLO(value);
                break;
            }
            case 30: {
                value = this.ASL(value);
                break;
            }
            case 59: 
            case 63: {
                value = this.RLA(value);
                break;
            }
            case 62: {
                value = this.ROL(value);
                break;
            }
            case 91: 
            case 95: {
                value = this.SRE(value);
                break;
            }
            case 94: {
                value = this.LSR(value);
                break;
            }
            case 123: 
            case 127: {
                value = this.RRA(value);
                break;
            }
            case 126: {
                value = this.ROR(value);
                break;
            }
            case 219: 
            case 223: {
                value = this.DCP(value);
                break;
            }
            case 222: {
                value = this.DEC(value);
                break;
            }
            case 251: 
            case 255: {
                value = this.ISB(value);
                break;
            }
            case 254: {
                value = this.INC(value);
            }
        }
        this.write(address, value);
    }

    private void ABSOLUTE_INDEXED_WRITE() {
        int offset;
        int value = this.read(this.PC);
        this.incrementPC();
        int high = this.read(this.PC);
        value |= high << 8;
        switch (this.opcode) {
            case 156: 
            case 157: {
                offset = this.X;
                break;
            }
            default: {
                offset = this.Y;
            }
        }
        int address = value + offset & 0xFFFF;
        value = value & 0xFF00 | address & 0xFF;
        this.incrementPC();
        this.read(value);
        switch (this.opcode) {
            case 153: 
            case 157: {
                this.write(address, this.A);
                break;
            }
            case 155: {
                this.write(address, this.XAS(high + 1));
                break;
            }
            case 156: {
                if (value >> 8 != address >> 8) {
                    value &= this.Y << 8;
                }
                this.write(value, this.Y & (value >> 8) + 1);
                break;
            }
            case 158: {
                if (value >> 8 != address >> 8) {
                    value &= this.X << 8;
                }
                this.write(value, this.X & (value >> 8) + 1);
                break;
            }
            case 159: {
                if (value >> 8 != address >> 8) {
                    value &= (this.X & this.A) << 8;
                }
                this.write(address, this.X & this.A & (address >> 8) + 1);
            }
        }
    }

    private void RELATIVE_BRANCH() {
        int addressOffset = this.read(this.PC);
        this.incrementPC();
        boolean branchTaken = false;
        switch (this.opcode) {
            case 16: {
                branchTaken = this.N == 0;
                break;
            }
            case 48: {
                branchTaken = this.N == 1;
                break;
            }
            case 80: {
                branchTaken = this.V == 0;
                break;
            }
            case 112: {
                branchTaken = this.V == 1;
                break;
            }
            case 144: {
                branchTaken = this.C == 0;
                break;
            }
            case 176: {
                branchTaken = this.C == 1;
                break;
            }
            case 208: {
                branchTaken = this.Z == 0;
                break;
            }
            case 240: {
                boolean bl = branchTaken = this.Z == 1;
            }
        }
        if (branchTaken) {
            boolean clearNMI = false;
            boolean clearIRQ = false;
            if (this.nmiRequested && !this.triggerNMI) {
                clearNMI = true;
            }
            if (this.irqRequested != 0 && !this.triggerIRQ) {
                clearIRQ = true;
            }
            this.read(this.PC);
            if (clearNMI) {
                this.triggerNMI = false;
            }
            if (clearIRQ) {
                this.triggerIRQ = false;
            }
            int jumpAddress = this.PC + (byte)addressOffset & 0xFFFF;
            this.PC = this.PC & 0xFF00 | jumpAddress & 0xFF;
            if (this.PC != jumpAddress) {
                this.read(this.PC);
                this.PC = jumpAddress;
            }
        }
    }

    private void INDEXED_INDIRECT_READ() {
        int address1 = this.read(this.PC);
        this.incrementPC();
        this.read(address1);
        address1 = address1 + this.X & 0xFF;
        int address2 = this.read(address1);
        address1 = address1 + 1 & 0xFF;
        int value = this.read(address2 |= this.read(address1) << 8);
        switch (this.opcode) {
            case 1: {
                this.ORA(value);
                break;
            }
            case 33: {
                this.AND(value);
                break;
            }
            case 65: {
                this.EOR(value);
                break;
            }
            case 97: {
                this.ADC(value);
                break;
            }
            case 161: {
                this.LDA(value);
                break;
            }
            case 163: {
                this.LAX(value);
                break;
            }
            case 193: {
                this.CMP(value);
                break;
            }
            case 225: {
                this.SBC(value);
            }
        }
    }

    private void INDEXED_INDIRECT_READ_MODIFY_WRITE() {
        int value = this.read(this.PC);
        this.incrementPC();
        this.read(value);
        value = value + this.X & 0xFF;
        int address = this.read(value);
        value = value + 1 & 0xFF;
        address |= this.read(value) << 8;
        value = this.read(address);
        this.write(address, value);
        switch (this.opcode) {
            case 3: {
                value = this.SLO(value);
                break;
            }
            case 35: {
                value = this.RLA(value);
                break;
            }
            case 67: {
                value = this.SRE(value);
                break;
            }
            case 99: {
                value = this.RRA(value);
                break;
            }
            case 195: {
                value = this.DCP(value);
                break;
            }
            case 227: {
                value = this.ISB(value);
            }
        }
        this.write(address, value);
    }

    private void INDEXED_INDIRECT_WRITE() {
        int value = this.read(this.PC);
        this.incrementPC();
        this.read(value);
        value = value + this.X & 0xFF;
        int address = this.read(value);
        value = value + 1 & 0xFF;
        address |= this.read(value) << 8;
        switch (this.opcode) {
            case 129: {
                this.write(address, this.A);
                break;
            }
            case 131: {
                this.write(address, this.A & this.X);
            }
        }
    }

    private void INDIRECT_INDEXED_READ() {
        int address1 = this.read(this.PC);
        this.incrementPC();
        int address2 = this.read(address1);
        ++address1;
        address1 = (address2 |= this.read(address1 &= 0xFF) << 8) + this.Y & 0xFFFF;
        address2 = address2 & 0xFF00 | address1 & 0xFF;
        int value = this.read(address2);
        if (address2 != address1) {
            value = this.read(address1);
        }
        switch (this.opcode) {
            case 17: {
                this.ORA(value);
                break;
            }
            case 49: {
                this.AND(value);
                break;
            }
            case 81: {
                this.EOR(value);
                break;
            }
            case 113: {
                this.ADC(value);
                break;
            }
            case 177: {
                this.LDA(value);
                break;
            }
            case 179: {
                this.LAX(value);
                break;
            }
            case 209: {
                this.CMP(value);
                break;
            }
            case 241: {
                this.SBC(value);
            }
        }
    }

    private void INDIRECT_INDEXED_READ_MODIFY_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        int value = this.read(address);
        ++address;
        address = (value |= this.read(address &= 0xFF) << 8) + this.Y & 0xFFFF;
        value = value & 0xFF00 | address & 0xFF;
        this.read(value);
        value = this.read(address);
        this.write(address, value);
        switch (this.opcode) {
            case 19: {
                value = this.SLO(value);
                break;
            }
            case 51: {
                value = this.RLA(value);
                break;
            }
            case 83: {
                value = this.SRE(value);
                break;
            }
            case 115: {
                value = this.RRA(value);
                break;
            }
            case 211: {
                value = this.DCP(value);
                break;
            }
            case 243: {
                value = this.ISB(value);
            }
        }
        this.write(address, value);
    }

    private void INDIRECT_INDEXED_WRITE() {
        int address = this.read(this.PC);
        this.incrementPC();
        int value = this.read(address);
        ++address;
        address = (value |= this.read(address &= 0xFF) << 8) + this.Y & 0xFFFF;
        value = value & 0xFF00 | address & 0xFF;
        this.read(value);
        switch (this.opcode) {
            case 145: {
                this.write(address, this.A);
                break;
            }
            case 147: {
                this.write(address, this.X & this.A & (address >> 8) + 1);
            }
        }
    }

    private void ABSOLUTE_INDIRECT_JUMP() {
        int address = this.read(this.PC);
        this.incrementPC();
        this.incrementPC();
        this.PC = this.PC & 0xFF00 | this.read(address |= this.read(this.PC) << 8);
        address = address & 0xFF00 | address + 1 & 0xFF;
        this.PC = this.read(address) << 8 | this.PC & 0xFF;
    }
}

