/*
 * Decompiled with CFR 0.152.
 */
package nintaco.api.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import nintaco.App;
import nintaco.api.AccessPointListener;
import nintaco.api.ActivateListener;
import nintaco.api.ControllersListener;
import nintaco.api.DeactivateListener;
import nintaco.api.FrameListener;
import nintaco.api.ScanlineCycleListener;
import nintaco.api.ScanlineListener;
import nintaco.api.SpriteZeroListener;
import nintaco.api.StatusListener;
import nintaco.api.StopListener;
import nintaco.api.local.LocalAPI;
import nintaco.api.server.DataStream;
import nintaco.api.server.ListenerLocker;
import nintaco.api.server.ServerAccessPointListener;
import nintaco.api.server.ServerActivateListener;
import nintaco.api.server.ServerControllersListener;
import nintaco.api.server.ServerDeactivateListener;
import nintaco.api.server.ServerFrameListener;
import nintaco.api.server.ServerScanlineCycleListener;
import nintaco.api.server.ServerScanlineListener;
import nintaco.api.server.ServerSpriteZeroListener;
import nintaco.api.server.ServerStatusListener;
import nintaco.api.server.ServerStopListener;
import nintaco.util.ThreadUtil;

public abstract class LocalBase {
    public static final int MAX_SIZE = 1024;
    public static final long HEARTBEAT_MILLIS = 13001L;
    public static final long FLUSH_MILLIS = 17011L;
    protected final Map<Integer, Object> listeners = new HashMap<Integer, Object>();
    protected final int[] as = new int[1024];
    protected final int[] bs = new int[1024];
    protected final char[] cs = new char[1024];
    protected final int[] emptyArray = new int[0];
    protected LocalAPI api;
    protected DataStream stream;
    protected ListenerLocker locker;
    protected Socket socket;
    protected Thread heartbeatThread;
    protected Thread flushThread;
    protected boolean disposed;
    protected volatile boolean running = true;

    public void run(Socket socket) {
        try {
            this.socket = socket;
            this.stream = new DataStream(new DataOutputStream(new BufferedOutputStream(socket.getOutputStream())), new DataInputStream(new BufferedInputStream(socket.getInputStream())));
            this.locker = new ListenerLocker();
            this.heartbeatThread = new Thread(this::sendHeartbeats, "Program Server Heartbeat Thread");
            this.flushThread = new Thread(this::sendFlushes, "Program Server Flush Thread");
            this.heartbeatThread.start();
            this.flushThread.start();
            this.api = new LocalAPI();
            while (this.running) {
                this.call(this.stream.readByte());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.dispose();
        }
    }

    private void sendHeartbeats() {
        try {
            while (this.running) {
                ThreadUtil.sleep(13001L);
                this.locker.waitForRequest(false);
                this.stream.writeByte(253);
                this.stream.flush();
                this.locker.waitForResponse();
            }
        }
        catch (Throwable t) {
            this.dispose();
        }
    }

    private void sendFlushes() {
        try {
            while (this.running) {
                ThreadUtil.sleep(17011L);
                this.stream.flush();
            }
        }
        catch (Throwable t) {
            this.dispose();
        }
    }

    public abstract void callMethod(int var1) throws Throwable;

    public void call(int methodValue) throws Throwable {
        switch (methodValue) {
            case 1: {
                int listenerID = this.stream.readInt();
                ServerActivateListener listener = new ServerActivateListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addActivateListener(listener);
                break;
            }
            case 2: {
                int listenerID = this.stream.readInt();
                ActivateListener listener = (ActivateListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeActivateListener(listener);
                break;
            }
            case 3: {
                int listenerID = this.stream.readInt();
                ServerDeactivateListener listener = new ServerDeactivateListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addDeactivateListener(listener);
                break;
            }
            case 4: {
                int listenerID = this.stream.readInt();
                DeactivateListener listener = (DeactivateListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeDeactivateListener(listener);
                break;
            }
            case 5: {
                int listenerID = this.stream.readInt();
                ServerStopListener listener = new ServerStopListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addStopListener(listener);
                break;
            }
            case 6: {
                int listenerID = this.stream.readInt();
                StopListener listener = (StopListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeStopListener(listener);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                int listenerID = this.stream.readInt();
                ServerAccessPointListener listener = new ServerAccessPointListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addAccessPointListener(listener, this.stream.readInt(), this.stream.readInt(), this.stream.readInt(), this.stream.readInt());
                break;
            }
            case 10: {
                int listenerID = this.stream.readInt();
                AccessPointListener listener = (AccessPointListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeAccessPointListener(listener);
                break;
            }
            case 11: {
                int listenerID = this.stream.readInt();
                ServerControllersListener listener = new ServerControllersListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addControllersListener(listener);
                break;
            }
            case 12: {
                int listenerID = this.stream.readInt();
                ControllersListener listener = (ControllersListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeControllersListener(listener);
                break;
            }
            case 13: {
                int listenerID = this.stream.readInt();
                ServerFrameListener listener = new ServerFrameListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addFrameListener(listener);
                break;
            }
            case 14: {
                int listenerID = this.stream.readInt();
                FrameListener listener = (FrameListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeFrameListener(listener);
                break;
            }
            case 15: {
                int listenerID = this.stream.readInt();
                ServerScanlineListener listener = new ServerScanlineListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addScanlineListener(listener, this.stream.readInt());
                break;
            }
            case 16: {
                int listenerID = this.stream.readInt();
                ScanlineListener listener = (ScanlineListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeScanlineListener(listener);
                break;
            }
            case 17: {
                int listenerID = this.stream.readInt();
                ServerScanlineCycleListener listener = new ServerScanlineCycleListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addScanlineCycleListener(listener, this.stream.readInt(), this.stream.readInt());
                break;
            }
            case 18: {
                int listenerID = this.stream.readInt();
                ScanlineCycleListener listener = (ScanlineCycleListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeScanlineCycleListener(listener);
                break;
            }
            case 19: {
                int listenerID = this.stream.readInt();
                ServerSpriteZeroListener listener = new ServerSpriteZeroListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addSpriteZeroListener(listener);
                break;
            }
            case 20: {
                int listenerID = this.stream.readInt();
                SpriteZeroListener listener = (SpriteZeroListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeSpriteZeroListener(listener);
                break;
            }
            case 21: {
                int listenerID = this.stream.readInt();
                ServerStatusListener listener = new ServerStatusListener(this.locker, this.stream, listenerID);
                this.listeners.put(listenerID, listener);
                this.api.addStatusListener(listener);
                break;
            }
            case 22: {
                int listenerID = this.stream.readInt();
                StatusListener listener = (StatusListener)this.listeners.remove(listenerID);
                if (listener == null) break;
                this.api.removeStatusListener(listener);
                break;
            }
            case 100: {
                this.stream.readIntArray(this.as);
                this.stream.readIntArray(this.bs);
                this.api.drawPolygon(this.as, this.bs, this.stream.readInt());
                break;
            }
            case 101: {
                this.stream.readIntArray(this.as);
                this.stream.readIntArray(this.bs);
                this.api.drawPolyline(this.as, this.bs, this.stream.readInt());
                break;
            }
            case 109: {
                this.stream.readIntArray(this.as);
                this.stream.readIntArray(this.bs);
                this.api.fillPolygon(this.as, this.bs, this.stream.readInt());
                break;
            }
            case 113: {
                this.stream.readCharArray(this.cs);
                this.api.drawChars(this.cs, this.stream.readInt(), this.stream.readInt(), this.stream.readInt(), this.stream.readInt(), this.stream.readBoolean());
                break;
            }
            case 114: {
                int length = this.stream.readCharArray(this.cs);
                this.api.drawChars(this.cs, 0, length, this.stream.readInt(), this.stream.readInt(), this.stream.readBoolean());
                break;
            }
            case 115: {
                int id = this.stream.readInt();
                int width = this.stream.readInt();
                int height = this.stream.readInt();
                if (width < 0 || height < 0 || width > 1024 || height > 1024) {
                    throw new IOException("Invalid sprite dimensions.");
                }
                int[] pixels = new int[width * height];
                this.stream.readIntArray(pixels);
                this.api.createSprite(id, width, height, pixels);
                break;
            }
            case 119: {
                int[] screen = this.api.getScreen();
                this.stream.writeIntArray(screen == null ? this.emptyArray : screen);
                break;
            }
            case 125: {
                this.api.showMessage(this.stream.readString());
                break;
            }
            case 128: {
                this.api.open(this.stream.readString());
                break;
            }
            case 129: {
                this.api.openArchiveEntry(this.stream.readString(), this.stream.readString());
                break;
            }
            case 130: {
                this.stream.writeStringArray(this.api.getArchiveEntries(this.stream.readString()));
                break;
            }
            case 131: {
                this.stream.writeString(this.api.getDefaultArchiveEntry(this.stream.readString()));
                break;
            }
            case 132: {
                this.api.openDefaultArchiveEntry(this.stream.readString());
                break;
            }
            case 134: {
                this.api.saveState(this.stream.readString());
                break;
            }
            case 135: {
                this.api.loadState(this.stream.readString());
                break;
            }
            case 138: {
                this.api.setTVSystem(this.stream.readString());
                break;
            }
            case 151: {
                this.api.addCheat(this.stream.readInt(), this.stream.readInt(), this.stream.readInt(), this.stream.readString(), this.stream.readBoolean());
                break;
            }
            case 153: {
                this.api.addGameGenie(this.stream.readString(), this.stream.readString(), this.stream.readBoolean());
                break;
            }
            case 154: {
                this.api.removeGameGenie(this.stream.readString());
                break;
            }
            case 155: {
                this.api.addProActionRocky(this.stream.readString(), this.stream.readString(), this.stream.readBoolean());
                break;
            }
            case 156: {
                this.api.removeProActionRocky(this.stream.readString());
                break;
            }
            case 163: {
                this.stream.writeInt(this.api.getStringWidth(this.stream.readString(), this.stream.readBoolean()));
                break;
            }
            case 164: {
                this.stream.readCharArray(this.cs);
                this.stream.writeInt(this.api.getCharsWidth(this.cs, this.stream.readBoolean()));
                break;
            }
            case 252: {
                LocalAPI.setLocalAPI(this.api);
                App.setLocalAPI(this.api);
                break;
            }
            case 253: {
                break;
            }
            case 254: {
                this.locker.responseReceived();
                break;
            }
            case 255: {
                this.locker.requestReceived();
                break;
            }
            default: {
                this.callMethod(methodValue);
            }
        }
        this.stream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LocalAPI localAPI;
        Thread ft;
        Thread ht;
        Socket s;
        LocalBase localBase = this;
        synchronized (localBase) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        this.running = false;
        ListenerLocker listenerLocker = this.locker;
        if (listenerLocker != null) {
            listenerLocker.dispose();
        }
        if ((s = this.socket) != null) {
            try {
                s.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((ht = this.heartbeatThread) != null) {
            ht.interrupt();
        }
        if ((ft = this.flushThread) != null) {
            ft.interrupt();
        }
        if ((localAPI = this.api) != null) {
            try {
                localAPI.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        LocalAPI.setLocalAPI(null);
    }
}

