/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.CPU;
import nintaco.Machine;
import nintaco.apu.AudioProcessor;
import nintaco.apu.Decimator;
import nintaco.apu.DeltaModulationChannel;
import nintaco.apu.NoiseGenerator;
import nintaco.apu.PulseGenerator;
import nintaco.apu.SystemAudioProcessor;
import nintaco.apu.TriangleGenerator;
import nintaco.gui.sound.volumemixer.VolumeMixerPrefs;
import nintaco.mappers.Mapper;
import nintaco.mappers.konami.vrc6.VRC6Audio;
import nintaco.mappers.konami.vrc7.VRC7Audio;
import nintaco.mappers.namco.Namco163Audio;
import nintaco.mappers.nintendo.fds.FdsAudio;
import nintaco.mappers.nintendo.mmc5.MMC5Audio;
import nintaco.mappers.sunsoft.fme7.Sunsoft5BAudio;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;

public class APU
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int REG_APU_PULSE1_ENVELOPE = 16384;
    public static final int REG_APU_PULSE1_SWEEP = 16385;
    public static final int REG_APU_PULSE1_TIMER_RELOAD_LOW = 16386;
    public static final int REG_APU_PULSE1_TIMER_RELOAD_HIGH = 16387;
    public static final int REG_APU_PULSE2_ENVELOPE = 16388;
    public static final int REG_APU_PULSE2_SWEEP = 16389;
    public static final int REG_APU_PULSE2_TIMER_RELOAD_LOW = 16390;
    public static final int REG_APU_PULSE2_TIMER_RELOAD_HIGH = 16391;
    public static final int REG_APU_TRIANGLE_LINEAR_COUNTER = 16392;
    public static final int REG_APU_TRIANGLE_TIMER_RELOAD_LOW = 16394;
    public static final int REG_APU_TRIANGLE_TIMER_RELOAD_HIGH = 16395;
    public static final int REG_APU_NOISE_ENVELOPE = 16396;
    public static final int REG_APU_NOISE_MODE_AND_PERIOD = 16398;
    public static final int REG_APU_NOISE_LENGTH_COUNTER = 16399;
    public static final int REG_APU_DMC_FLAGS_AND_FREQUENCY = 16400;
    public static final int REG_APU_DMC_DIRECT_LOAD = 16401;
    public static final int REG_APU_DMC_SAMPLE_ADDRESS = 16402;
    public static final int REG_APU_DMC_SAMPLE_LENGTH = 16403;
    public static final int REG_APU_STATUS = 16405;
    public static final int REG_APU_FRAME_COUNTER = 16407;
    public static final int[] lengths = new int[]{10, 254, 20, 2, 40, 4, 80, 6, 160, 8, 60, 10, 14, 12, 26, 14, 12, 16, 24, 18, 48, 20, 96, 22, 192, 24, 72, 26, 16, 28, 32, 30};
    private static boolean enabled;
    private static boolean soundEnabled;
    private static boolean normalSpeed;
    private static boolean smoothDMC;
    private static float pulse1Volume;
    private static float pulse2Volume;
    private static float triangleVolume;
    private static float noiseVolume;
    private static float dmcVolume;
    private static int masterVolume;
    public final PulseGenerator pulse1 = new PulseGenerator(true);
    public final PulseGenerator pulse2 = new PulseGenerator(false);
    public final NoiseGenerator noise = new NoiseGenerator();
    public final TriangleGenerator triangle = new TriangleGenerator();
    public final DeltaModulationChannel dmc = new DeltaModulationChannel();
    private CPU cpu;
    private boolean fiveStep;
    private boolean irqEnabled;
    private int timer;
    private int writeDelay;
    private int quarterFrameDelay;
    private int halfFrameDelay;
    private int irqDelay;
    private Mapper mapper;
    private Decimator decimator;
    private boolean pal;
    private transient AudioProcessor audioProcessor;

    private static void updateEnabled() {
        enabled = soundEnabled && normalSpeed && masterVolume > 0;
    }

    public static void setMasterVolume(int masterVolume) {
        APU.masterVolume = masterVolume;
        APU.updateEnabled();
    }

    public static boolean isSoundEnabled() {
        return soundEnabled;
    }

    public static void setSoundEnabled(boolean soundEnabled) {
        APU.soundEnabled = soundEnabled;
        APU.updateEnabled();
    }

    public static void setNormalSpeed(boolean normalSpeed) {
        APU.normalSpeed = normalSpeed;
        APU.updateEnabled();
    }

    public static void setSmoothDMC(boolean smoothDMC) {
        APU.smoothDMC = smoothDMC;
    }

    public static void setPulse1Volume(int pulse1Volume) {
        APU.pulse1Volume = (float)pulse1Volume / 100.0f;
    }

    public static void setPulse2Volume(int pulse2Volume) {
        APU.pulse2Volume = (float)pulse2Volume / 100.0f;
    }

    public static void setTriangleVolume(int triangleVolume) {
        APU.triangleVolume = 2.75167f * (float)triangleVolume / 100.0f;
    }

    public static void setNoiseVolume(int noiseVolume) {
        APU.noiseVolume = 1.84936f * (float)noiseVolume / 100.0f;
    }

    public static void setDmcVolume(int dmcVolume) {
        APU.dmcVolume = (float)dmcVolume / 100.0f;
    }

    public static void setVolumeMixerPrefs(VolumeMixerPrefs prefs) {
        APU.setMasterVolume(prefs.getMasterVolume());
        APU.setSoundEnabled(prefs.isSoundEnabled());
        APU.setSmoothDMC(prefs.isSmoothDMC());
        SystemAudioProcessor.setMasterVolume(prefs.getMasterVolume());
        APU.setPulse1Volume(prefs.getSquare1Volume());
        APU.setPulse2Volume(prefs.getSquare2Volume());
        APU.setTriangleVolume(prefs.getTriangleVolume());
        APU.setNoiseVolume(prefs.getNoiseVolume());
        APU.setDmcVolume(prefs.getDmcVolume());
        VRC6Audio.setVolume(prefs.getVrc6Volume());
        VRC7Audio.setVolume(prefs.getVrc7Volume());
        Namco163Audio.setVolume(prefs.getN163Volume());
        FdsAudio.setVolume(prefs.getFdsVolume());
        MMC5Audio.setVolume(prefs.getMmc5Volume());
        Sunsoft5BAudio.setVolume(prefs.getS5bVolume());
    }

    public static void init() {
        SystemAudioProcessor.init();
        APU.setVolumeMixerPrefs(AppPrefs.getInstance().getVolumeMixerPrefs());
    }

    public void reset() {
        this.irqEnabled = false;
        this.cpu.setApuIrq(false);
        this.writeStatus(0);
    }

    public void setMachine(Machine machine) {
        this.cpu = machine.getCPU();
        this.mapper = machine.getMapper();
    }

    public void setCPU(CPU cpu) {
        this.cpu = cpu;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public DeltaModulationChannel getDMC() {
        return this.dmc;
    }

    public void clearInactiveSeconds() {
        this.decimator.clearInactiveSeconds();
    }

    public int getInactiveSeconds() {
        return this.decimator.getInactiveSeconds();
    }

    public void setTVSystem(TVSystem tvSystem) {
        this.pal = tvSystem == TVSystem.PAL;
        this.decimator = new Decimator(tvSystem, 48000.0);
        this.decimator.setAudioProcessor(this.audioProcessor);
        this.noise.setPAL(this.pal);
        this.dmc.setPAL(this.pal);
    }

    public void setAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessor = audioProcessor;
        if (this.decimator != null) {
            this.decimator.setAudioProcessor(audioProcessor);
        }
    }

    public void setFadeVolume(float volume) {
        this.decimator.setVolume(volume);
    }

    public void writeFrameCounter(int value) {
        this.fiveStep = BitUtil.getBitBool(value, 7);
        this.irqEnabled = !BitUtil.getBitBool(value, 6);
        int n = this.writeDelay = MathUtil.isOdd(this.cpu.getCycleCounter()) ? 3 : 2;
        if (!this.irqEnabled) {
            this.cpu.setApuIrq(false);
        }
    }

    public void writeStatus(int value) {
        this.dmc.setEnabled(BitUtil.getBitBool(value, 4));
        this.noise.setEnabled(BitUtil.getBitBool(value, 3));
        this.triangle.setEnabled(BitUtil.getBitBool(value, 2));
        this.pulse2.setEnabled(BitUtil.getBitBool(value, 1));
        this.pulse1.setEnabled(BitUtil.getBitBool(value, 0));
    }

    public int readStatus() {
        int value = this.peekStatus();
        this.cpu.setApuIrq(false);
        return value;
    }

    public int peekStatus() {
        int value = 0;
        if (this.cpu.getDmcIrq()) {
            value |= 0x80;
        }
        if (this.cpu.getApuIrq()) {
            value |= 0x40;
        }
        if (this.dmc.getBytesRemaining() != 0) {
            value |= 0x10;
        }
        if (this.noise.getLengthCounter() != 0) {
            value |= 8;
        }
        if (this.triangle.getLengthCounter() != 0) {
            value |= 4;
        }
        if (this.pulse2.getLengthCounter() != 0) {
            value |= 2;
        }
        if (this.pulse1.getLengthCounter() != 0) {
            value |= 1;
        }
        return value;
    }

    public void update(boolean apuCycle) {
        if (apuCycle) {
            this.pulse1.update();
            this.pulse2.update();
            this.noise.update();
            this.dmc.update();
        }
        this.triangle.update();
        if (this.pal) {
            switch (this.timer) {
                case 8312: {
                    this.quarterFrameDelay = 2;
                    break;
                }
                case 16626: {
                    this.quarterFrameDelay = 2;
                    this.halfFrameDelay = 2;
                    break;
                }
                case 24938: {
                    this.quarterFrameDelay = 2;
                    break;
                }
                case 33252: {
                    if (this.fiveStep) break;
                    this.quarterFrameDelay = 2;
                    this.halfFrameDelay = 2;
                    this.irqDelay = 3;
                    this.timer = -2;
                    break;
                }
                case 41560: {
                    this.quarterFrameDelay = 2;
                    this.halfFrameDelay = 2;
                    this.timer = -2;
                }
            }
        } else {
            switch (this.timer) {
                case 7456: {
                    this.quarterFrameDelay = 2;
                    break;
                }
                case 14912: {
                    this.quarterFrameDelay = 2;
                    this.halfFrameDelay = 2;
                    break;
                }
                case 22370: {
                    this.quarterFrameDelay = 2;
                    break;
                }
                case 29828: {
                    if (this.fiveStep) break;
                    this.quarterFrameDelay = 2;
                    this.halfFrameDelay = 2;
                    this.irqDelay = 3;
                    this.timer = -2;
                    break;
                }
                case 37280: {
                    this.quarterFrameDelay = 2;
                    this.halfFrameDelay = 2;
                    this.timer = -2;
                }
            }
        }
        ++this.timer;
        if (this.quarterFrameDelay > 0 && --this.quarterFrameDelay == 0) {
            this.updateQuarterFrame();
        }
        if (this.halfFrameDelay > 0 && --this.halfFrameDelay == 0) {
            this.updateHalfFrame();
        }
        if (this.irqDelay > 0) {
            --this.irqDelay;
            if (!this.fiveStep && this.irqEnabled) {
                this.cpu.setApuIrq(true);
            }
        }
        if (this.writeDelay > 0 && --this.writeDelay == 0) {
            if (this.fiveStep) {
                this.quarterFrameDelay = 2;
                this.halfFrameDelay = 2;
            }
            this.timer = 0;
        }
        if (enabled) {
            float pulse = pulse1Volume * (float)this.pulse1.getValue() + pulse2Volume * (float)this.pulse2.getValue();
            int dmcValue = this.dmc.getOutputLevel();
            if (smoothDMC) {
                if ((dmcValue = (int)((float)dmcValue + this.dmc.getSmoothLevel())) < 0) {
                    dmcValue = 0;
                } else if (dmcValue > 127) {
                    dmcValue = 127;
                }
            }
            this.decimator.addInputSample((float)this.mapper.getAudioMixerScale() * (0.9588f * pulse / (pulse + 81.28f) - 361.733f / (triangleVolume * (float)this.triangle.getValue() + noiseVolume * (float)this.noise.getValue() + dmcVolume * (float)dmcValue + 226.38f) + 1.5979f) + this.mapper.getAudioSample() - 32768.0f);
        }
    }

    private void updateQuarterFrame() {
        this.pulse1.updateEnvelopeGenerator();
        this.pulse2.updateEnvelopeGenerator();
        this.noise.updateEnvelopeGenerator();
        this.triangle.updateLinearCounter();
    }

    private void updateHalfFrame() {
        this.pulse1.updateLengthCounterAndSweepGenerator();
        this.pulse2.updateLengthCounterAndSweepGenerator();
        this.noise.updateLengthCounter();
        this.triangle.updateLengthCounter();
    }

    static {
        APU.setSoundEnabled(true);
        APU.setNormalSpeed(true);
        APU.setSmoothDMC(true);
        APU.setMasterVolume(100);
        APU.setPulse1Volume(100);
        APU.setPulse2Volume(100);
        APU.setTriangleVolume(100);
        APU.setNoiseVolume(100);
        APU.setDmcVolume(100);
    }
}

