/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.apu.AudioProcessor;
import nintaco.tv.TVSystem;

public class Decimator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final double POS_ZERO = 1.0E-32;
    private static final double NEG_ZERO = -1.0E-32;
    private static final float I2 = 0.5f;
    private static final float I3 = 0.33333334f;
    private static final float I6 = 0.16666667f;
    private static final long[] LONG_NTSC_A1 = new long[]{-4611853762191645730L, -4611814239774026012L, -4611774918189152604L, -4611746105344357918L, -4611727291683890682L, -4611714290629894415L, -4616374979292587046L};
    private static final long[] LONG_NTSC_A2 = new long[]{4606855694691736891L, 4606945804914784106L, 4607035334755962727L, 4607100651770362555L, 4607142714491990126L, 4607170687821348870L};
    private static final long[] LONG_NTSC_B1 = new long[]{-4611921116531971374L, -4611758349017912632L, -4611728572387109540L, -4611718816394680315L, -4611714943755887758L, -4611713507705350933L};
    private static final long LONG_NTSC_G = 4525027503433553528L;
    private static final double[] NTSC_A1 = Decimator.toDoubleArray(LONG_NTSC_A1);
    private static final double[] NTSC_A2 = Decimator.toDoubleArray(LONG_NTSC_A2);
    private static final double[] NTSC_B1 = Decimator.toDoubleArray(LONG_NTSC_B1);
    private static final double NTSC_G = Double.longBitsToDouble(4525027503433553528L);
    private static final long[] LONG_PAL_A1 = new long[]{-4611866707240049911L, -4611824721394461186L, -4611782916035961699L, -4611752253801409194L, -4611732200336215017L, -4611718293735860272L, -4616389012738358714L};
    private static final long[] LONG_PAL_A2 = new long[]{4606831183266310993L, 4606927968823935785L, 4607024194933579476L, 4607094437495563338L, 4607139690175837979L, 4607169792870540374L};
    private static final long[] LONG_PAL_B1 = new long[]{-4611957926618005642L, -4611769794142195273L, -4611735318796627275L, -4611724019381435770L, -4611719533542050797L, -4611717870026779139L};
    private static final long LONG_PAL_G = 4525622401687517530L;
    private static final double[] PAL_A1 = Decimator.toDoubleArray(LONG_PAL_A1);
    private static final double[] PAL_A2 = Decimator.toDoubleArray(LONG_PAL_A2);
    private static final double[] PAL_B1 = Decimator.toDoubleArray(LONG_PAL_B1);
    private static final double PAL_G = Double.longBitsToDouble(4525622401687517530L);
    private static final long[] LONG_DENDY_A1 = new long[]{-4611855319309962951L, -4611815496277825592L, -4611775871843752781L, -4611746833735627142L, -4611727869336427630L, -4611714758604258017L, -4616376669299995395L};
    private static final long[] LONG_DENDY_A2 = new long[]{4606852741142982440L, 4606943656307953063L, 4607033993172772719L, 4607099903526701418L, 4607142350390394066L, 4607170580087035049L};
    private static final long[] LONG_DENDY_B1 = new long[]{-4611925410589340983L, -4611759682450854186L, -4611729358206230056L, -4611719422390443656L, -4611715478315582179L, -4611714015767169777L};
    private static final long LONG_DENDY_G = 4525099084055537568L;
    private static final double[] DENDY_A1 = Decimator.toDoubleArray(LONG_DENDY_A1);
    private static final double[] DENDY_A2 = Decimator.toDoubleArray(LONG_DENDY_A2);
    private static final double[] DENDY_B1 = Decimator.toDoubleArray(LONG_DENDY_B1);
    private static final double DENDY_G = Double.longBitsToDouble(4525099084055537568L);
    private final double g;
    private final double[] a1;
    private final double[] a2;
    private final double[] b1;
    private final double[] d1 = new double[7];
    private final double[] d2 = new double[6];
    private final double[] ys = new double[4];
    private final float inputSamplingFrequency;
    private final float inputSamplingPeriod;
    private final float outputSamplingFrequency;
    private final float outputSamplingPeriod;
    public final int ACTIVITY_SAMPLES;
    public final int ACTIVITY_THRESHOLD;
    private transient AudioProcessor audioProcessor;
    private float volume = 1.0f;
    private float time;
    private int index;
    private int lastSample;
    private int activitySum;
    private int activityCounter;
    private int inactiveSeconds;

    public Decimator(TVSystem tvSystem, double outputSamplingFrequency) {
        this.ACTIVITY_SAMPLES = (int)outputSamplingFrequency;
        this.ACTIVITY_THRESHOLD = 8 * this.ACTIVITY_SAMPLES;
        switch (tvSystem) {
            case PAL: {
                this.a1 = PAL_A1;
                this.a2 = PAL_A2;
                this.b1 = PAL_B1;
                this.g = PAL_G;
                break;
            }
            case Dendy: {
                this.a1 = DENDY_A1;
                this.a2 = DENDY_A2;
                this.b1 = DENDY_B1;
                this.g = DENDY_G;
                break;
            }
            default: {
                this.a1 = NTSC_A1;
                this.a2 = NTSC_A2;
                this.b1 = NTSC_B1;
                this.g = NTSC_G;
            }
        }
        this.inputSamplingFrequency = (float)tvSystem.getCyclesPerSecond();
        this.outputSamplingFrequency = (float)outputSamplingFrequency;
        this.inputSamplingPeriod = (float)(1.0 / (double)this.inputSamplingFrequency);
        this.outputSamplingPeriod = (float)(1.0 / outputSamplingFrequency);
    }

    public void setAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessor = audioProcessor;
    }

    private static double[] toDoubleArray(long[] values) {
        double[] ds = new double[values.length];
        for (int i = values.length - 1; i >= 0; --i) {
            ds[i] = Double.longBitsToDouble(values[i]);
        }
        return ds;
    }

    public float getVolume() {
        return this.volume;
    }

    public void clearInactiveSeconds() {
        this.activityCounter = 0;
        this.activitySum = 0;
        this.lastSample = 0;
        this.inactiveSeconds = 0;
    }

    public int getInactiveSeconds() {
        return this.inactiveSeconds;
    }

    public void setVolume(float volume) {
        this.volume = volume < 0.0f ? 0.0f : (volume > 1.0f ? 1.0f : volume);
    }

    public void hold(float duration) {
        this.time += duration;
        int sampleCount = (int)Math.floor(this.time * this.outputSamplingFrequency);
        this.time -= (float)sampleCount * this.outputSamplingPeriod;
        for (int i = sampleCount - 1; i >= 0; --i) {
            this.audioProcessor.processOutputSample(this.lastSample);
        }
    }

    public void addInputSample(double x) {
        double y;
        for (int i = 0; i < 6; ++i) {
            y = x + this.d1[i];
            this.d1[i] = this.b1[i] * x - this.a1[i] * y + this.d2[i];
            if (this.d1[i] != this.d1[i] || this.d1[i] > -1.0E-32 && this.d1[i] < 1.0E-32) {
                this.d1[i] = 0.0;
            }
            this.d2[i] = x - this.a2[i] * y;
            if (this.d2[i] != this.d2[i] || this.d2[i] > -1.0E-32 && this.d2[i] < 1.0E-32) {
                this.d2[i] = 0.0;
            }
            if ((x = y) == x && (!(x > -1.0E-32) || !(x < 1.0E-32))) continue;
            x = 0.0;
        }
        y = x + this.d1[6];
        this.d1[6] = x - this.a1[6] * y;
        if (this.d1[6] != this.d1[6] || this.d1[6] > -1.0E-32 && this.d1[6] < 1.0E-32) {
            this.d1[6] = 0.0;
        }
        this.ys[this.index] = this.g * y;
        if (this.ys[this.index] != this.ys[this.index] || this.ys[this.index] > -1.0E-32 && this.ys[this.index] < 1.0E-32) {
            this.ys[this.index] = 0.0;
        }
        this.time += this.inputSamplingPeriod;
        if (this.time >= this.outputSamplingPeriod) {
            int sample = this.interpolate(1.0f - (this.time - this.outputSamplingPeriod) * this.inputSamplingFrequency, (float)this.ys[this.index - 3 & 3], (float)this.ys[this.index - 2 & 3], (float)this.ys[this.index - 1 & 3], (float)this.ys[this.index]);
            this.audioProcessor.processOutputSample(sample);
            this.time -= this.outputSamplingPeriod;
            int delta = sample - this.lastSample;
            this.activitySum = delta < 0 ? (this.activitySum -= delta) : (this.activitySum += delta);
            if (++this.activityCounter == this.ACTIVITY_SAMPLES) {
                this.inactiveSeconds = this.activitySum < 0 || this.activitySum >= this.ACTIVITY_THRESHOLD ? 0 : this.inactiveSeconds + 1;
                this.activityCounter = 0;
                this.activitySum = 0;
            }
            this.lastSample = sample;
        }
        this.index = this.index + 1 & 3;
    }

    private int interpolate(float t, float y0, float y1, float y2, float y3) {
        float c3 = 0.16666667f * (y3 - y0) + 0.5f * (y1 - y2);
        float c2 = 0.5f * (y0 + y2) - y1;
        float c1 = y2 - 0.33333334f * y0 - 0.5f * y1 - 0.16666667f * y3;
        float c0 = y1;
        int value = (int)((((c3 * t + c2) * t + c1) * t + c0) * this.volume);
        if (value < Short.MIN_VALUE) {
            value = Short.MIN_VALUE;
        } else if (value > Short.MAX_VALUE) {
            value = Short.MAX_VALUE;
        }
        return value;
    }
}

