/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.apu.PulseGenerator;
import nintaco.util.BitUtil;

public class SweepGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int divider;
    private boolean reload;
    private boolean enabled;
    private int dividerPeriod;
    private boolean negate;
    private int shiftCount;
    private PulseGenerator pulseGenerator;

    public PulseGenerator getPulseGenerator() {
        return this.pulseGenerator;
    }

    public void setPulseGenerator(PulseGenerator pulseGenerator) {
        this.pulseGenerator = pulseGenerator;
    }

    public void write(int value) {
        this.enabled = BitUtil.getBitBool(value, 7);
        this.dividerPeriod = value >> 4 & 7;
        this.negate = BitUtil.getBitBool(value, 3);
        this.shiftCount = value & 7;
    }

    public void update() {
        if (this.reload) {
            int oldDivider = this.divider;
            this.divider = this.dividerPeriod;
            if (this.enabled && oldDivider == 0) {
                this.pulseGenerator.adjustPulsePeriod();
            }
            this.reload = false;
        } else if (this.divider > 0) {
            --this.divider;
        } else if (this.enabled) {
            this.divider = this.dividerPeriod;
            this.pulseGenerator.adjustPulsePeriod();
        }
    }

    public boolean isNegate() {
        return this.negate;
    }

    public int getShiftCount() {
        return this.shiftCount;
    }
}

