/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.apu.APU;
import nintaco.util.BitUtil;

public class TriangleGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[] waveform = new int[]{15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private boolean control;
    private boolean linearCounterReload;
    private int linearCounterReloadValue;
    private int timer;
    private int timerReloadValue;
    private int lengthCounter;
    private int waveformIndex;
    private int linearCounter;
    private boolean enabled;

    public void writeLinearCounter(int value) {
        this.control = BitUtil.getBitBool(value, 7);
        this.linearCounterReloadValue = 0x7F & value;
    }

    public void writeTimerReloadLow(int value) {
        this.timerReloadValue = this.timerReloadValue & 0xFF00 | value;
    }

    public void writeTimerReloadHigh(int value) {
        if (this.enabled) {
            this.lengthCounter = APU.lengths[value >> 3];
        }
        this.timerReloadValue = (value & 7) << 8 | this.timerReloadValue & 0xFF;
        this.linearCounterReload = true;
    }

    public void updateLengthCounter() {
        if (!this.control && this.lengthCounter > 0) {
            --this.lengthCounter;
        }
    }

    public void updateLinearCounter() {
        if (this.linearCounterReload) {
            this.linearCounter = this.linearCounterReloadValue;
        } else if (this.linearCounter > 0) {
            --this.linearCounter;
        }
        if (!this.control) {
            this.linearCounterReload = false;
        }
    }

    public void update() {
        if (this.timer == 0) {
            this.timer = this.timerReloadValue;
            if (this.linearCounter != 0 && this.lengthCounter != 0 && this.timerReloadValue >= 2) {
                this.waveformIndex = this.waveformIndex - 1 & 0x1F;
            }
        } else {
            --this.timer;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.lengthCounter = 0;
            this.linearCounter = 0;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getLengthCounter() {
        return this.lengthCounter;
    }

    public int getValue() {
        return waveform[this.waveformIndex];
    }
}

