/*
 * Decompiled with CFR 0.152.
 */
package nintaco.assembler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nintaco.MessageException;
import nintaco.assembler.CodeLabel;
import nintaco.assembler.InstructionKey;
import nintaco.util.StringUtil;

public class Assembler {
    private static final Object[][] INSTRUCTIONS = new Object[][]{{"AAC", 2, 2, 43, false}, {"ADC", 1, 2, 101, true}, {"ADC", 1, 3, 109, true}, {"ADC", 2, 2, 105, true}, {"ADC", 4, 2, 117, true}, {"ADC", 4, 3, 125, true}, {"ADC", 5, 3, 121, true}, {"ADC", 6, 2, 97, true}, {"ADC", 7, 2, 113, true}, {"AND", 1, 2, 37, true}, {"AND", 1, 3, 45, true}, {"AND", 2, 2, 41, true}, {"AND", 4, 2, 53, true}, {"AND", 4, 3, 61, true}, {"AND", 5, 3, 57, true}, {"AND", 6, 2, 33, true}, {"AND", 7, 2, 49, true}, {"ARR", 2, 2, 107, false}, {"ASL", 1, 1, 10, true}, {"ASL", 1, 2, 6, true}, {"ASL", 1, 3, 14, true}, {"ASL", 4, 2, 22, true}, {"ASL", 4, 3, 30, true}, {"ASR", 2, 2, 75, false}, {"ATX", 2, 2, 171, false}, {"AXS", 2, 2, 203, false}, {"BCC", 1, 2, 144, true}, {"BCS", 1, 2, 176, true}, {"BEQ", 1, 2, 240, true}, {"BIT", 1, 2, 36, true}, {"BIT", 1, 3, 44, true}, {"BMI", 1, 2, 48, true}, {"BNE", 1, 2, 208, true}, {"BPL", 1, 2, 16, true}, {"BRK", 0, 0, 0, true}, {"BVC", 1, 2, 80, true}, {"BVS", 1, 2, 112, true}, {"CLC", 0, 0, 24, true}, {"CLD", 0, 0, 216, true}, {"CLI", 0, 0, 88, true}, {"CLV", 0, 0, 184, true}, {"CMP", 1, 2, 197, true}, {"CMP", 1, 3, 205, true}, {"CMP", 2, 2, 201, true}, {"CMP", 4, 2, 213, true}, {"CMP", 4, 3, 221, true}, {"CMP", 5, 3, 217, true}, {"CMP", 6, 2, 193, true}, {"CMP", 7, 2, 209, true}, {"CPX", 1, 2, 228, true}, {"CPX", 1, 3, 236, true}, {"CPX", 2, 2, 224, true}, {"CPY", 1, 2, 196, true}, {"CPY", 1, 3, 204, true}, {"CPY", 2, 2, 192, true}, {"DCP", 1, 2, 199, false}, {"DCP", 1, 3, 207, false}, {"DCP", 4, 2, 215, false}, {"DCP", 4, 3, 223, false}, {"DCP", 5, 3, 219, false}, {"DCP", 6, 2, 195, false}, {"DCP", 7, 2, 211, false}, {"DEC", 1, 2, 198, true}, {"DEC", 1, 3, 206, true}, {"DEC", 4, 2, 214, true}, {"DEC", 4, 3, 222, true}, {"DEX", 0, 0, 202, true}, {"DEY", 0, 0, 136, true}, {"DOP", 2, 2, 226, false}, {"EOR", 1, 2, 69, true}, {"EOR", 1, 3, 77, true}, {"EOR", 2, 2, 73, true}, {"EOR", 4, 2, 85, true}, {"EOR", 4, 3, 93, true}, {"EOR", 5, 3, 89, true}, {"EOR", 6, 2, 65, true}, {"EOR", 7, 2, 81, true}, {"INC", 1, 2, 230, true}, {"INC", 1, 3, 238, true}, {"INC", 4, 2, 246, true}, {"INC", 4, 3, 254, true}, {"INX", 0, 0, 232, true}, {"INY", 0, 0, 200, true}, {"ISB", 1, 2, 231, false}, {"ISB", 1, 3, 239, false}, {"ISB", 4, 2, 247, false}, {"ISB", 4, 3, 255, false}, {"ISB", 5, 3, 251, false}, {"ISB", 6, 2, 227, false}, {"ISB", 7, 2, 243, false}, {"JMP", 1, 3, 76, true}, {"JMP", 3, 3, 108, true}, {"JSR", 1, 3, 32, true}, {"KIL", 0, 0, 242, false}, {"LAR", 5, 3, 187, false}, {"LAX", 1, 2, 167, false}, {"LAX", 1, 3, 175, false}, {"LAX", 5, 2, 183, false}, {"LAX", 5, 3, 191, false}, {"LAX", 6, 2, 163, false}, {"LAX", 7, 2, 179, false}, {"LDA", 1, 2, 165, true}, {"LDA", 1, 3, 173, true}, {"LDA", 2, 2, 169, true}, {"LDA", 4, 2, 181, true}, {"LDA", 4, 3, 189, true}, {"LDA", 5, 3, 185, true}, {"LDA", 6, 2, 161, true}, {"LDA", 7, 2, 177, true}, {"LDX", 1, 2, 166, true}, {"LDX", 1, 3, 174, true}, {"LDX", 2, 2, 162, true}, {"LDX", 5, 2, 182, true}, {"LDX", 5, 3, 190, true}, {"LDY", 1, 2, 164, true}, {"LDY", 1, 3, 172, true}, {"LDY", 2, 2, 160, true}, {"LDY", 4, 2, 180, true}, {"LDY", 4, 3, 188, true}, {"LSR", 1, 1, 74, true}, {"LSR", 1, 2, 70, true}, {"LSR", 1, 3, 78, true}, {"LSR", 4, 2, 86, true}, {"LSR", 4, 3, 94, true}, {"NOP", 0, 0, 234, true}, {"NOP", 1, 2, 100, false}, {"NOP", 1, 3, 12, false}, {"NOP", 2, 2, 128, false}, {"NOP", 4, 2, 244, false}, {"NOP", 4, 3, 252, false}, {"ORA", 1, 2, 5, true}, {"ORA", 1, 3, 13, true}, {"ORA", 2, 2, 9, true}, {"ORA", 4, 2, 21, true}, {"ORA", 4, 3, 29, true}, {"ORA", 5, 3, 25, true}, {"ORA", 6, 2, 1, true}, {"ORA", 7, 2, 17, true}, {"PHA", 0, 0, 72, true}, {"PHP", 0, 0, 8, true}, {"PLA", 0, 0, 104, true}, {"PLP", 0, 0, 40, true}, {"RLA", 1, 2, 39, false}, {"RLA", 1, 3, 47, false}, {"RLA", 4, 2, 55, false}, {"RLA", 4, 3, 63, false}, {"RLA", 5, 3, 59, false}, {"RLA", 6, 2, 35, false}, {"RLA", 7, 2, 51, false}, {"ROL", 1, 1, 42, true}, {"ROL", 1, 2, 38, true}, {"ROL", 1, 3, 46, true}, {"ROL", 4, 2, 54, true}, {"ROL", 4, 3, 62, true}, {"ROR", 1, 1, 106, true}, {"ROR", 1, 2, 102, true}, {"ROR", 1, 3, 110, true}, {"ROR", 4, 2, 118, true}, {"ROR", 4, 3, 126, true}, {"RRA", 1, 2, 103, false}, {"RRA", 1, 3, 111, false}, {"RRA", 4, 2, 119, false}, {"RRA", 4, 3, 127, false}, {"RRA", 5, 3, 123, false}, {"RRA", 6, 2, 99, false}, {"RRA", 7, 2, 115, false}, {"RTI", 0, 0, 64, true}, {"RTS", 0, 0, 96, true}, {"SAX", 1, 2, 135, false}, {"SAX", 1, 3, 143, false}, {"SAX", 5, 2, 151, false}, {"SAX", 6, 2, 131, false}, {"SBC", 1, 2, 229, true}, {"SBC", 1, 3, 237, true}, {"SBC", 2, 2, 233, true}, {"SBC", 4, 2, 245, true}, {"SBC", 4, 3, 253, true}, {"SBC", 5, 3, 249, true}, {"SBC", 6, 2, 225, true}, {"SBC", 7, 2, 241, true}, {"SEC", 0, 0, 56, true}, {"SED", 0, 0, 248, true}, {"SEI", 0, 0, 120, true}, {"SHA", 5, 3, 159, false}, {"SHA", 7, 2, 147, false}, {"SHX", 5, 3, 158, false}, {"SHY", 4, 3, 156, false}, {"SLO", 1, 2, 7, false}, {"SLO", 1, 3, 15, false}, {"SLO", 4, 2, 23, false}, {"SLO", 4, 3, 31, false}, {"SLO", 5, 3, 27, false}, {"SLO", 6, 2, 3, false}, {"SLO", 7, 2, 19, false}, {"SRE", 1, 2, 71, false}, {"SRE", 1, 3, 79, false}, {"SRE", 4, 2, 87, false}, {"SRE", 4, 3, 95, false}, {"SRE", 5, 3, 91, false}, {"SRE", 6, 2, 67, false}, {"SRE", 7, 2, 83, false}, {"STA", 1, 2, 133, true}, {"STA", 1, 3, 141, true}, {"STA", 4, 2, 149, true}, {"STA", 4, 3, 157, true}, {"STA", 5, 3, 153, true}, {"STA", 6, 2, 129, true}, {"STA", 7, 2, 145, true}, {"STX", 1, 2, 134, true}, {"STX", 1, 3, 142, true}, {"STX", 5, 2, 150, true}, {"STY", 1, 2, 132, true}, {"STY", 1, 3, 140, true}, {"STY", 4, 2, 148, true}, {"TAX", 0, 0, 170, true}, {"TAY", 0, 0, 168, true}, {"TSX", 0, 0, 186, true}, {"TXA", 0, 0, 138, true}, {"TXS", 0, 0, 154, true}, {"TYA", 0, 0, 152, true}, {"XAA", 2, 2, 139, false}, {"XAS", 5, 3, 155, false}};
    private static final String[][] ALIASES = new String[][]{{"AAC", "ANC"}, {"SAX", "AAX", "AXS"}, {"ASR", "ALR"}, {"ATX", "LXA", "OAL"}, {"AXA", "SHA", "AXA"}, {"AXS", "SBX", "SAX"}, {"DCP", "DCM"}, {"ISC", "ISB", "INS"}, {"KIL", "JAM", "HLT"}, {"LAR", "LAE", "LAS"}, {"NOP", "TOP", "SKW", "DOP", "SKB"}, {"SLO", "ASO"}, {"SRE", "LSE"}, {"SXA", "SHX", "XAS"}, {"SYA", "SHY", "SAY"}, {"XAA", "ANE"}, {"XAS", "SHS", "TAS"}};
    private static final String[] BRANCH_NAMES = new String[]{"BPL", "BMI", "BVC", "BVS", "BCC", "BCS", "BNE", "BEQ"};
    private static final String[] PATTERN_STRINGS = new String[]{"MNE", "MNE L", "MNE #L", "MNE ( L )", "MNE L , X", "MNE L , Y", "MNE ( L , X )", "MNE ( L ) , Y"};
    private static final Pattern[] PATTERNS = new Pattern[PATTERN_STRINGS.length];
    private static final Map<InstructionKey, Integer> officialOpcodes = new HashMap<InstructionKey, Integer>();
    private static final Map<InstructionKey, Integer> allOpcodes = new HashMap<InstructionKey, Integer>();
    private static final Set<String> branchNames = new HashSet<String>();
    private static final String DATA_STRING = "\\s+#?([\\$|%|-]?\\w+)";
    private static final Pattern BYTE_PATTERN = Pattern.compile("\\.BYTE\\s+#?([\\$|%|-]?\\w+)");
    private static final Pattern WORD_PATTERN = Pattern.compile("\\.WORD\\s+#?([\\$|%|-]?\\w+)");

    public static int[] assemble(String code) throws MessageException {
        ArrayList<Integer> hex = new ArrayList<Integer>();
        CodeLabel codeLabel = new CodeLabel();
        InstructionKey key = new InstructionKey();
        if (code != null) {
            String[] lines = code.split("\n|\r");
            HashMap<String, Integer> labels = new HashMap<String, Integer>();
            for (String line : lines) {
                Assembler.processLine(hex, line, codeLabel, key, labels, true);
            }
            hex.clear();
            for (String line : lines) {
                Assembler.processLine(hex, line, codeLabel, key, labels, false);
            }
        }
        int[] values = new int[hex.size()];
        for (int i = 0; i < hex.size(); ++i) {
            values[i] = (Integer)hex.get(i);
        }
        return values;
    }

    private static CodeLabel parseLabel(String label) {
        CodeLabel codeLabel = new CodeLabel();
        Assembler.parseLabel(label, codeLabel);
        return codeLabel;
    }

    private static void parseBase(String label, CodeLabel codeLabel, int base, boolean isWord) {
        try {
            int value = Integer.parseInt(label, base);
            if (base == 10 && value < 0) {
                if (isWord) {
                    value &= 0xFFFF;
                } else if (value >= -128) {
                    value &= 0xFF;
                } else if (value >= Short.MIN_VALUE) {
                    value &= 0xFFFF;
                }
            }
            codeLabel.setValue(value);
            if (value >= 0) {
                if (value <= 255 && !isWord) {
                    codeLabel.setType(2);
                    if (base == 2) {
                        if (label.length() > 8) {
                            codeLabel.setType(3);
                        }
                    } else if (base == 16 && label.length() > 2) {
                        codeLabel.setType(3);
                    }
                } else if (value <= 65535) {
                    codeLabel.setType(3);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void parseLabel(String label, CodeLabel codeLabel) {
        Assembler.parseLabel(label, codeLabel, false);
    }

    private static void parseLabel(String label, CodeLabel codeLabel, boolean isWord) {
        codeLabel.setType(0);
        if (StringUtil.isBlank(label)) {
            return;
        }
        if (label.equals("A")) {
            codeLabel.setType(1);
        } else if (label.startsWith("$")) {
            Assembler.parseBase(label.substring(1), codeLabel, 16, isWord);
        } else if (label.startsWith("%")) {
            Assembler.parseBase(label.substring(1), codeLabel, 2, isWord);
        } else if (label.startsWith("0")) {
            Assembler.parseBase(label.equals("0") ? label : label.substring(1), codeLabel, 8, isWord);
        } else if (label.charAt(0) == '-' || Character.isDigit(label.charAt(0))) {
            Assembler.parseBase(label, codeLabel, 10, isWord);
        } else {
            codeLabel.setType(4);
            codeLabel.setName(label);
        }
    }

    private static void processLine(List<Integer> hex, String line, CodeLabel codeLabel, InstructionKey key, Map<String, Integer> labels, boolean findingLabels) throws MessageException {
        Integer opCode;
        int patternIndex;
        Matcher matcher;
        block31: {
            codeLabel.setType(0);
            codeLabel.setName(null);
            if (line == null) {
                return;
            }
            if ((line = line.trim().toUpperCase(Locale.ENGLISH)).isEmpty()) {
                return;
            }
            int semicolonIndex = line.indexOf(59);
            if (semicolonIndex >= 0 && (line = line.substring(0, semicolonIndex).trim()).isEmpty()) {
                return;
            }
            int colonIndex = line.indexOf(":");
            if (colonIndex >= 0) {
                if (findingLabels) {
                    String label = line.substring(0, colonIndex);
                    if (labels.containsKey(label)) {
                        Assembler.throwParseException(line, "Duplicate label: " + label);
                    }
                    labels.put(label, hex.size());
                }
                if ((line = line.substring(colonIndex + 1).trim()).isEmpty()) {
                    return;
                }
            }
            matcher = null;
            matcher = BYTE_PATTERN.matcher(line);
            if (matcher.find()) {
                Assembler.parseLabel(matcher.group(1), codeLabel);
                if (codeLabel.getType() != 2) {
                    Assembler.throwParseException(line, "Invalid byte.");
                }
                hex.add(codeLabel.getValue() & 0xFF);
                return;
            }
            matcher = WORD_PATTERN.matcher(line);
            if (matcher.find()) {
                Assembler.parseLabel(matcher.group(1), codeLabel, true);
                if (codeLabel.getType() != 3) {
                    Assembler.throwParseException(line, "Invalid word.");
                }
                hex.add(codeLabel.getValue() & 0xFF);
                hex.add(codeLabel.getValue() >> 8 & 0xFF);
                return;
            }
            patternIndex = 0;
            for (int i = PATTERNS.length - 1; i >= 0; --i) {
                matcher = PATTERNS[i].matcher(line);
                if (!matcher.find()) continue;
                patternIndex = i;
                break block31;
            }
            Assembler.throwParseException(line, "Unrecognized syntax.");
        }
        String mnemonic = matcher.group(1);
        boolean isBranchInstruction = branchNames.contains(mnemonic);
        int labelType = 0;
        if (patternIndex > 0) {
            Assembler.parseLabel(matcher.group(2), codeLabel);
            labelType = codeLabel.getType();
        }
        key.setMnemonic(mnemonic);
        key.setPatternIndex(patternIndex);
        key.setLabelType(labelType);
        boolean isLabeledBranch = false;
        if (codeLabel.getType() == 4) {
            if (isBranchInstruction && patternIndex == 1) {
                key.setLabelType(2);
                isLabeledBranch = true;
            } else {
                Assembler.throwParseException(line, "Label support is limited to conditional branch instructions.");
            }
        }
        if ((opCode = officialOpcodes.get(key)) == null) {
            opCode = allOpcodes.get(key);
        }
        if (opCode == null && labelType == 2) {
            labelType = 3;
            key.setLabelType(labelType);
            opCode = officialOpcodes.get(key);
            if (opCode == null) {
                opCode = allOpcodes.get(key);
            }
        }
        if (opCode == null) {
            Assembler.throwParseException(line, "Unknown mnemonic or missing operand.");
        }
        hex.add(opCode);
        if (isLabeledBranch) {
            Integer offset = labels.get(codeLabel.getName());
            if (offset == null && findingLabels) {
                offset = 0;
            }
            if (offset == null) {
                Assembler.throwParseException(line, "Unknown label: <code>" + codeLabel.getName() + "</code>");
            } else {
                int value = offset - hex.size() - 1;
                if (value < -128 || value > 127) {
                    Assembler.throwParseException(line, "Label is out of range.");
                } else {
                    hex.add(value & 0xFF);
                }
            }
        } else {
            switch (labelType) {
                case 2: {
                    hex.add(codeLabel.getValue() & 0xFF);
                    break;
                }
                case 3: {
                    hex.add(codeLabel.getValue() & 0xFF);
                    hex.add(codeLabel.getValue() >> 8 & 0xFF);
                }
            }
        }
    }

    private static void throwParseException(String line, String reason) throws MessageException {
        throw new MessageException("<html>Failed to parse: <code>%s</code><br/>%s</html>", line, reason);
    }

    static {
        for (String branchName : BRANCH_NAMES) {
            branchNames.add(branchName);
        }
        HashMap<String, String[]> aliases = new HashMap<String, String[]>();
        String[][] stringArray = ALIASES;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] as;
            for (String alias : as = stringArray[i]) {
                aliases.put(alias, as);
            }
        }
        for (int i = PATTERN_STRINGS.length - 1; i >= 0; --i) {
            Assembler.PATTERNS[i] = Pattern.compile(PATTERN_STRINGS[i].replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\s+", "\\\\s*").replaceAll("MNE", "(\\\\p{Alpha}{3})").replaceAll("L", "([\\\\\\$|%|-]?\\\\w+)"));
        }
        String[] list = new String[1];
        for (Object[] instruction : INSTRUCTIONS) {
            String mnemonic = (String)instruction[0];
            String[] as = (String[])aliases.get(mnemonic);
            if (as == null) {
                as = list;
                as[0] = mnemonic;
            }
            block5: for (String a : as) {
                InstructionKey key = new InstructionKey(a, (Integer)instruction[1], (Integer)instruction[2]);
                while (true) {
                    int opCode = (Integer)instruction[3];
                    allOpcodes.put(key, opCode);
                    if (((Boolean)instruction[4]).booleanValue()) {
                        officialOpcodes.put(key, opCode);
                    }
                    if (key.getLabelType() != 1) continue block5;
                    key = new InstructionKey(key.getMnemonic(), key.getPatternIndex(), 0);
                }
            }
        }
    }
}

