/*
 * Decompiled with CFR 0.152.
 */
package nintaco.disassembler;

import java.awt.EventQueue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import nintaco.App;
import nintaco.CPU;
import nintaco.PPU;
import nintaco.disassembler.Disassembler;
import nintaco.disassembler.LogPrefs;
import nintaco.disassembler.LogRecord;
import nintaco.files.FileUtil;
import nintaco.gui.debugger.DebuggerFrame;
import nintaco.gui.debugger.logger.LoggerAppPrefs;
import nintaco.mappers.Mapper;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.ThreadUtil;

public class TraceLogger {
    private static final int LOG_RECORDS = 4096;
    private final Object MONITOR = new Object();
    final StringBuilder sb = new StringBuilder();
    private final LogPrefs logPrefs;
    private final LogRecord[] logRecords = new LogRecord[4096];
    private final int maxLines;
    private volatile PrintWriter out;
    private volatile Thread thread;
    private volatile boolean running = true;
    private volatile int writeHead;
    private volatile int readHead;
    private volatile int size;
    private boolean beforeCycle = true;
    private int lines;

    public TraceLogger() {
        LoggerAppPrefs appPrefs = AppPrefs.getInstance().getLoggerAppPrefs();
        this.maxLines = appPrefs.getMaxLines();
        this.logPrefs = appPrefs.getLogPrefs();
        int[] addresses = this.logPrefs.addresses;
        for (int i = this.logRecords.length - 1; i >= 0; --i) {
            this.logRecords[i] = new LogRecord();
            if (addresses == null) continue;
            this.logRecords[i].values = new int[addresses.length];
        }
        try {
            File file = new File(GamePrefs.getInstance().getLoggerGamePrefs().getFileName());
            FileUtil.mkdir(file.getParent());
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        this.thread = new Thread(this::readLoop, "Trace Logger Thread");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(boolean beforeExecute, CPU cpu, PPU ppu, Mapper mapper) {
        Object object;
        if (!this.running || beforeExecute != this.beforeCycle) {
            return;
        }
        boolean bl = this.beforeCycle = !this.beforeCycle;
        if (beforeExecute) {
            object = this.MONITOR;
            synchronized (object) {
                while (this.running && this.size == 4096) {
                    ThreadUtil.threadWait(this.MONITOR);
                }
            }
            if (!this.running) {
                return;
            }
            if (++this.writeHead == 4096) {
                this.writeHead = 0;
            }
            Disassembler.captureInstruction(this.logRecords[this.writeHead], cpu, ppu, mapper);
        }
        if (beforeExecute == this.logPrefs.logBeforeExecute) {
            Disassembler.captureRegisters(this.logPrefs, this.logRecords[this.writeHead], cpu, ppu, mapper);
        }
        if (!beforeExecute) {
            object = this.MONITOR;
            synchronized (object) {
                ++this.size;
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLoop() {
        while (this.running) {
            Object object = this.MONITOR;
            synchronized (object) {
                while (this.running && this.size == 0) {
                    ThreadUtil.threadWait(this.MONITOR);
                }
            }
            if (!this.running) {
                return;
            }
            if (++this.readHead >= 4096) {
                this.readHead = 0;
            }
            this.persistLogRecord(this.logRecords[this.readHead]);
            object = this.MONITOR;
            synchronized (object) {
                --this.size;
                this.MONITOR.notifyAll();
            }
        }
        this.close();
    }

    private void persistLogRecord(LogRecord logRecord) {
        try {
            PrintWriter o = this.out;
            if (o != null) {
                this.sb.setLength(0);
                Disassembler.appendLogRecord(this.sb, logRecord, this.logPrefs);
                this.out.println(this.sb);
                if (++this.lines == this.maxLines) {
                    this.running = false;
                    App.disposeTraceLogger();
                    DebuggerFrame debugger = App.getDebuggerFrame();
                    if (debugger != null) {
                        EventQueue.invokeLater(debugger::updateLoggerButton);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.running = false;
        }
    }

    public void flush() {
        try {
            PrintWriter o = this.out;
            if (o != null) {
                o.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void close() {
        try {
            PrintWriter o = this.out;
            this.out = null;
            if (o != null) {
                o.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.close();
        Thread t = this.thread;
        if (t != null) {
            this.thread = null;
            Object object = this.MONITOR;
            synchronized (object) {
                this.running = false;
                this.MONITOR.notifyAll();
            }
            ThreadUtil.join(t);
        }
    }
}

