/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class ArchiveEntry {
    public static final Comparator<ArchiveEntry> CASE_INSENSITIVE_ORDER = (a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.name, b.name);
    private final String name;
    private final long size;
    private final int hash;

    public static List<String> toNames(List<ArchiveEntry> archiveEntries) {
        if (archiveEntries == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        int length = archiveEntries.size();
        for (int i = 0; i < length; ++i) {
            names.add(archiveEntries.get((int)i).name);
        }
        return names;
    }

    public ArchiveEntry(String name, long size) {
        this.name = name;
        this.size = size;
        this.hash = 89 * (623 + Objects.hashCode(name)) + (int)(size ^ size >>> 32);
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        ArchiveEntry entry = (ArchiveEntry)obj;
        return this.size == entry.size && Objects.equals(this.name, entry.name);
    }

    public String toString() {
        return String.format("[ %s %d ]", this.name, this.size);
    }
}

