/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import nintaco.MessageException;
import nintaco.files.FileUtil;
import nintaco.files.IFile;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;
import nintaco.util.StreamUtil;
import nintaco.util.StringUtil;

public class NsfFile
implements IFile,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final String NSF_HEADER_ID = "NESM\u001a";
    public static final String NSFE_HEADER_ID = "NSFE";
    public static final String DEFAULT_TEXT = "<?>";
    private static final int MIN_DATA_SIZE = 32768;
    private static final int MAX_DATA_SIZE = 0x100000;
    private final String fileName;
    private final String entryFileName;
    private final String archiveFileName;
    private int version;
    private int ntscPlaySpeed;
    private int palPlaySpeed;
    private boolean infoChunkRead;
    private int loadAddress;
    private int initAddress;
    private int playAddress;
    private TVSystem tvSystem;
    private int chipCount;
    private boolean usesVRC6Audio;
    private boolean usesVRC7Audio;
    private boolean usesFdsAudio;
    private boolean usesMMC5Audio;
    private boolean usesNamco163Audio;
    private boolean usesSunsoft5BAudio;
    private int totalSongs;
    private int startingSong;
    private byte[] data;
    private boolean bankSwitched;
    private final int[] initBanks = new int[8];
    private int[] playlist;
    private long[] trackMillis;
    private long[] fadeMillis;
    private String[] trackLabels;
    private String[] albumInfo;
    private String text;
    private String description;
    private int dataSize;
    private transient int[] prgROM;

    public NsfFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName) throws Throwable {
        this.entryFileName = entryFileName;
        this.archiveFileName = archiveFileName;
        this.fileName = FileUtil.getFileName(entryFileName).toLowerCase(Locale.ENGLISH);
        for (int i = this.initBanks.length - 1; i >= 0; --i) {
            this.initBanks[i] = i;
        }
        int[] headerID = new int[5];
        StreamUtil.readByteArray(in, headerID, 0, 4, true);
        if (StringUtil.compareStrings(NSFE_HEADER_ID, headerID)) {
            this.readNSFe(in);
        } else {
            headerID[4] = in.readUnsignedByte();
            if (StringUtil.compareStrings(NSF_HEADER_ID, headerID)) {
                this.readNSF(fileSize, in);
            } else {
                throw new MessageException("Not NSF or NSFe file format.");
            }
        }
    }

    private void readNSF(long fileSize, DataInputStream in) throws Throwable {
        int i;
        block3: {
            this.version = in.readUnsignedByte();
            this.totalSongs = in.readUnsignedByte();
            this.startingSong = Math.max(0, in.readUnsignedByte() - 1);
            this.readAddresses(in);
            this.albumInfo = new String[4];
            for (i = 0; i < 3; ++i) {
                this.albumInfo[i] = StreamUtil.readNullTerminatedString(in, 32);
            }
            this.ntscPlaySpeed = StreamUtil.readInt16LE(in);
            StreamUtil.readByteArray(in, this.initBanks);
            for (i = this.initBanks.length - 1; i >= 0; --i) {
                if (this.initBanks[i] == 0) continue;
                this.bankSwitched = true;
                break block3;
            }
            this.bankSwitched = false;
        }
        this.palPlaySpeed = StreamUtil.readInt16LE(in);
        this.readTvSystem(in);
        this.readChips(in);
        for (i = 0; i < 4; ++i) {
            in.readUnsignedByte();
        }
        this.dataSize = (int)fileSize - 128;
        this.prgROM = new int[MathUtil.roundUp((this.loadAddress & 0xFFF) + this.dataSize, 4096)];
        StreamUtil.readByteArray(in, this.prgROM, this.loadAddress & 0xFFF, this.dataSize, true);
        this.makeAdjustments();
        this.createDescription();
    }

    private void readNSFe(DataInputStream in) throws Throwable {
        block24: while (true) {
            String chunkID;
            int chunkLength = StreamUtil.readInt32LE(in);
            switch (chunkID = StreamUtil.readString(in, 4)) {
                case "INFO": {
                    this.readInfoChunk(in, chunkLength);
                    break;
                }
                case "DATA": {
                    this.readDataChunk(in, chunkLength);
                    break;
                }
                case "NEND": {
                    break block24;
                }
                case "BANK": {
                    this.readBankChunk(in, chunkLength);
                    break;
                }
                case "plst": {
                    this.readPlaylistChunk(in, chunkLength);
                    break;
                }
                case "time": {
                    this.readTimeChunk(in, chunkLength);
                    break;
                }
                case "fade": {
                    this.readFadeChunk(in, chunkLength);
                    break;
                }
                case "tlbl": {
                    this.readTrackLabelChunk(in, chunkLength);
                    break;
                }
                case "auth": {
                    this.readAuthorChunk(in, chunkLength);
                    break;
                }
                case "text": {
                    this.readTextChunk(in, chunkLength);
                    break;
                }
                default: {
                    throw new IOException("Unknown chunk type: " + chunkID);
                }
            }
        }
        this.init();
        this.createDescription();
    }

    private void readAddresses(DataInputStream in) throws Throwable {
        this.loadAddress = StreamUtil.readInt16LE(in);
        this.initAddress = StreamUtil.readInt16LE(in);
        this.playAddress = StreamUtil.readInt16LE(in);
    }

    private void readTvSystem(DataInputStream in) throws Throwable {
        int tv = in.readUnsignedByte();
        this.tvSystem = BitUtil.getBitBool(tv, 0) ? TVSystem.PAL : TVSystem.NTSC;
    }

    private void readChips(DataInputStream in) throws Throwable {
        int chips = in.readUnsignedByte();
        this.chipCount = Integer.bitCount(chips & 0x3F);
        this.usesVRC6Audio = BitUtil.getBitBool(chips, 0);
        this.usesVRC7Audio = BitUtil.getBitBool(chips, 1);
        this.usesFdsAudio = BitUtil.getBitBool(chips, 2);
        this.usesMMC5Audio = BitUtil.getBitBool(chips, 3);
        this.usesNamco163Audio = BitUtil.getBitBool(chips, 4);
        this.usesSunsoft5BAudio = BitUtil.getBitBool(chips, 5);
    }

    private void readInfoChunk(DataInputStream in, int chunkLength) throws Throwable {
        this.readAddresses(in);
        this.readTvSystem(in);
        this.readChips(in);
        this.totalSongs = in.readUnsignedByte();
        if (chunkLength > 9) {
            this.startingSong = in.readUnsignedByte();
        }
        this.discardRemainingChunk(in, chunkLength, 10);
        this.infoChunkRead = true;
    }

    private void discardRemainingChunk(DataInputStream in, int chunkLength, int expectedMaxLength) throws Throwable {
        if (chunkLength > expectedMaxLength) {
            chunkLength -= expectedMaxLength;
            do {
                in.readUnsignedByte();
            } while (--chunkLength > 0);
        }
    }

    private void readDataChunk(DataInputStream in, int chunkLength) throws Throwable {
        this.dataSize = Math.min(chunkLength, 0x100000);
        this.data = new byte[this.dataSize];
        in.readFully(this.data);
        this.discardRemainingChunk(in, chunkLength, 0x100000);
    }

    private void readBankChunk(DataInputStream in, int chunkLength) throws Throwable {
        this.bankSwitched = true;
        int size = Math.min(this.initBanks.length, chunkLength);
        for (int i = 0; i < size; ++i) {
            this.initBanks[i] = in.readUnsignedByte();
        }
        this.discardRemainingChunk(in, chunkLength, this.initBanks.length);
    }

    private void readPlaylistChunk(DataInputStream in, int chunkLength) throws Throwable {
        this.playlist = new int[chunkLength];
        StreamUtil.readByteArray(in, this.playlist);
    }

    private void readTimeChunk(DataInputStream in, int chunkLength) throws Throwable {
        if ((chunkLength & 3) != 0) {
            throw new IOException(String.format("The time chunk length, %d, is not divisible by 4.", chunkLength));
        }
        this.trackMillis = new long[chunkLength >> 2];
        for (int i = 0; i < this.trackMillis.length; ++i) {
            this.trackMillis[i] = StreamUtil.readInt32LE(in);
        }
    }

    private void readFadeChunk(DataInputStream in, int chunkLength) throws Throwable {
        if ((chunkLength & 3) != 0) {
            throw new IOException(String.format("The fade chunk length, %d, is not divisible by 4.", chunkLength));
        }
        this.fadeMillis = new long[chunkLength >> 2];
        for (int i = 0; i < this.fadeMillis.length; ++i) {
            this.fadeMillis[i] = StreamUtil.readInt32LE(in);
        }
    }

    private void readTrackLabelChunk(DataInputStream in, int chunkLength) throws Throwable {
        this.trackLabels = StreamUtil.readNullTerminatedStrings(in, chunkLength);
    }

    private void readAuthorChunk(DataInputStream in, int chunkLength) throws Throwable {
        this.albumInfo = StreamUtil.readNullTerminatedStrings(in, chunkLength, 4);
    }

    private void readTextChunk(DataInputStream in, int chunkLength) throws Throwable {
        this.text = StreamUtil.readNullTerminatedString(in, chunkLength);
    }

    private String setDefaultText(String str) {
        return StringUtil.isBlank(str) ? DEFAULT_TEXT : str;
    }

    private long[] adjustSize(long[] values) {
        if (values == null) {
            values = new long[this.totalSongs];
            Arrays.fill(values, -1L);
            return values;
        }
        if (values.length == this.totalSongs) {
            return values;
        }
        long[] vs = new long[this.totalSongs];
        System.arraycopy(values, 0, vs, 0, Math.min(this.totalSongs, values.length));
        for (int i = values.length; i < this.totalSongs; ++i) {
            vs[i] = -1L;
        }
        return vs;
    }

    private String[] adjustSize(String[] values) {
        return this.adjustSize(values, this.totalSongs);
    }

    private String[] adjustSize(String[] values, int expectedSize) {
        if (values == null) {
            values = new String[expectedSize];
            Arrays.fill(values, DEFAULT_TEXT);
            return values;
        }
        if (values.length != expectedSize) {
            String[] ss = new String[expectedSize];
            System.arraycopy(values, 0, ss, 0, Math.min(expectedSize, values.length));
            for (int i = values.length; i < expectedSize; ++i) {
                ss[i] = DEFAULT_TEXT;
            }
            values = ss;
        }
        for (int i = values.length - 1; i >= 0; --i) {
            values[i] = StringUtil.removeNewlines(this.setDefaultText(values[i]));
        }
        return values;
    }

    private void makeAdjustments() throws Throwable {
        if (this.totalSongs <= 0) {
            throw new IOException("No songs to play.");
        }
        this.trackMillis = this.adjustSize(this.trackMillis);
        this.fadeMillis = this.adjustSize(this.fadeMillis);
        this.trackLabels = this.adjustSize(this.trackLabels);
        this.albumInfo = this.adjustSize(this.albumInfo, 4);
        this.text = StringUtil.replaceNewlines(this.setDefaultText(this.text));
        if (this.playlist == null) {
            this.playlist = new int[0];
        }
    }

    private void init() throws Throwable {
        if (!this.infoChunkRead) {
            throw new IOException("The file header is missing the INFO chunk.");
        }
        if (this.data == null) {
            throw new IOException("The file header is missing the DATA chunk.");
        }
        this.prgROM = new int[MathUtil.roundUp((this.loadAddress & 0xFFF) + this.dataSize, 4096)];
        int offset = this.loadAddress & 0xFFF;
        for (int i = this.dataSize - 1; i >= 0; --i) {
            this.prgROM[offset + i] = this.data[i] & 0xFF;
        }
        this.makeAdjustments();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getVersion() {
        return this.version;
    }

    public int[] getPlaylist() {
        return this.playlist;
    }

    public long[] getTrackMillis() {
        return this.trackMillis;
    }

    public long[] getFadeMillis() {
        return this.fadeMillis;
    }

    public String[] getTrackLabels() {
        return this.trackLabels;
    }

    public String[] getAlbumInfo() {
        return this.albumInfo;
    }

    public String getText() {
        return this.text;
    }

    public int getTotalSongs() {
        return this.totalSongs;
    }

    public int getStartingSong() {
        return this.startingSong;
    }

    public int getLoadAddress() {
        return this.loadAddress;
    }

    public int getInitAddress() {
        return this.initAddress;
    }

    public int getPlayAddress() {
        return this.playAddress;
    }

    public int getNtscPlaySpeed() {
        return this.ntscPlaySpeed;
    }

    public boolean isBankSwitched() {
        return this.bankSwitched;
    }

    public int[] getInitBanks() {
        return this.initBanks;
    }

    public int getPalPlaySpeed() {
        return this.palPlaySpeed;
    }

    public TVSystem getTvSystem() {
        return this.tvSystem;
    }

    public int getChipCount() {
        return this.chipCount;
    }

    public boolean usesVRC6Audio() {
        return this.usesVRC6Audio;
    }

    public boolean usesVRC7Audio() {
        return this.usesVRC7Audio;
    }

    public boolean usesFdsAudio() {
        return this.usesFdsAudio;
    }

    public boolean usesMMC5Audio() {
        return this.usesMMC5Audio;
    }

    public boolean usesNamco163Audio() {
        return this.usesNamco163Audio;
    }

    public boolean usesSunsoft5BAudio() {
        return this.usesSunsoft5BAudio;
    }

    public int[] getPrgROM() {
        return this.prgROM;
    }

    public boolean isExtendedNSF() {
        return this.infoChunkRead;
    }

    public String getEntryFileName() {
        return this.entryFileName;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public boolean isUsesVRC6Audio() {
        return this.usesVRC6Audio;
    }

    public boolean isUsesVRC7Audio() {
        return this.usesVRC7Audio;
    }

    public boolean isUsesFdsAudio() {
        return this.usesFdsAudio;
    }

    public boolean isUsesMMC5Audio() {
        return this.usesMMC5Audio;
    }

    public boolean isUsesNamco163Audio() {
        return this.usesNamco163Audio;
    }

    public boolean isUsesSunsoft5BAudio() {
        return this.usesSunsoft5BAudio;
    }

    public long getSongMillis(int songIndex) {
        long trackLength = this.trackMillis[songIndex];
        long fadeLength = this.fadeMillis[songIndex];
        if (trackLength < 0L) {
            return fadeLength;
        }
        if (fadeLength < 0L) {
            return trackLength;
        }
        return trackLength + fadeLength;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.prgROM = StreamUtil.readByteArray(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        StreamUtil.writeByteArray(out, this.prgROM);
    }

    private String formatMillis(long millis) {
        if (millis < 0L) {
            return "NA";
        }
        return Long.toString(millis) + " millis";
    }

    private void createDescription() {
        int i;
        StringBuilder sb = new StringBuilder();
        StringUtil.appendLine(sb, "File name: %s", this.fileName);
        if (!this.isExtendedNSF()) {
            StringUtil.appendLine(sb, "Version: %d", this.version);
        }
        StringUtil.appendLine(sb, "Data size: %d bytes", this.dataSize);
        StringUtil.appendLine(sb, "Total songs: %d", this.totalSongs);
        StringUtil.appendLine(sb, "Starting song: %d", this.startingSong);
        sb.append(String.format("Bank switched: %b", this.bankSwitched));
        if (this.bankSwitched) {
            sb.append(" (");
            for (i = 0; i < this.initBanks.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02x", this.initBanks[i]));
            }
            StringUtil.appendLine(sb, ")", new Object[0]);
        } else {
            StringUtil.appendLine(sb);
        }
        StringUtil.appendLine(sb, "Load address: %04X", this.loadAddress);
        StringUtil.appendLine(sb, "Init address: %04X", this.initAddress);
        StringUtil.appendLine(sb, "Play address: %04X", this.playAddress);
        sb.append("Play list: ");
        if (this.playlist.length == 0) {
            StringUtil.appendLine(sb, "none", new Object[0]);
        } else {
            for (i = 0; i < this.playlist.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(this.playlist[i]);
            }
            StringUtil.appendLine(sb);
        }
        StringUtil.appendLine(sb, "Album info:", new Object[0]);
        StringUtil.appendLine(sb, "  Game title: %s", this.albumInfo[0]);
        StringUtil.appendLine(sb, "  Artist: %s", this.albumInfo[1]);
        StringUtil.appendLine(sb, "  Copyright: %s", this.albumInfo[2]);
        StringUtil.appendLine(sb, "  Ripper: %s", this.albumInfo[3]);
        StringUtil.appendLine(sb, "Tracks:", new Object[0]);
        for (i = 0; i < this.totalSongs; ++i) {
            StringUtil.appendLine(sb, "  %d. %s (length: %s, fade: %s)", i, this.trackLabels[i], this.formatMillis(this.trackMillis[i]), this.formatMillis(this.fadeMillis[i]));
        }
        StringUtil.appendLine(sb, "TV System: %s", new Object[]{this.tvSystem});
        if (!this.isExtendedNSF()) {
            StringUtil.appendLine(sb, "NTSC play speed: %d micros", this.ntscPlaySpeed);
            StringUtil.appendLine(sb, "PAL play speed: %d micros", this.palPlaySpeed);
        }
        StringUtil.appendLine(sb, "Text: %s", this.text);
        StringUtil.appendLine(sb, "Chip count: %d", this.chipCount);
        if (this.usesVRC6Audio) {
            StringUtil.appendLine(sb, "  VRC6 Audio", new Object[0]);
        }
        if (this.usesVRC7Audio) {
            StringUtil.appendLine(sb, "  VRC7 Audio", new Object[0]);
        }
        if (this.usesFdsAudio) {
            StringUtil.appendLine(sb, "  FDS Audio", new Object[0]);
        }
        if (this.usesMMC5Audio) {
            StringUtil.appendLine(sb, "  MMC5 Audio", new Object[0]);
        }
        if (this.usesNamco163Audio) {
            StringUtil.appendLine(sb, "  Namco 163 Audio", new Object[0]);
        }
        if (this.usesSunsoft5BAudio) {
            StringUtil.appendLine(sb, "  Sunsoft 5B Audio", new Object[0]);
        }
        this.description = sb.toString();
    }

    @Override
    public int getFileType() {
        return 4;
    }

    public String toString() {
        return this.description;
    }
}

